/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.IconStore;
import org.astrogrid.samp.gui.Transmission;

class TransmissionTableModel
implements TableModel {
    private final List transList_;
    private final List tableListenerList_;
    private final ChangeListener changeListener_;
    private final Column[] columns_;
    private int maxRows_;
    private int removeDelay_;
    public static final TableCellRenderer STATUS_RENDERER = TransmissionTableModel.createStatusCellRenderer();
    private static final TableCellRenderer CLIENT_RENDERER = TransmissionTableModel.createClientCellRenderer();
    static /* synthetic */ Class class$org$astrogrid$samp$gui$TransmissionTableModel;

    public TransmissionTableModel(boolean showSender, boolean showReceiver, int removeDelay, int maxRows) {
        this.removeDelay_ = removeDelay;
        this.maxRows_ = maxRows;
        this.transList_ = new LinkedList();
        this.tableListenerList_ = new ArrayList();
        ArrayList<Column> colList = new ArrayList<Column>();
        int charWidth = 8;
        int icol = 0;
        colList.add(new Column("MType", String.class, new TableColumn(icol++, 30 * charWidth)){

            Object getValue(Transmission trans) {
                return trans.getMessage().getMType();
            }
        });
        if (showSender) {
            colList.add(new Column("Sender", Object.class, new TableColumn(icol++, 20 * charWidth, CLIENT_RENDERER, null)){

                Object getValue(Transmission trans) {
                    return trans.getSender();
                }
            });
        }
        if (showReceiver) {
            colList.add(new Column("Receiver", Object.class, new TableColumn(icol++, 20 * charWidth, CLIENT_RENDERER, null)){

                Object getValue(Transmission trans) {
                    return trans.getReceiver();
                }
            });
        }
        colList.add(new Column("Status", Object.class, new TableColumn(icol++, 16 * charWidth, STATUS_RENDERER, null)){

            Object getValue(Transmission trans) {
                return trans.getStatus();
            }
        });
        this.columns_ = colList.toArray(new Column[0]);
        this.changeListener_ = new ChangeListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void stateChanged(ChangeEvent evt) {
                Object src = evt.getSource();
                if (!$assertionsDisabled && !(src instanceof Transmission)) {
                    throw new AssertionError();
                }
                if (src instanceof Transmission) {
                    TransmissionTableModel.this.transmissionChanged((Transmission)src);
                }
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$gui$TransmissionTableModel == null ? (class$org$astrogrid$samp$gui$TransmissionTableModel = TransmissionTableModel.class$("org.astrogrid.samp.gui.TransmissionTableModel")) : class$org$astrogrid$samp$gui$TransmissionTableModel).desiredAssertionStatus();
            }
        };
    }

    public Transmission getTransmission(int irow) {
        return (Transmission)this.transList_.get(irow);
    }

    public void addTransmission(Transmission trans) {
        while (this.transList_.size() > this.maxRows_) {
            this.transList_.remove(this.maxRows_);
            this.fireTableChanged(new TableModelEvent(this, this.maxRows_, this.maxRows_, -1, -1));
        }
        this.transList_.add(0, trans);
        trans.addChangeListener(this.changeListener_);
        this.fireTableChanged(new TableModelEvent(this, 0, 0, -1, 1));
    }

    public void removeTransmission(final Transmission trans) {
        int index = this.transList_.indexOf(trans);
        if (index >= 0) {
            this.transList_.remove(index);
            this.fireTableChanged(new TableModelEvent(this, index, index, -1, -1));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trans.removeChangeListener(TransmissionTableModel.this.changeListener_);
            }
        });
    }

    public int getColumnCount() {
        return this.columns_.length;
    }

    public int getRowCount() {
        return this.transList_.size();
    }

    public Object getValueAt(int irow, int icol) {
        return this.columns_[icol].getValue(this.getTransmission(irow));
    }

    public String getColumnName(int icol) {
        return this.columns_[icol].name_;
    }

    public Class getColumnClass(int icol) {
        return this.columns_[icol].clazz_;
    }

    public boolean isCellEditable(int irow, int icol) {
        return false;
    }

    public void setValueAt(Object value, int irow, int icol) {
        throw new UnsupportedOperationException();
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tableListenerList_.add(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableListenerList_.remove(listener);
    }

    public TableColumn getTableColumn(int icol) {
        return this.columns_[icol].tcol_;
    }

    private void transmissionChanged(final Transmission trans) {
        int index = this.transList_.indexOf(trans);
        if (index >= 0) {
            this.fireTableChanged(new TableModelEvent(this, index));
            if (trans.isDone() && this.removeDelay_ >= 0) {
                long sinceDone = System.currentTimeMillis() - trans.getDoneTime();
                long delay = (long)this.removeDelay_ - sinceDone;
                if (delay <= 0L) {
                    this.removeTransmission(trans);
                } else {
                    ActionListener remover = new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            TransmissionTableModel.this.removeTransmission(trans);
                        }
                    };
                    new Timer((int)delay + 1, remover).start();
                }
            }
        }
    }

    private void fireTableChanged(TableModelEvent evt) {
        Iterator it = this.tableListenerList_.iterator();
        while (it.hasNext()) {
            ((TableModelListener)it.next()).tableChanged(evt);
        }
    }

    private static TableCellRenderer createStatusCellRenderer() {
        return new CustomTableCellRenderer(){

            void configureLabel(JLabel label, Object value, int height) {
                if (value instanceof Transmission.Status) {
                    Transmission.Status status = (Transmission.Status)value;
                    label.setText(status.getText());
                    label.setIcon(status.getIcon(height));
                }
            }
        };
    }

    private static TableCellRenderer createClientCellRenderer() {
        final IconStore iconStore = new IconStore(IconStore.createEmptyIcon(16));
        return new CustomTableCellRenderer(){

            void configureLabel(JLabel label, Object value, int height) {
                if (value instanceof Client) {
                    Client client = (Client)value;
                    label.setText(client.toString());
                    label.setIcon(ClientListCellRenderer.reshapeIcon(iconStore.getIcon(client), height));
                }
            }
        };
    }

    private static abstract class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int irow, int icol) {
            int size;
            try {
                size = (int)Math.ceil(this.getFont().getMaxCharBounds(((Graphics2D)table.getGraphics()).getFontRenderContext()).getHeight());
            }
            catch (NullPointerException e) {
                size = 16;
            }
            Component comp = super.getTableCellRendererComponent(table, value, isSel, hasFocus, irow, icol);
            if (comp instanceof JLabel) {
                this.configureLabel((JLabel)comp, value, size - 2);
            }
            return comp;
        }

        abstract void configureLabel(JLabel var1, Object var2, int var3);
    }

    private abstract class Column {
        final String name_;
        final Class clazz_;
        final TableColumn tcol_;

        Column(String name, Class clazz, TableColumn tcol) {
            this.name_ = name;
            this.clazz_ = clazz;
            this.tcol_ = tcol;
            this.tcol_.setHeaderValue(name);
        }

        abstract Object getValue(Transmission var1);
    }
}

