/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class ExitTest
extends BridgeTest {
    @Test
    public void exitTestFail() {
        try {
            this.ocsBridge.execute(new ExitControlCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void exitAndFaultTest() {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        this.ocsBridge.execute(new EnterControlCommand());
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new ExitControlCommand());
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        tl.printFinalStates("ExitTest.exitAndFaultTest()");
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.OFFLINE}));
        assert (tl.getFinalStates().hasState(new Enum[]{OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("ExitTest:exitAndFaultTest()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, SummaryStateEvent.SummaryState.OFFLINE, OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)states.size(), (long)4L);
        this.executor.printEventList("ExitTest:exitAndFaultTest()");
        Assert.assertEquals((long)1L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(ConfigurationsAvailableEvent.class));
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.FAULT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        Assert.assertEquals((Object)SummaryStateEvent.SummaryState.FAULT, (Object)states_fault.get(0));
        Assert.assertEquals((long)states_fault.size(), (long)1L);
    }
}

