/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class DiscardRowsTest {
    private OCSBridge ocsBridge;
    private final GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge((Camera)Camera.MAIN_CAMERA);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)new TestExecutor(this.ocsBridge));
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void failAlone() {
        try {
            this.ocsBridge.execute((CameraCommand)new DiscardRowsCommand(3));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void failAfterEnable() {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        this.enabler.goToEnable(this.ocsBridge);
        try {
            this.ocsBridge.execute((CameraCommand)new DiscardRowsCommand(10));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void discRowsInStartImageWindow() throws InterruptedException {
        int i;
        System.out.println("I am here please print me \n");
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        this.ocsBridge.execute(new StartImageCommand(true, "", "imageType: penguin007, groupId: mammal", "annotation", 10.0));
        TimeUnit.SECONDS.sleep(5L);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new DiscardRowsCommand(10));
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        System.out.println("************************");
        System.out.println("DiscardRowsTest:discRowsInStartImageWindow(): Final States");
        System.out.println(tl.getFinalStates());
        System.out.println("*********************");
        System.out.println("\n");
        System.out.flush();
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        System.out.println("************************");
        System.out.println("DiscardRowsTest:discRowsInStartImageWindow():States");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************");
        System.out.println("\n");
        System.out.flush();
        System.out.println("************************");
        System.out.println("DiscardRowsTest:discRowsInStartImageWindow(): List of Events");
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************");
        System.out.flush();
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
    }

    @Test
    public void discRowsOutOfStartImageWindow() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        this.ocsBridge.execute(new StartImageCommand(true, "", "imageType: penguin007, groupId: mammal", "annotation", 1.0));
        TimeUnit.SECONDS.sleep(4L);
        try {
            this.ocsBridge.execute((CameraCommand)new DiscardRowsCommand(10));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

