/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class ShutterMotionProfileSenderTest {
    @Test
    public void testProcessMotionDone() throws IOException, ClassNotFoundException {
        MotionDone md = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-64.ser");
        ImageName obsId = new ImageName("MC_C_20230603_000001");
        ShutterMotionProfileSender sender = new ShutterMotionProfileSender();
        sender.processMotionDone(obsId, md, true);
        JsonFile processMotionDone = sender.getJsonFile();
        System.out.println(processMotionDone);
        List<String> lines = Arrays.asList(processMotionDone.toString().split("\\R"));
        Assert.assertTrue((boolean)lines.contains("      \"sensorId\" : 1,"));
        Assert.assertTrue((boolean)lines.contains("      \"position\" : 680.9138194843619"));
    }

    @Test
    public void testHallSensorFit() throws IOException, ClassNotFoundException {
        MotionDone md = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-64.ser");
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter(md);
        ShutterMotionProfileFitResult fitResult = fitter.getHallSensorFit();
        System.out.println(fitResult);
        Assert.assertEquals((double)9.831407024365022E-4, (double)fitResult.getModelStartTime(), (double)1.0E-7);
        Assert.assertEquals((double)0.2239998491336072, (double)fitResult.getPivotPoint1(), (double)1.0E-7);
        Assert.assertEquals((double)0.6772445966113845, (double)fitResult.getPivotPoint2(), (double)1.0E-7);
        Assert.assertEquals((double)33158.7285424794, (double)fitResult.getJerk0(), (double)1.0E-7);
        Assert.assertEquals((double)-32904.31390308641, (double)fitResult.getJerk1(), (double)1.0E-7);
        Assert.assertEquals((double)34423.3897813156, (double)fitResult.getJerk2(), (double)1.0E-7);
    }

    @Test
    public void testMotorEncoderFit() throws IOException, ClassNotFoundException {
        MotionDone md = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-64.ser");
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter(md);
        ShutterMotionProfileFitResult fitResult = fitter.getMotorEncoderFit();
        System.out.println(fitResult);
        Assert.assertEquals((double)3.408344320041491E-4, (double)fitResult.getModelStartTime(), (double)1.0E-7);
        Assert.assertEquals((double)0.22469586105707987, (double)fitResult.getPivotPoint1(), (double)1.0E-7);
        Assert.assertEquals((double)0.6779401444921975, (double)fitResult.getPivotPoint2(), (double)1.0E-7);
        Assert.assertEquals((double)32970.21435092477, (double)fitResult.getJerk0(), (double)1.0E-7);
        Assert.assertEquals((double)-32818.68706894897, (double)fitResult.getJerk1(), (double)1.0E-7);
        Assert.assertEquals((double)34229.57086923853, (double)fitResult.getJerk2(), (double)1.0E-7);
    }
}

