/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.DataProviderInfoUtils;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericGenericConverterTest {
    private final Random r = new Random();

    @Test
    public void TelemetryConversionTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        for (Camera camera : Camera.values()) {
            for (XMLMaker2.SALType salType : XMLMaker2.SALType.values()) {
                MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)camera, (XMLMaker2.SALType)salType);
                GenericConverter converter = new GenericConverter(camera, salType);
                ArrayList<String> skippedData = new ArrayList<String>();
                for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : xmlMaker.getOrderedListOfDictionaryConfigurations()) {
                    HashMap<String, Map> dataMap = new HashMap<String, Map>();
                    HashMap<String, String> categoryVersionMap = new HashMap<String, String>();
                    HashMap<String, List> rejectedDataMap = new HashMap<String, List>();
                    String agentName = dictConfig.getAgentName();
                    if (agentName.equals("rebpower")) continue;
                    System.out.println("\n***** Agent: " + agentName + " (" + camera + ")");
                    converter.addSubsystem(agentName);
                    DataProviderDictionary dict = dictConfig.getDictionary();
                    for (DataProviderInfo dataProviderInfo : dict.getDataProviderInfos()) {
                        Map catDataMap;
                        if (!DataProviderInfoUtils.acceptDataType((DataProviderInfo)dataProviderInfo, (XMLMaker2.SALType)salType)) continue;
                        String category = DataProviderInfoUtils.getCategory((DataProviderInfo)dataProviderInfo);
                        if (!DataProviderInfoUtils.acceptData((DataProviderInfo)dataProviderInfo, (XMLMaker2.SALType)salType)) {
                            rejectedDataMap.computeIfAbsent(category, c -> new ArrayList()).add(dataProviderInfo.getFullPath());
                        }
                        if (!this.addRandomData(catDataMap = dataMap.computeIfAbsent(category, c -> new HashMap()), dataProviderInfo)) {
                            skippedData.add(dataProviderInfo.getFullPath());
                        }
                        categoryVersionMap.put(category, "1.0");
                    }
                    for (Map.Entry entry : dataMap.entrySet()) {
                        System.out.println("  Total number of generated data for category " + (String)entry.getKey() + ": " + ((Map)entry.getValue()).size());
                    }
                    ArrayList<CameraTelemetry> converted = new ArrayList<CameraTelemetry>();
                    if (salType == XMLMaker2.SALType.TELEMETRY) {
                        for (CameraTelemetry tel : converter.telemetryConverter(agentName, dataMap)) {
                            converted.add(tel);
                        }
                    } else {
                        for (CameraTelemetry tel : converter.settingsAppliedEventConverter(agentName, dataMap, categoryVersionMap)) {
                            converted.add(tel);
                        }
                    }
                    if (!skippedData.isEmpty()) {
                        Assert.assertTrue((String)("These paths were not generated: " + skippedData), (boolean)skippedData.isEmpty());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    Map salClassesMap = converter.getSALClassDescriptionMapForAgent(agentName);
                    HashMap<Class, SALClassDescription> classToSalClassDescriptionMap = new HashMap<Class, SALClassDescription>();
                    for (Map.Entry e : salClassesMap.entrySet()) {
                        SALClassDescription salClassDesc = (SALClassDescription)e.getValue();
                        Class clazz = salClassDesc.getSimpleSalClass();
                        if (clazz != null) {
                            classToSalClassDescriptionMap.put(clazz, salClassDesc);
                            continue;
                        }
                        String category = salClassDesc.getCategory();
                        int dataCount = 0;
                        for (Object salVar : salClassDesc.getVariables()) {
                            if (salVar instanceof SALClassDescription.SimpleSALVariable) {
                                Object path = ((SALClassDescription.SimpleSALVariable)salVar).getBusVariable().getPathAndNameOnBuses();
                                if (((String)path).startsWith("/")) {
                                    path = ((String)path).substring(1);
                                }
                                if (skippedData.contains(path)) continue;
                                Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                                ++dataCount;
                                continue;
                            }
                            if (!(salVar instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
                            for (SALClassDescription.BusVariable var : ((SALClassDescription.PatternMatchedSALVariable)salVar).getBusVariables()) {
                                String path = var.getPathAndNameOnBuses();
                                if (skippedData.contains(path)) continue;
                                Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                                ++dataCount;
                            }
                        }
                        if (stringBuilder.toString().isEmpty()) {
                            stringBuilder.append("  Missing SAL classes:\n");
                        }
                        stringBuilder.append("\t").append((String)e.getKey()).append(" with ").append(dataCount).append(" data\n");
                    }
                    Assert.assertTrue((String)stringBuilder.toString(), (boolean)stringBuilder.toString().isEmpty());
                    int removedData = 0;
                    int numberOfVars = 0;
                    for (Object e : converted) {
                        Object salVar;
                        Class<?> cls = e.getClass();
                        SALClassDescription salClassDesc = (SALClassDescription)classToSalClassDescriptionMap.get(cls);
                        HashMap<Method[], SALClassDescription.SALVariable> salVariablesMap = new HashMap<Method[], SALClassDescription.SALVariable>();
                        salVar = salClassDesc.getVariables().iterator();
                        while (salVar.hasNext()) {
                            SALClassDescription.SALVariable salVar2 = (SALClassDescription.SALVariable)salVar.next();
                            Method[] lowerCaseVarName = salVar2.getVariableName().toLowerCase();
                            salVariablesMap.put(lowerCaseVarName, salVar2);
                        }
                        String category = salClassDesc.getCategory();
                        StringBuilder unknownVariables = new StringBuilder();
                        for (Method m : cls.getMethods()) {
                            String methodName = m.getName();
                            boolean isValidMethod = false;
                            String variableName = null;
                            if (methodName.startsWith("get") && !methodName.equals("getClass")) {
                                variableName = methodName.substring(3);
                                isValidMethod = true;
                            } else if (methodName.startsWith("is") && m.getReturnType().isAssignableFrom(Boolean.TYPE)) {
                                variableName = methodName.substring(2);
                                isValidMethod = true;
                            }
                            if (!isValidMethod) continue;
                            ++numberOfVars;
                            if (variableName.equals("Version")) continue;
                            String lowerCaseVariableName = variableName.toLowerCase();
                            Object convertedData = m.invoke(e, new Object[0]);
                            SALClassDescription.SALVariable variable = (SALClassDescription.SALVariable)salVariablesMap.remove(lowerCaseVariableName);
                            if (convertedData.equals(Double.NaN)) {
                                System.out.println("NAN for " + variableName + " " + category + " " + variable);
                            }
                            if (variable != null) {
                                if (variable instanceof SALClassDescription.SimpleSALVariable) {
                                    String pathName = ((SALClassDescription.SimpleSALVariable)variable).getBusVariable().getPathAndNameOnBuses();
                                    if (skippedData.contains(pathName)) continue;
                                    ++removedData;
                                    Object randomData = ((Map)dataMap.get(category)).remove(pathName);
                                    Assert.assertNotNull((String)pathName, randomData);
                                    randomData = this.convertInputDataToString(randomData);
                                    if (randomData.getClass().isArray()) {
                                        int randomDataLength = Array.getLength(randomData);
                                        int convertedDataLength = Array.getLength(convertedData);
                                        Assert.assertEquals((long)randomDataLength, (long)convertedDataLength);
                                        for (int i = 0; i < randomDataLength; ++i) {
                                            Object randomDataElement = Array.get(randomData, i);
                                            Object convertedDataElement = Array.get(convertedData, i);
                                            Assert.assertEquals((String)("Comparing array element " + i + " for " + variable + " " + convertedDataElement + " " + randomDataElement), (Object)convertedDataElement, (Object)randomDataElement);
                                        }
                                        continue;
                                    }
                                    Assert.assertEquals((String)("Comparing data for " + variable + " " + convertedData + " " + randomData), (Object)convertedData, (Object)randomData);
                                    continue;
                                }
                                if (!(variable instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
                                int index = 0;
                                if (m.getReturnType().isArray()) {
                                    SALClassDescription.PatternMatchedSALVariable patternVar = (SALClassDescription.PatternMatchedSALVariable)variable;
                                    int size = patternVar.getLocationVariable().getAvailableLocationValues().size();
                                    Assert.assertEquals((String)("Array size comparison for " + ((SALClassDescription.PatternMatchedSALVariable)variable).getPatternName() + " " + size), (long)Array.getLength(convertedData), (long)size);
                                    for (SALClassDescription.BusVariable var : ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables()) {
                                        int varLocationIndex = patternVar.getLocationVariable().getAvailableLocationValues().indexOf(var.getLocationValue());
                                        Object convertedDataArrayElement = Array.get(convertedData, varLocationIndex);
                                        String pathName = var.getPathAndNameOnBuses();
                                        ++removedData;
                                        Object randomData = ((Map)dataMap.get(category)).remove(pathName);
                                        Assert.assertNotNull((String)("Not null: " + pathName + "[" + varLocationIndex + "] out of " + ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables().size()), randomData);
                                        Assert.assertEquals((String)("Comparing data element (" + varLocationIndex + ") for " + variableName), (Object)convertedDataArrayElement, randomData);
                                        ++index;
                                    }
                                    Assert.assertEquals((String)"Number of checked data", (long)index, (long)variable.getCount());
                                    continue;
                                }
                                if (m.getReturnType() == String.class) {
                                    ArrayList randomDataList = new ArrayList();
                                    for (SALClassDescription.BusVariable var : ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables()) {
                                        String pathName = var.getPathAndNameOnBuses();
                                        ++removedData;
                                        Object randomData = ((Map)dataMap.get(category)).remove(pathName);
                                        randomData = this.convertInputDataToString(randomData);
                                        randomDataList.add(randomData);
                                        Assert.assertNotNull((String)("Not null: " + pathName + "[" + index + "] out of " + ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables().size()), randomData);
                                        ++index;
                                    }
                                    Object convertedRandomData = this.convertInputDataToString(randomDataList.toArray());
                                    Assert.assertEquals((String)("Comparing converted data for " + variableName), (Object)convertedData, (Object)convertedRandomData);
                                    Assert.assertEquals((String)"Number of checked data", (long)index, (long)variable.getCount());
                                    continue;
                                }
                                throw new RuntimeException("Problem with category " + category + ": variable " + variable);
                            }
                            unknownVariables.append("\t").append(variableName).append("\n");
                        }
                        StringBuilder notConvertedVAriablesSb = new StringBuilder();
                        if (!salVariablesMap.isEmpty()) {
                            for (SALClassDescription.SALVariable leftoverVar : salVariablesMap.values()) {
                                if (leftoverVar instanceof SALClassDescription.LocationVariable) continue;
                                if (leftoverVar instanceof SALClassDescription.SimpleSALVariable) {
                                    String path = ((SALClassDescription.SimpleSALVariable)leftoverVar).getBusVariable().getPathAndNameOnBuses();
                                    Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                                } else if (leftoverVar instanceof SALClassDescription.PatternMatchedSALVariable) {
                                    for (SALClassDescription.BusVariable var : ((SALClassDescription.PatternMatchedSALVariable)leftoverVar).getBusVariables()) {
                                        String path = var.getPathAndNameOnBuses();
                                        if (skippedData.contains(path)) continue;
                                        Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                                    }
                                }
                                notConvertedVAriablesSb.append("\t").append(leftoverVar.getVariableName()).append(" data size: ").append(leftoverVar.getCount()).append(" ").append(leftoverVar.getType()).append("\n");
                            }
                        }
                        if (!agentName.equals("utiltrunk")) {
                            Assert.assertTrue((String)(cls.getName() + "\n" + notConvertedVAriablesSb.toString()), (boolean)salVariablesMap.isEmpty());
                        }
                        Assert.assertTrue((String)(cls.getName() + "\nClass fields no longer in the dictionary: \n" + unknownVariables.toString()), (boolean)unknownVariables.toString().isEmpty());
                    }
                    for (Map.Entry entry : dataMap.entrySet()) {
                        String cat = (String)entry.getKey();
                        Map data = (Map)entry.getValue();
                        Iterator iter = data.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry2 = iter.next();
                            iter.remove();
                            Assert.assertTrue((boolean)((List)rejectedDataMap.get(cat)).remove(entry2.getKey()));
                        }
                    }
                    for (Map.Entry entry : dataMap.entrySet()) {
                        Assert.assertTrue((String)((String)entry.getKey() + " " + ((Map)entry.getValue()).toString()), (boolean)((Map)entry.getValue()).isEmpty());
                        if (rejectedDataMap.get(entry.getKey()) == null) continue;
                        Assert.assertTrue((String)((String)entry.getKey() + " rejected data " + rejectedDataMap.get(entry.getKey())), (boolean)((List)rejectedDataMap.get(entry.getKey())).isEmpty());
                    }
                    System.out.println("  Data generation and conversion OK\n");
                }
            }
        }
    }

    private boolean addRandomData(Map<String, Object> dataMap, DataProviderInfo dataInfo) {
        String type = dataInfo.getAttributeValue(DataProviderInfo.Attribute.TYPE);
        String path = dataInfo.getFullPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String length = dataInfo.getAttributeValue(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH);
        if (type == null) {
            throw new RuntimeException("Type is not defined for " + path);
        }
        return this.generateForType(dataMap, path, type, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateForType(Map<String, Object> dataMap, String path, String type, String length) {
        switch (type) {
            case "double": 
            case "java.lang.Double": {
                dataMap.put(path, this.r.nextDouble());
                return true;
            }
            case "float": 
            case "java.lang.Float": {
                dataMap.put(path, Float.valueOf(this.r.nextFloat()));
                return true;
            }
            case "long": 
            case "java.lang.Long": {
                dataMap.put(path, this.r.nextLong());
                return true;
            }
            case "int": 
            case "java.lang.Integer": {
                dataMap.put(path, this.r.nextInt());
                return true;
            }
            case "short": 
            case "java.lang.Short": {
                dataMap.put(path, (short)this.r.nextInt(10));
                return true;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                dataMap.put(path, this.r.nextInt(10) > 5);
                return true;
            }
            case "java.lang.String": {
                dataMap.put(path, String.valueOf(this.r.nextDouble()));
                return true;
            }
            default: {
                boolean convertToArray = false;
                boolean convertToList = false;
                boolean convertToMap = false;
                boolean isGeneric = false;
                if (type.contains("<")) {
                    isGeneric = true;
                }
                if (isGeneric) {
                    try {
                        Class<?> structureClass = Class.forName(type.substring(0, type.indexOf("<")));
                        if (List.class.isAssignableFrom(structureClass)) {
                            Class<?> dataClass = Class.forName(type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")));
                            type = dataClass.getCanonicalName();
                            convertToList = true;
                        }
                        if (!Map.class.isAssignableFrom(structureClass)) throw new RuntimeException("What should we do with " + structureClass);
                        convertToMap = true;
                        type = "java.lang.String";
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Something went wrong converting type " + type);
                    }
                } else if (type.endsWith("[]")) {
                    convertToArray = true;
                    type = type.replace("[]", "");
                }
                if (convertToArray || convertToList || convertToMap) {
                    if (length == null) {
                        throw new RuntimeException("Don't know how to deal with arrays for path " + path);
                    }
                    int size = 1;
                    try {
                        size = Integer.parseInt(length);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Problems converting size \"" + length + "\" for " + path);
                    }
                    if (size < 0) {
                        size = 1;
                    }
                    HashMap<String, Object> res = new HashMap<String, Object>();
                    for (int i = 0; i < size; ++i) {
                        this.generateForType(res, path + i, type, "");
                    }
                    try {
                        if (convertToArray) {
                            Object array = this.createArrayFor(type, size);
                            int index = 0;
                            for (Object obj : res.values()) {
                                Array.set(array, index, obj);
                                ++index;
                            }
                            dataMap.put(path, array);
                            return true;
                        } else if (convertToList) {
                            ArrayList result = new ArrayList();
                            for (Object obj : res.values()) {
                                result.add(obj);
                            }
                            dataMap.put(path, result);
                            return true;
                        } else {
                            if (!convertToMap) throw new RuntimeException("We should not get here");
                            dataMap.put(path, res);
                        }
                        return true;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                boolean treatAsString = false;
                try {
                    Class<?> c = Class.forName(type);
                    if (c.isEnum()) {
                        ?[] values = c.getEnumConstants();
                        int index = this.r.nextInt(values.length);
                        String s = values[index].toString();
                        dataMap.put(path, s);
                        return true;
                    }
                    treatAsString = true;
                }
                catch (ClassNotFoundException ex) {
                    treatAsString = true;
                }
                if (!treatAsString) throw new RuntimeException("How did we get here???");
                type = "java.lang.String";
                this.generateForType(dataMap, path, type, "");
                return true;
            }
        }
    }

    private Object createArrayFor(String type, int size) throws ClassNotFoundException {
        switch (type) {
            case "double": 
            case "java.lang.Double": {
                return new double[size];
            }
            case "float": 
            case "java.lang.Float": {
                return new float[size];
            }
            case "long": 
            case "java.lang.Long": {
                return new long[size];
            }
            case "int": 
            case "java.lang.Integer": {
                return new int[size];
            }
            case "short": 
            case "java.lang.Short": {
                return new short[size];
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return new boolean[size];
            }
        }
        return Array.newInstance(Class.forName(type), size);
    }

    private Object convertInputDataToString(Object randomData) {
        if (randomData.getClass().isArray() && !randomData.getClass().getComponentType().isPrimitive()) {
            Object randomDataConversion = "";
            int length = Array.getLength(randomData);
            for (int i = 0; i < length; ++i) {
                randomDataConversion = (String)randomDataConversion + Array.get(randomData, i);
                if (i >= length - 1) continue;
                randomDataConversion = (String)randomDataConversion + ":";
            }
            return randomDataConversion;
        }
        if (List.class.isAssignableFrom(randomData.getClass())) {
            Object randomDataConversion = "";
            List randomDataList = (List)randomData;
            for (Object o : randomDataList) {
                randomDataConversion = (String)randomDataConversion + o;
                randomDataConversion = (String)randomDataConversion + ", ";
            }
            if (((String)randomDataConversion).endsWith(", ")) {
                randomDataConversion = ((String)randomDataConversion).substring(0, ((String)randomDataConversion).length() - 2);
            }
            return "[" + (String)randomDataConversion + "]";
        }
        if (Map.class.isAssignableFrom(randomData.getClass())) {
            return randomData.toString();
        }
        return randomData;
    }
}

