/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;

public class DelimitedStringSplitJoinTest {
    private static final String TEST_STRING_1 = "::OBJECT:2020-06-16T18\\:43\\:55.039:OBJ\\\\ECT";
    private static final String[] TEST_ARRAY_1 = new String[]{"", "", "OBJECT", "2020-06-16T18:43:55.039", "OBJ\\ECT"};

    @Test
    public void testSplitJoin() {
        String input = TEST_STRING_1;
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        Object[] result = dsa.split((CharSequence)input);
        Assert.assertArrayEquals((Object[])TEST_ARRAY_1, (Object[])result);
        String output = dsa.join((CharSequence[])result);
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void testSplitJoinIterable() {
        String input = TEST_STRING_1;
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        Object[] result = dsa.split((CharSequence)input);
        Assert.assertArrayEquals((Object[])TEST_ARRAY_1, (Object[])result);
        String output = dsa.join(Arrays.asList(result));
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void testEmpty() {
        String input = "";
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        String[] result = dsa.split((CharSequence)input);
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void testNotQuiteEmpty() {
        String input = "a";
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        String[] result = dsa.split((CharSequence)input);
        Assert.assertEquals((long)1L, (long)result.length);
    }

    @Test
    public void testJoining() {
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        String[] toJoin = TEST_ARRAY_1;
        String result = (String)Arrays.stream(toJoin).collect(dsa.joining());
        Assert.assertEquals((Object)TEST_STRING_1, (Object)result);
    }

    @Test
    public void testJoiningEmpty() {
        DelimitedStringSplitJoin dsa = new DelimitedStringSplitJoin();
        String[] toJoin = new String[]{};
        String result = (String)Arrays.stream(toJoin).collect(dsa.joining());
        Assert.assertEquals((Object)"", (Object)result);
    }
}

