/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class EnableTest {
    private OCSBridge ocsBridge;
    private final GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge((Camera)Camera.MAIN_CAMERA);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)new TestExecutor(this.ocsBridge));
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void enableTestFailure() {
        try {
            this.ocsBridge.execute(new EnableCommand());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void enableAndFaultTest() {
        int i;
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.enabler.goToEnable(this.ocsBridge);
        Assert.assertEquals((long)11L, (long)tl.getCalls());
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaultTest(): Final States");
        System.out.println(tl.getFinalStates());
        System.out.println("*********************");
        System.out.println("\n");
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.ENABLED}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaultTest():States");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************");
        System.out.println("\n");
        Assert.assertEquals((long)states.size(), (long)11L);
        assert (fsh.containsInOrder(new Enum[]{OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE, SummaryStateEvent.SummaryState.STANDBY, CCSCommandStateEvent.CCSCommandState.IDLE, SummaryStateEvent.SummaryState.DISABLED, SummaryStateEvent.SummaryState.ENABLED}));
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY}));
        assert (fsh.containsInOrder(new Enum[]{OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE, CCSCommandStateEvent.CCSCommandState.BUSY, SummaryStateEvent.SummaryState.STANDBY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, SummaryStateEvent.SummaryState.DISABLED, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, SummaryStateEvent.SummaryState.ENABLED, CCSCommandStateEvent.CCSCommandState.IDLE}));
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaulttest(): List of Events");
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************");
        System.out.println("\n");
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.FAULT}));
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        Assert.assertEquals((Object)SummaryStateEvent.SummaryState.FAULT, (Object)states_fault.get(0));
        Assert.assertEquals((long)states_fault.size(), (long)1L);
    }
}

