/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.MinioException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;

public class S3FileUploaderAndDeleter {
    private final String lfaId;
    private final String lfaSecret;
    private final String lfaBucket;
    private final String lfaEndpoint;
    private final String cscName;

    public S3FileUploaderAndDeleter(OCSBridgeConfig config) {
        this(BootstrapResourceUtils.getBootstrapProperties((String)config.getLfaCredentialsFile()), config.getDevice().getCscName());
    }

    public S3FileUploaderAndDeleter(Properties lfaProperties, String cscName) {
        this.cscName = cscName;
        this.lfaId = lfaProperties.getProperty("lfa.id", "");
        this.lfaSecret = lfaProperties.getProperty("lfa.secret", "");
        this.lfaBucket = lfaProperties.getProperty("lfa.bucket", "");
        String endPoint = lfaProperties.getProperty("lfa.endpoint", "");
        if (this.lfaId.isEmpty() || this.lfaSecret.isEmpty() || this.lfaBucket.isEmpty() || endPoint.isEmpty()) {
            throw new IllegalArgumentException("The following quantities must be specified for the LFA credentials: id, secret, bucket, endpoint.");
        }
        this.lfaEndpoint = endPoint.endsWith("/") ? endPoint : endPoint + "/";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String writeToS3(AdditionalFile additionalFile) throws IOException {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.lfaEndpoint).credentials(this.lfaId, this.lfaSecret).build();
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.lfaBucket)).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.lfaBucket)).build());
            }
            try (ByteArrayOutputStream boutstream = new ByteArrayOutputStream();){
                String string;
                additionalFile.writeFile((OutputStream)boutstream);
                try (ByteArrayInputStream binstream = new ByteArrayInputStream(boutstream.toByteArray());){
                    String myFileNameAndPath = this.computePathForFile(additionalFile);
                    minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.lfaBucket)).object(myFileNameAndPath)).stream((InputStream)binstream, (long)binstream.available(), -1L).build());
                    string = this.lfaEndpoint + this.lfaBucket + "/" + myFileNameAndPath;
                }
                return string;
            }
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException("Unable to write s3 file", ex);
        }
    }

    private String computePathForFile(AdditionalFile additionalFile) {
        return this.cscName + "/" + additionalFile.getFileType() + "/" + additionalFile.getObsId().getDateString() + "/" + additionalFile.getFileName();
    }

    public void deleteFromS3(AdditionalFile additionalFile) throws IOException {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.lfaEndpoint).credentials(this.lfaId, this.lfaSecret).build();
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.lfaBucket)).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.lfaBucket)).build());
            }
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.lfaBucket)).object(this.computePathForFile(additionalFile))).build());
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException("Unable to delete s3 file", ex);
        }
    }
}

