/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.auxelex.HeaterConv;
import org.lsst.ccs.drivers.auxelex.LTC2945;
import org.lsst.ccs.drivers.auxelex.LambdaPS;
import org.lsst.ccs.drivers.auxelex.SA56004;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class HeaterPS
extends Srp {
    public static final int NUM_HEATERS = 12;
    public static final int NUM_SECT_HEATERS = 6;
    public static final int CHAN_CRYO_FIRST = 0;
    public static final int CHAN_COLD_FIRST = 6;
    public static final int MIN_SWITCH_PERIOD = 100;
    public static final int MAX_SWITCH_PERIOD = 500;
    private static final int REG_CONTROL_BASE = 0;
    private static final int CONTROL_INCREMENT = 2;
    private static final int REG_MONITOR_BASE = 65536;
    private static final int REG_INTERLOCKS = 196608;
    private static final int CRYO_ENABLED = 1;
    private static final int COLD_ENABLED = 2;
    private static final int BULK_CHAN = 0;
    private static final int REG_LAMBDA_BASE = 131072;
    private static final int REG_LAMBDA_IO = 137216;
    private static final double SHUNT_020 = 0.02;
    private static final double MIN_SOURCE_VOLTS = 1.0;
    private static final List<Srp.BoardType> validTypes = new ArrayList<Srp.BoardType>();
    private static final Logger LOG;
    private final LTC2945 adc;
    private final LambdaPS bulk;
    private final SA56004 temp;
    private final HeaterConv conv = new HeaterConv();
    private int switchPeriod = 500;
    private RandomAccessFile simRegFile;

    public HeaterPS() {
        this.setValidBoardTypes(validTypes);
        this.adc = new LTC2945(this, 65536);
        this.bulk = new LambdaPS(this, 131072, 1);
        this.temp = new SA56004(this);
    }

    @Override
    public void open(int node) throws DriverException {
        this.conv.setNode(node);
        super.open(node);
    }

    @Override
    public void open(String host) throws DriverException {
        this.conv.setNode(this.getIpAddress()[3]);
        super.open(host);
    }

    public void setSwitchPeriod(int period) throws DriverException {
        if (period < 100 || period > 500) {
            throw new DriverException("Switch period must be between 100 and 500");
        }
        this.switchPeriod = period;
    }

    public int getSwitchPeriod() {
        return this.switchPeriod;
    }

    public void setDutyCycle(int chan, double duty) throws DriverException {
        int high = Math.max(2, Math.min(this.switchPeriod - 2, (int)(duty * (double)this.switchPeriod)));
        int low = this.switchPeriod - high;
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        this.writeReg(regNum, this.readReg(regNum) & 0xFFFC0000 | low - 1 << 9 | high - 1);
    }

    public double getDutyCycle(int chan) throws DriverException {
        return this.calcDutyCycle(this.readReg(0 + 2 * this.checkChannelNumber(chan)));
    }

    private double calcDutyCycle(int regVal) {
        double high = (regVal & 0x1FF) + 1;
        double low = (regVal >> 9 & 0x1FF) + 1;
        return high / (high + low);
    }

    public void setVoltage(int chan, double volts) throws DriverException {
        this.checkChannelNumber(chan);
        double source = this.readMainVoltage();
        if (source < 1.0) {
            throw new DriverException("Board is not powered");
        }
        this.setDutyCycle(chan, this.conv.convVoltsAndDuty(true, chan, volts / source));
    }

    public double getVoltage(int chan) throws DriverException {
        this.checkChannelNumber(chan);
        return this.readMainVoltage() * this.conv.convVoltsAndDuty(false, chan, this.getDutyCycle(chan));
    }

    public void setOutput(int chan, boolean on) throws DriverException {
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        this.writeReg(regNum, this.readReg(regNum) & 0xF7FFFFFF | (on ? 1 : 0) << 27);
    }

    public boolean getOutput(int chan) throws DriverException {
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        return (this.readReg(regNum) & 0x8000000) != 0;
    }

    public double readVoltage(int chan) throws DriverException {
        return this.adc.readVoltage(this.checkChannelNumber(chan));
    }

    public double readCurrent(int chan) throws DriverException {
        return this.adc.readCurrent(this.checkChannelNumber(chan)) / 0.02;
    }

    public double readBoardTemperature() throws DriverException {
        return this.temp.readTemperature();
    }

    public boolean isCryoEnabled() throws DriverException {
        return (this.readReg(196608) & 1) != 0;
    }

    public boolean isColdEnabled() throws DriverException {
        return (this.readReg(196608) & 2) != 0;
    }

    public int getMainModel() throws DriverException {
        return this.bulk.getModel();
    }

    public String getMainSerialNo() throws DriverException {
        return this.bulk.getSerialNo();
    }

    public String getMainFwVersion() throws DriverException {
        return this.bulk.getFwVersion();
    }

    public String getMainPrVersion() throws DriverException {
        return this.bulk.getPrVersion();
    }

    public String getMainPartNo() throws DriverException {
        return this.bulk.getPartNo();
    }

    public String getMainManuDate() throws DriverException {
        return this.bulk.getManuDate();
    }

    public String getMainManuLocn() throws DriverException {
        return this.bulk.getManuLocn();
    }

    public int readMainStatus() throws DriverException {
        return this.bulk.readStatus();
    }

    public double readMainVoltage() throws DriverException {
        return this.bulk.readVoltage();
    }

    public double readMainCurrent() throws DriverException {
        return this.bulk.readCurrent();
    }

    public double readMainTemperature() throws DriverException {
        return this.bulk.readTemperature();
    }

    public void setMainPowerOn(boolean on) throws DriverException {
        this.writeReg(137216, on ? 1 : 0);
    }

    public int getMainIoStatus() throws DriverException {
        return this.readReg(137216);
    }

    private int checkChannelNumber(int chan) throws DriverException {
        if (chan < 0 || chan >= 12) {
            throw new DriverException("Invalid heater channel number: " + chan);
        }
        return chan;
    }

    @Override
    protected void simInitialize() {
        super.simInitialize();
        this.putSimRegMap(196608, 3);
        this.bulk.simInitialize();
        this.temp.simInitialize();
        this.simLoadRegisters();
    }

    @Override
    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            this.putSimRegMap(addr, value[j]);
            if (addr < 65536) {
                int chan = (addr - 0) / 2;
                if (chan < 12) {
                    if ((value[j] & 0x8000000) != 0) {
                        this.adc.simSetVoltage(chan, this.bulk.simGetVoltage());
                        double volts = this.bulk.simGetVoltage() * this.conv.convVoltsAndDuty(false, chan, this.calcDutyCycle(value[j]));
                        this.adc.simSetCurrent(chan, volts * 0.02 / 12.5);
                    } else {
                        this.adc.simSetVoltage(chan, 0.0);
                        this.adc.simSetCurrent(chan, 0.0);
                    }
                    this.simSaveRegister(chan, value[j]);
                }
            } else if (addr == 137216) {
                this.bulk.simSetOutput(value[j] != 0);
            }
            ++j;
            ++addr;
        }
    }

    private void simLoadRegisters() {
        File file = new File("/tmp/simHeaterPSRegs");
        try {
            if (!file.exists()) {
                file.createNewFile();
                this.simRegFile = new RandomAccessFile(file, "rwd");
                for (int chan = 0; chan < 12; ++chan) {
                    this.simRegFile.writeInt(0);
                }
            } else {
                this.simRegFile = new RandomAccessFile(file, "rwd");
                for (int chan = 0; chan < 12; ++chan) {
                    this.simRegFile.seek(4 * chan);
                    this.simWriteRegs(0 + 2 * chan, new int[]{this.simRegFile.readInt()}, 1);
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error accessing simulated registers file", e);
        }
    }

    private void simSaveRegister(int chan, int value) {
        try {
            this.simRegFile.seek(4 * chan);
            this.simRegFile.writeInt(value);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error writing simulated registers file", e);
        }
    }

    static {
        validTypes.add(Srp.BoardType.HEATER);
        validTypes.add(Srp.BoardType.SIMULATED);
        LOG = Logger.getLogger(HeaterPS.class.getName());
    }
}

