/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;

public class UnitConverter {
    private final Properties unitsMap;

    UnitConverter() {
        try (InputStream in = UnitConverter.class.getResourceAsStream("units.map");
             InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));){
            this.unitsMap = new Properties();
            this.unitsMap.load(reader);
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading units.map");
        }
    }

    public String convertCCSUnitToSALUnit(String ccs) {
        if (ccs == null || ccs.isEmpty()) {
            return "unitless";
        }
        String sal = this.unitsMap.getProperty(ccs.toLowerCase());
        return sal == null ? ccs : sal;
    }
}

