/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.AdditionalFileToLFAEvent;
import org.lsst.ccs.subsystem.ocsbridge.S3FileUploaderAndDeleter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class LFAAndJsonCheckAndS3WriteTest {
    @Test
    public void LFAObjectAndS3WriteTest() throws IOException, ClassNotFoundException {
        MotionDone md = ShutterSimulation.readMotionDone((String)"maincamera/cam-shutter-MotionDone-274.ser");
        ImageName obsId = new ImageName("MC_C_20230603_000001");
        ShutterMotionProfileSender sender = new ShutterMotionProfileSender();
        sender.processMotionDone(obsId, md, true);
        JsonFile adFile = sender.getJsonFile();
        System.out.println(" ADDFILE " + adFile.getFileName());
        System.out.println(" ADDFILE " + adFile.getObsId().getDateString());
        System.out.println(" ADDFILE " + adFile.getFileType());
        Properties lfaProperties = BootstrapResourceUtils.getBootstrapProperties((String)"lfa-test.properties");
        S3FileUploaderAndDeleter s3Uploader = new S3FileUploaderAndDeleter(lfaProperties, "MTCamera");
        s3Uploader.deleteFromS3((AdditionalFile)adFile);
        String writtenURL = s3Uploader.writeToS3((AdditionalFile)adFile);
        Assert.assertEquals((Object)"https://play.min.io/jsonwritetest/MTCamera/shutterMotionProfile/20230603/MC_C_20230603_000001_shutterMotionProfileOpen.json", (Object)writtenURL);
        AdditionalFileToLFAEvent lfa = new AdditionalFileToLFAEvent((AdditionalFile)adFile, writtenURL);
        System.out.println(lfa.getlfaEvent().toString());
        Assert.assertEquals((Object)"1180443377", (Object)lfa.getlfaEvent().getCheckSum());
    }
}

