/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class ShutterMotionProfileSenderTest {
    @Test
    public void testProcessMotionDone() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ImageName obsId = new ImageName("MC_C_20230603_000001");
        ShutterMotionProfileSender sender = new ShutterMotionProfileSender();
        sender.processMotionDone(obsId, md, true);
        JsonFile processMotionDone = sender.getJsonFile();
        System.out.println(processMotionDone);
        List<String> lines = Arrays.asList(processMotionDone.toString().split("\\R"));
        Assert.assertTrue((boolean)lines.contains("      \"sensorId\" : 1,"));
        Assert.assertTrue((boolean)lines.contains("      \"position\" : 32.2411264996,"));
    }

    @Test
    public void testHallSensorFit() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter(md);
        ShutterMotionProfileFitResult fitResult = fitter.getHallSensorFit();
        System.out.println(fitResult);
        Assert.assertEquals((double)3.1517040414607303E-4, (double)fitResult.getModelStartTime(), (double)1.0E-7);
        Assert.assertEquals((double)0.22440603364449146, (double)fitResult.getPivotPoint1(), (double)1.0E-7);
        Assert.assertEquals((double)0.6764735603322182, (double)fitResult.getPivotPoint2(), (double)1.0E-7);
        Assert.assertEquals((double)33084.938542418866, (double)fitResult.getJerk0(), (double)1.0E-7);
        Assert.assertEquals((double)-32922.74736320363, (double)fitResult.getJerk1(), (double)1.0E-7);
        Assert.assertEquals((double)33699.01584291877, (double)fitResult.getJerk2(), (double)1.0E-7);
    }

    @Test
    public void testMotorEncoderFit() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter(md);
        ShutterMotionProfileFitResult fitResult = fitter.getMotorEncoderFit();
        System.out.println(fitResult);
        Assert.assertEquals((double)2.876504287742699E-4, (double)fitResult.getModelStartTime(), (double)1.0E-7);
        Assert.assertEquals((double)0.2249064191219523, (double)fitResult.getPivotPoint1(), (double)1.0E-7);
        Assert.assertEquals((double)0.6765971136955028, (double)fitResult.getPivotPoint2(), (double)1.0E-7);
        Assert.assertEquals((double)32950.83746944349, (double)fitResult.getJerk0(), (double)1.0E-7);
        Assert.assertEquals((double)-32870.04398953447, (double)fitResult.getJerk1(), (double)1.0E-7);
        Assert.assertEquals((double)33418.0239489634, (double)fitResult.getJerk2(), (double)1.0E-7);
    }

    private MotionDone readMotionDone() throws IOException, ClassNotFoundException {
        return ShutterMotionProfileSenderTest.readMotionDone("maincamera/cam-shutter-MotionDone-274.ser");
    }

    static MotionDone readMotionDone(String path) throws IOException, ClassNotFoundException {
        try (InputStream in = ShutterMotionProfileSender.class.getResourceAsStream(path);){
            MotionDone motionDone;
            Assert.assertNotNull((Object)in);
            try (ObjectInputStream ois = new ObjectInputStream(in);){
                StatusSubsystemData ssd = (StatusSubsystemData)ois.readObject();
                KeyValueData subsystemData = ssd.getSubsystemData();
                motionDone = (MotionDone)subsystemData.getValue();
            }
            return motionDone;
        }
    }
}

