/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSenderTest;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class MeasuredShutterOpenTimeTest {
    @Test
    public void computeMeasuredShutterOpenTimeTest() throws IOException, ClassNotFoundException {
        ImageName imageName = new ImageName("MC_C_20240726_000001");
        MotionDone openMotionDone = ShutterMotionProfileSenderTest.readMotionDone("maincamera/cam-shutter-MotionDone-274.ser");
        ShutterMotionProfileSender openSender = new ShutterMotionProfileSender();
        openSender.processMotionDone(imageName, openMotionDone, true);
        ShutterMotionProfileFitResult openHallSensorFitResult = openSender.getHallSensorFitResult();
        double midPointTimeAtOpen = openSender.getStartTime().getTAIDouble() + openSender.getMidPointTimeFromHallSensor() + openHallSensorFitResult.getModelStartTime();
        MotionDone closeMotionDone = ShutterMotionProfileSenderTest.readMotionDone("maincamera/cam-shutter-MotionDone-287.ser");
        ShutterMotionProfileSender closeSender = new ShutterMotionProfileSender();
        closeSender.processMotionDone(imageName, closeMotionDone, false);
        ShutterMotionProfileFitResult closeHallSensorFitResult = closeSender.getHallSensorFitResult();
        double midPointTimeAtClose = closeSender.getStartTime().getTAIDouble() + closeSender.getMidPointTimeFromHallSensor() + closeHallSensorFitResult.getModelStartTime();
        double measuredShutterOpenTime = midPointTimeAtClose - midPointTimeAtOpen;
        Assert.assertEquals((double)2.0, (double)measuredShutterOpenTime, (double)0.001);
    }
}

