/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atheader.SALMain;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.cccamera.CCCamera;

public class OCSBridgeConfig {
    @ConfigurationParameter
    private volatile Camera device = Camera.MAIN_CAMERA;
    @ConfigurationParameter
    private final boolean hasFilterChanger = true;
    @ConfigurationParameter
    private volatile String mcmName = "mcm";
    @ConfigurationParameter(description="Userid to be used to MCM subsystem", isFinal=true)
    private volatile String userId = "ocs";
    @ConfigurationParameter(description="Properties file with lfa credentials", isFinal=true)
    private volatile String lfaCredentialsFile = "lfa-test.properties";
    @ConfigurationParameter(maxLength=50)
    private volatile String[] listenSubsystems = new String[0];

    public boolean hasFilterChanger() {
        return true;
    }

    public String getMCMName() {
        return this.mcmName;
    }

    public Camera getDevice() {
        return this.device;
    }

    public String getLfaCredentialsFile() {
        return this.lfaCredentialsFile;
    }

    public String[] getListenSubsystems() {
        return this.listenSubsystems;
    }

    String getUserID() {
        return this.userId;
    }

    SAL<CameraCommand, CameraEvent, CameraTelemetry> getSALManager() {
        return OCSBridgeConfig.createSALManager(this.device);
    }

    static SAL<CameraCommand, CameraEvent, CameraTelemetry> createSALManager(Camera device) {
        switch (device) {
            case MAIN_CAMERA: {
                return SALCamera.create();
            }
            case AUXTEL: {
                return ATCamera.create();
            }
            case COMCAM: {
                return CCCamera.create();
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + device);
    }

    String getCSCRoot() {
        switch (this.device) {
            case MAIN_CAMERA: {
                return "MTCamera";
            }
            case AUXTEL: {
                return "ATCamera";
            }
            case COMCAM: {
                return "CCCamera";
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + this.device);
    }

    SAL<SALCommand, SALEvent, SALTelemetry> getHeaderServiceManager() {
        switch (this.device) {
            case MAIN_CAMERA: {
                return null;
            }
            case AUXTEL: {
                return SALMain.create();
            }
            case COMCAM: {
                return org.lsst.sal.ccheader.SALMain.create();
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + this.device);
    }

    static OCSBridgeConfig createDefaultConfig(Camera camera) {
        OCSBridgeConfig config = new OCSBridgeConfig();
        config.device = camera;
        return config;
    }

    @ConfigurationParameterChanger(propertyName="listenSubsystems")
    public void setListenSubsystems(String[] listenSubsystems) {
        for (String sub : listenSubsystems) {
            if (sub == null) {
                throw new RuntimeException("Illegal value for listened subsystem. It cannot be null.");
            }
            if (sub.isEmpty()) {
                throw new RuntimeException("Illegal value for listened subsystem. It cannot be empty.");
            }
            if (!sub.contains(" ")) continue;
            throw new RuntimeException("Illegal value for listened subsystem. It cannot contain blanks: *" + sub + "*");
        }
        this.listenSubsystems = listenSubsystems;
    }
}

