/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAdditionalFileEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSMeasuredShutterTime;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ShutterSimulation
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(ShutterSimulation.class.getName());
    private final CCS ccs;
    private final State shutterState;
    private final MCMConfig config;
    private ScheduledFuture<?> notReadyFuture;
    private boolean imageSequence = false;
    private final ShutterMotionProfileSender motionProfileSender = new ShutterMotionProfileSender();
    static final Duration READY_TIME = Duration.ofMillis(4000L);
    static final Duration READY_TIME_FOR_SEVERAL_IMAGES = Duration.ofMillis(10000L);
    private ImageName currentImageName;
    private long currentOpenTime;

    ShutterSimulation(CCS ccs, State shutterState, MCMConfig config) {
        this.ccs = ccs;
        this.shutterState = shutterState;
        this.config = config;
        if (config.getShutterPrepTime() > 0.0) {
            shutterState.addStateChangeListener((when, state, oldState, cause) -> {
                if (state == ShutterState.CLOSED) {
                    this.scheduleNotReady();
                } else {
                    this.cancelNotReady();
                }
            });
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void expose(ImageName imageName, Duration exposureTime) throws ExecutionException {
        this.shutterState.checkState(new Enum[]{ShutterState.CLOSED});
        this.shutterState.setState(ShutterState.OPENING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.OPEN));
        if (this.config.getCameraType() == Camera.MAIN_CAMERA && imageName != null) {
            try {
                MotionDone motionDoneOpen = ShutterSimulation.readMotionDone("maincamera/cam-shutter-MotionDone-274.ser");
                this.motionProfileSender.processMotionDone(imageName, motionDoneOpen, true);
                JsonFile jsonProfileOpen = this.motionProfileSender.getJsonFile();
                LOG.log(Level.INFO, "Sending open {0}", jsonProfileOpen);
                this.ccs.fireEvent((CCSEvent)new CCSAdditionalFileEvent((AdditionalFile)jsonProfileOpen));
            }
            catch (IOException | ClassNotFoundException io) {
                LOG.log(Level.SEVERE, "Could not send json file open event");
            }
        }
        this.ccs.schedule(exposureTime, () -> this.shutterState.setState(ShutterState.CLOSING));
        this.ccs.schedule(exposureTime.plus(Shutter.MOVE_TIME), () -> this.shutterState.setState(ShutterState.CLOSED));
        Camera camera = this.config.getCameraType();
        this.config.getCameraType();
        if (camera == Camera.MAIN_CAMERA && imageName != null) {
            double measuredShutterOpenTime = exposureTime.getSeconds();
            this.ccs.schedule(exposureTime.plus(Shutter.MOVE_TIME).plus(Duration.ofMillis(300L)), () -> {
                CCSMeasuredShutterTime cst = new CCSMeasuredShutterTime(imageName, measuredShutterOpenTime + 0.1);
                this.ccs.fireEvent((CCSEvent)cst);
                try {
                    MotionDone motionDoneClose = ShutterSimulation.readMotionDone("maincamera/cam-shutter-MotionDone-287.ser");
                    this.motionProfileSender.processMotionDone(imageName, motionDoneClose, false);
                    JsonFile jsonProfileClose = this.motionProfileSender.getJsonFile();
                    LOG.log(Level.INFO, "Sending close {0}", jsonProfileClose);
                    this.ccs.fireEvent((CCSEvent)new CCSAdditionalFileEvent((AdditionalFile)jsonProfileClose));
                }
                catch (IOException | ClassNotFoundException ex) {
                    LOG.log(Level.SEVERE, "Could not send json file close event");
                }
            });
        }
    }

    @Override
    public void open(ImageName imageName) throws ExecutionException {
        this.currentImageName = imageName;
        this.currentOpenTime = System.currentTimeMillis();
        this.shutterState.setState(ShutterState.OPENING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.OPEN));
    }

    @Override
    public void close() throws ExecutionException {
        this.shutterState.setState(ShutterState.CLOSING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.CLOSED));
        if (this.currentImageName != null) {
            if (this.config.getCameraType() == Camera.MAIN_CAMERA) {
                double measuredShutterOpenTime = (double)(System.currentTimeMillis() - this.currentOpenTime) / 1000.0;
                CCSMeasuredShutterTime cst = new CCSMeasuredShutterTime(this.currentImageName, measuredShutterOpenTime);
                this.ccs.schedule(Duration.ofMillis(300L), () -> this.ccs.fireEvent((CCSEvent)cst));
            }
            this.currentImageName = null;
        }
    }

    @Override
    public void prepare() {
        if (this.config.getShutterPrepTime() > 0.0) {
            this.cancelNotReady();
            this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.GETTING_READY));
            this.ccs.schedule(Duration.ofMillis((long)(this.config.getShutterPrepTime() * 1000.0)), () -> {
                this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.READY));
                this.scheduleNotReady();
            });
        }
    }

    private void scheduleNotReady() {
        Duration ready_time = this.imageSequence ? READY_TIME_FOR_SEVERAL_IMAGES : READY_TIME;
        this.notReadyFuture = this.ccs.schedule(ready_time, () -> this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.NOT_READY)));
    }

    private void cancelNotReady() {
        if (this.notReadyFuture != null) {
            this.notReadyFuture.cancel(false);
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
        this.imageSequence = imageSequence;
    }

    public static MotionDone readMotionDone(String path) throws IOException, ClassNotFoundException {
        try (InputStream in = ShutterMotionProfileSender.class.getResourceAsStream(path);){
            MotionDone motionDone;
            if (in == null) {
                throw new IOException("Could not open motion profile from " + path);
            }
            try (ObjectInputStream ois = new ObjectInputStream(in);){
                StatusSubsystemData ssd = (StatusSubsystemData)ois.readObject();
                KeyValueData subsystemData = ssd.getSubsystemData();
                motionDone = (MotionDone)subsystemData.getValue();
            }
            return motionDone;
        }
    }
}

