/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutorWithReturn;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationAppliedEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationsAvailableEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSImageNameEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSimulationEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.states.CalibrationState;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.StandbyState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.KeyValueParser;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MCM {
    private final MCMConfig config;
    private final ImageNameService imageNameService;
    private static final Logger LOG = Logger.getLogger(MCM.class.getName());
    private MCMSubsystem mcmSubsystem;
    private final CCS ccs;
    private final State<TakeImageReadinessState> takeImageReadinessState;
    private final State<CalibrationState> calibrationState;
    private final State<StandbyState> standbyState;
    private final Shutter shutter;
    private final FocalPlane focalPlane;
    private final FilterChanger fcs;
    private Instant startIntegrationTime;
    private ScheduledFuture<?> startImageTimeout;
    private ScheduledFuture<?> shutterPrepSchedule;
    private ScheduledFuture<?> raftsClearSchedule;
    private CCSTimeStamp integrationStartTime = CCSTimeStamp.currentTime();
    private CompletableFuture<?> futureStartedIntegration;
    private CompletableFuture<?> futureCompleteImage;

    public MCM(CCS ccs, MCMConfig config, ImageNameService imageNameService) {
        this.ccs = ccs;
        this.config = config;
        this.imageNameService = imageNameService;
        this.takeImageReadinessState = new State<TakeImageReadinessState>(config.getShutterPrepTime() > 0.0 || !config.isAlwaysClear() ? TakeImageReadinessState.NOT_READY : TakeImageReadinessState.READY);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        ccs.getAggregateStatus().add(now, this.takeImageReadinessState);
        this.calibrationState = new State<CalibrationState>(CalibrationState.DISABLED);
        ccs.getAggregateStatus().add(now, this.calibrationState);
        this.standbyState = new State<StandbyState>(StandbyState.STANDBY);
        ccs.getAggregateStatus().add(now, this.standbyState);
        this.shutter = new Shutter(ccs, config);
        this.focalPlane = new FocalPlane(ccs, config);
        this.fcs = config.hasFilterChanger() ? new FilterChanger(ccs, config) : null;
        ccs.addStateChangeListener((when, state, oldState, cause) -> {
            AggregateStatus as = ccs.getAggregateStatus();
            TakeImageReadinessState newState = TakeImageReadinessState.READY;
            if (!config.isAlwaysClear() && !as.hasState(new Enum[]{RaftsState.QUIESCENT})) {
                newState = TakeImageReadinessState.NOT_READY;
            }
            if (config.getShutterPrepTime() > 0.0 && !as.hasState(new Enum[]{ShutterReadinessState.READY})) {
                newState = TakeImageReadinessState.NOT_READY;
            }
            if (newState != TakeImageReadinessState.NOT_READY || !as.hasState(new Enum[]{TakeImageReadinessState.GETTING_READY})) {
                this.takeImageReadinessState.setState(when, newState, cause);
            }
            if (oldState == RaftsState.CLEARING || oldState == RaftsState.READING_OUT) {
                this.integrationStartTime = when;
            }
        });
    }

    void registerMCMSubsystem(MCMSubsystem mcmSubsystem) {
        this.mcmSubsystem = mcmSubsystem;
        if (this.fcs != null) {
            this.fcs.setTopLevelAgent((Agent)mcmSubsystem);
        }
    }

    void publishDataProviderCurrentData() {
        if (this.fcs != null) {
            this.fcs.publishDataProviderCurrentData();
        }
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSInitImageCommand) {
            return this.execute((CCSCommand.CCSInitImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSTakeImagesCommand) {
            return this.execute((CCSCommand.CCSTakeImagesCommand)command);
        }
        if (command instanceof CCSCommand.CCSSetFilterCommand) {
            return this.execute((CCSCommand.CCSSetFilterCommand)command);
        }
        if (command instanceof CCSCommand.CCSInitGuidersCommand) {
            return this.execute((CCSCommand.CCSInitGuidersCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartImageCommand) {
            return this.execute((CCSCommand.CCSStartImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSEndImageCommand) {
            return this.execute((CCSCommand.CCSEndImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSClearCommand) {
            return this.execute((CCSCommand.CCSClearCommand)command);
        }
        if (command instanceof CCSCommand.CCSDiscardRowsCommand) {
            return this.execute((CCSCommand.CCSDiscardRowsCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartCommand) {
            return this.execute((CCSCommand.CCSStartCommand)command);
        }
        if (command instanceof CCSCommand.CCSStandbyCommand) {
            return this.execute((CCSCommand.CCSStandbyCommand)command);
        }
        if (command instanceof CCSCommand.CCSEnableCalibrationCommand) {
            return this.execute((CCSCommand.CCSEnableCalibrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSDisableCalibrationCommand) {
            return this.execute((CCSCommand.CCSDisableCalibrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSPlayCommand) {
            return this.execute((CCSCommand.CCSPlayCommand)command);
        }
        if (command instanceof CCSCommand.CCSDefinePlaylistCommand) {
            return this.execute((CCSCommand.CCSDefinePlaylistCommand)command);
        }
        if (command instanceof CCSCommand.CCSAllocateImageNameCommand) {
            return this.execute((CCSCommand.CCSAllocateImageNameCommand)command);
        }
        if (command instanceof CCSCommand.CCSSetHeaderKeywordsCommand) {
            return this.execute((CCSCommand.CCSSetHeaderKeywordsCommand)command);
        }
        if (command instanceof CCSCommand.CCSClearAndStartNamedIntegrationCommand) {
            return this.execute((CCSCommand.CCSClearAndStartNamedIntegrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSTakeImageCommand) {
            return this.execute((CCSCommand.CCSTakeImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSEndIntegrationCommand) {
            return this.execute((CCSCommand.CCSEndIntegrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSWaitForImageCommand) {
            return this.execute((CCSCommand.CCSWaitForImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSOpenShutterCommand) {
            return this.execute((CCSCommand.CCSOpenShutterCommand)command);
        }
        if (command instanceof CCSCommand.CCSCloseShutterCommand) {
            return this.execute((CCSCommand.CCSCloseShutterCommand)command);
        }
        throw new RuntimeException("Unknown command type: " + command);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitImageCommand command) {
        InitImageExecutor executor = new InitImageExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSTakeImagesCommand command) {
        TakeImagesExecutor executor = new TakeImagesExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSSetFilterCommand command) {
        SetFilterExecutor executor = new SetFilterExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitGuidersCommand command) {
        InitGuidersExecutor executor = new InitGuidersExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartImageCommand command) {
        StartImageExecutor executor = new StartImageExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEndImageCommand command) {
        EndImageExecutor executor = new EndImageExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSClearCommand command) {
        ClearExecutor executor = new ClearExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDiscardRowsCommand command) {
        DiscardRowsExecutor executor = new DiscardRowsExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStandbyCommand command) {
        StandbyExecutor executor = new StandbyExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartCommand command) {
        StartExecutor executor = new StartExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEnableCalibrationCommand command) {
        EnableCalibrationExecutor executor = new EnableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDisableCalibrationCommand command) {
        DisableCalibrationExecutor executor = new DisableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSPlayCommand command) {
        PlayExecutor executor = new PlayExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDefinePlaylistCommand command) {
        DefinePlaylistExecutor executor = new DefinePlaylistExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSAllocateImageNameCommand command) {
        AllocateImageNameExecutor executor = new AllocateImageNameExecutor(command);
        return new CCSCommand.CCSCommandResponse<ImageName>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSSetHeaderKeywordsCommand command) {
        SetHeaderKeywordsExecutor executor = new SetHeaderKeywordsExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSClearAndStartNamedIntegrationCommand command) {
        ClearAndStartNamedIntegration executor = new ClearAndStartNamedIntegration(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEndIntegrationCommand command) {
        EndIntegrationExecutor executor = new EndIntegrationExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSWaitForImageCommand command) {
        WaitForImageExecutor executor = new WaitForImageExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSTakeImageCommand command) {
        TakeImageExecutor executor = new TakeImageExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSOpenShutterCommand command) {
        OpenShutterExecutor executor = new OpenShutterExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSCloseShutterCommand command) {
        CloseShutterExecutor executor = new CloseShutterExecutor(command);
        return new CCSCommand.CCSCommandResponse<Void>(executor);
    }

    CCS getCCS() {
        return this.ccs;
    }

    FocalPlane getFocalPlane() {
        return this.focalPlane;
    }

    public Shutter getShutter() {
        return this.shutter;
    }

    public FilterChanger getFilterChanger() {
        return this.fcs;
    }

    MCMConfig getConfig() {
        return this.config;
    }

    private Map<String, Serializable> captializeHeaderKeywords(Map<String, String> parsedKeyValueData) {
        return parsedKeyValueData.entrySet().stream().collect(Collectors.toMap(e -> SALClassDescriptionMaker.capitalize((String)((String)e.getKey())), e -> (Serializable)e.getValue()));
    }

    private Future<?> getReadyToTakeImage() throws ExecutionException {
        CompletableFuture<Void> waitUntilReady = this.ccs.waitForStatus((Enum)TakeImageReadinessState.READY);
        if (this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
            this.focalPlane.clear(1);
            this.shutter.prepare();
        } else if (this.takeImageReadinessState.isInState(TakeImageReadinessState.GETTING_READY)) {
            boolean raftClearEnd = this.raftsClearSchedule.cancel(false);
            boolean shutterPrepEnd = this.shutterPrepSchedule.cancel(false);
            if (raftClearEnd) {
                this.focalPlane.clear(1);
            }
            if (shutterPrepEnd) {
                this.shutter.prepare();
            }
        }
        return waitUntilReady;
    }

    private CompletableFuture<?> startTakeImage(ImageName imageName, boolean openShutter, Duration exposeTime, String obsNote, Map<String, ? extends Serializable> keyValueData, Set locations) throws ExecutionException {
        if (exposeTime != null) {
            HashMap<String, ? extends Serializable> copy = new HashMap<String, Serializable>(keyValueData);
            copy.put("ExposureTime", (Serializable)((double)exposeTime.toMillis() / 1000.0));
            keyValueData = copy;
        }
        if (openShutter) {
            this.focalPlane.startIntegration(imageName, keyValueData, locations, obsNote, exposeTime);
            LOG.log(Level.INFO, "Starting expose for {0}", exposeTime);
            if (exposeTime != null) {
                this.shutter.expose(imageName, exposeTime);
                return this.ccs.waitForStatus((Enum)ShutterState.CLOSED);
            }
            this.shutter.open(imageName);
            return CompletableFuture.completedFuture(null);
        }
        this.focalPlane.startIntegration(imageName, keyValueData, locations, obsNote, exposeTime);
        if (exposeTime != null) {
            return this.ccs.scheduleCompletable(exposeTime);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<?> endTakeImage(boolean isLastImage) throws ExecutionException {
        this.focalPlane.endIntegration(true);
        return this.ccs.waitForStatus((Enum)(isLastImage ? RaftsState.READING_OUT : RaftsState.QUIESCENT));
    }

    private void imageTimeout() {
        try {
            this.shutter.close();
            this.focalPlane.endIntegration(false);
            this.calibrationState.setState(CalibrationState.ENABLED);
        }
        catch (ExecutionException x) {
            LOG.log(Level.SEVERE, "Error during image timeout", x);
        }
    }

    class InitImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitImageCommand command;

        public InitImageExecutor(CCSCommand.CCSInitImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getDeltaT() <= 0.0 || this.command.getDeltaT() > 15.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid deltaT: " + this.command.getDeltaT());
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            Duration takeImagesExpected = Duration.ofMillis((long)(this.command.getDeltaT() * 1000.0));
            MCM.this.takeImageReadinessState.setState(TakeImageReadinessState.GETTING_READY);
            MCM.this.raftsClearSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(FocalPlane.CLEAR_TIME), () -> {
                try {
                    MCM.this.focalPlane.clear(1);
                }
                catch (ExecutionException x) {
                    LOG.log(Level.SEVERE, "Error while performing scheduled clear", x);
                }
            });
            MCM.this.shutterPrepSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(Duration.ofMillis((long)MCM.this.config.getShutterPrepTime() * 1000L)), () -> MCM.this.shutter.prepare());
        }
    }

    class TakeImagesExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSTakeImagesCommand command;
        private Map<String, String> parsedKeyValueData;
        private LocationSet locations;

        public TakeImagesExecutor(CCSCommand.CCSTakeImagesCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            double minExposeTime;
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getNumImages() <= 0 || this.command.getNumImages() > MCM.this.config.getMaxImagesPerSequence()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid number of images");
            }
            double d = minExposeTime = this.command.isShutter() ? MCM.this.config.getMinExposeTime() : 0.0;
            if (this.command.getExpTime() < minExposeTime || this.command.getExpTime() > MCM.this.config.getMaxExposeTime()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid exposure time");
            }
            try {
                this.parsedKeyValueData = KeyValueParser.parse(this.command.getKeyValueMap());
                for (String key : MCM.this.config.getRequiredKeys()) {
                    if (this.parsedKeyValueData.containsKey(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Required key missing: " + key);
                }
                for (String key : this.parsedKeyValueData.keySet()) {
                    if (MCM.this.config.getAllowedKeys().contains(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Key not allowed: " + key);
                }
            }
            catch (ParseException x) {
                throw new CCSCommand.CCSPreconditionsNotMet(x.getMessage());
            }
            if (!this.command.getSensors().trim().isEmpty()) {
                try {
                    this.locations = LocationSet.of((String[])new String[]{this.command.getSensors()});
                }
                catch (RuntimeException x) {
                    throw new CCSCommand.CCSPreconditionsNotMet("Invalid sensors argument" + this.command.getSensors());
                }
            } else {
                this.locations = new LocationSet();
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            return Duration.ofMillis((long)(this.command.getExpTime() * 1000.0)).plus(Shutter.MOVE_TIME).plus(FocalPlane.READOUT_TIME).multipliedBy(this.command.getNumImages());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException, CCSCommand.CCSPreconditionsNotMet {
            List imageNames = MCM.this.imageNameService.getImageNames(this.command.getNumImages());
            Duration exposeTime = Duration.ofMillis((long)(this.command.getExpTime() * 1000.0));
            if (this.command.getNumImages() > 1) {
                MCM.this.shutter.startImageSequence();
            }
            try {
                Map captializedHeaderKeywords = MCM.this.captializeHeaderKeywords(this.parsedKeyValueData);
                HashMap<String, Integer> headerMap = new HashMap<String, Integer>(captializedHeaderKeywords);
                headerMap.put("MaxIndex", this.command.getNumImages());
                for (int i = 0; i < this.command.getNumImages(); ++i) {
                    headerMap.put("CurIndex", i + 1);
                    Future waitUntilReady = MCM.this.getReadyToTakeImage();
                    waitUntilReady.get(20L, TimeUnit.SECONDS);
                    ImageName imageName = (ImageName)imageNames.get(i);
                    double requestedShutterOpenTime = this.command.isShutter() ? this.command.getExpTime() : 0.0;
                    MCM.this.ccs.fireEvent((CCSEvent)new CCSImageNameEvent(this.parsedKeyValueData, this.command.getNumImages(), imageName, i, MCM.this.integrationStartTime, this.command.getExpTime(), requestedShutterOpenTime, this.command.isShutter(), "normal", this.command.getExpTime()));
                    LOG.log(Level.INFO, "Sent image name event for {0}", imageName);
                    CompletableFuture imageDone = MCM.this.startTakeImage(imageName, this.command.isShutter(), exposeTime, this.command.getObsNote(), headerMap, (Set)this.locations);
                    imageDone.get();
                    CompletableFuture waitUntilDone = MCM.this.endTakeImage(i + 1 == this.command.getNumImages());
                    waitUntilDone.get(FocalPlane.READOUT_TIME.plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                    LOG.log(Level.INFO, "Readout complete");
                }
            }
            finally {
                MCM.this.shutter.endImageSequence();
                MCM.this.focalPlane.clearROI();
            }
        }
    }

    class SetFilterExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSSetFilterCommand command;

        public SetFilterExecutor(CCSCommand.CCSSetFilterCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (MCM.this.fcs == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("setFilter command not supported");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!"NONE".equals(this.command.getFilterName()) && !MCM.this.fcs.filterIsAvailable(this.command.getFilterName())) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid filter: " + this.command.getFilterName());
            }
            return MCM.this.fcs.getEstimatedTimeForChange(this.command.getFilterName());
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.fcs.setFilter(this.command.getFilterName());
        }
    }

    private class InitGuidersExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitGuidersCommand command;

        public InitGuidersExecutor(CCSCommand.CCSInitGuidersCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.focalPlane.initGuiders(this.command.getRoiSpec());
        }
    }

    private class StartImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartImageCommand command;
        private Map<String, String> parsedKeyValueData;
        private LocationSet locations;

        public StartImageExecutor(CCSCommand.CCSStartImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getTimeout() < 1.0 | this.command.getTimeout() > 120.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid argument");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            try {
                this.parsedKeyValueData = KeyValueParser.parse(this.command.getKeyValueMap());
                for (String key : MCM.this.config.getRequiredKeys()) {
                    if (this.parsedKeyValueData.containsKey(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Required key missing: " + key);
                }
                for (String key : this.parsedKeyValueData.keySet()) {
                    if (MCM.this.config.getAllowedKeys().contains(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Key not allowed: " + key);
                }
            }
            catch (ParseException x) {
                throw new CCSCommand.CCSPreconditionsNotMet(x.getMessage());
            }
            if (!this.command.getSensors().trim().isEmpty()) {
                try {
                    this.locations = LocationSet.of((String[])new String[]{this.command.getSensors()});
                }
                catch (RuntimeException x) {
                    throw new CCSCommand.CCSPreconditionsNotMet("Invalid sensors argument" + this.command.getSensors());
                }
            } else {
                this.locations = new LocationSet();
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws Exception {
            CompletableFuture<Void> waitUntilReady = MCM.this.ccs.waitForStatus((Enum)TakeImageReadinessState.READY);
            if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
                MCM.this.focalPlane.clear(1);
                MCM.this.shutter.prepare();
            }
            waitUntilReady.get(1L, TimeUnit.SECONDS);
            ImageName imageName = MCM.this.imageNameService.getImageName();
            MCM.this.ccs.fireEvent((CCSEvent)new CCSImageNameEvent(this.parsedKeyValueData, 1, imageName, 1, MCM.this.integrationStartTime, 0.0, 0.0, this.command.isShutterOpen(), "calibration", this.command.getTimeout()));
            if (this.command.isShutterOpen()) {
                MCM.this.focalPlane.startIntegration(imageName, MCM.this.captializeHeaderKeywords(this.parsedKeyValueData), (Set)this.locations, this.command.getObsNote(), null);
                MCM.this.shutter.open(imageName);
            } else {
                MCM.this.focalPlane.startIntegration(imageName, MCM.this.captializeHeaderKeywords(this.parsedKeyValueData), (Set)this.locations, this.command.getObsNote(), null);
            }
            MCM.this.startIntegrationTime = Instant.now();
            MCM.this.calibrationState.setState(CalibrationState.INTEGRATING);
            MCM.this.startImageTimeout = MCM.this.ccs.schedule(Duration.ofMillis((long)(this.command.getTimeout() * 1000.0)), () -> MCM.this.imageTimeout());
        }
    }

    private class EndImageExecutor
    extends CCSExecutor {
        public EndImageExecutor(CCSCommand.CCSEndImageCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Shutter.MOVE_TIME;
        }

        @Override
        protected void execute() throws Exception {
            if (!MCM.this.startImageTimeout.cancel(false)) {
                throw new RuntimeException("Image exposure already timed out");
            }
            CompletableFuture<Void> waitUntilClosed = MCM.this.ccs.waitForStatus((Enum)ShutterState.CLOSED);
            MCM.this.shutter.close();
            waitUntilClosed.get(Shutter.MOVE_TIME.plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
            MCM.this.focalPlane.endIntegration(true);
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class ClearExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSClearCommand command;

        public ClearExecutor(CCSCommand.CCSClearCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getNClears() <= 0 || this.command.getNClears() > 15) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid nClears: " + this.command.getNClears());
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return FocalPlane.CLEAR_TIME.multipliedBy(this.command.getNClears());
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.clear(this.command.getNClears());
            CompletableFuture<Void> waitUntilClear = MCM.this.ccs.waitForStatus((Enum)RaftsState.QUIESCENT);
            waitUntilClear.get(FocalPlane.CLEAR_TIME.multipliedBy(this.command.getNClears()).plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private class DiscardRowsExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDiscardRowsCommand command;

        public DiscardRowsExecutor(CCSCommand.CCSDiscardRowsCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            MCM.this.focalPlane.discardRows(this.command.getnRows());
            CompletableFuture<Void> waitUntilDone = MCM.this.ccs.waitForStatus((Enum)RaftsState.INTEGRATING);
            waitUntilDone.get(FocalPlane.DISCARD_TIME.multipliedBy(this.command.getnRows()).plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private class StandbyExecutor
    extends CCSExecutor {
        public StandbyExecutor(CCSCommand.CCSStandbyCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.standbyState.setState(StandbyState.STANDBY);
            MCM.this.ccs.fireEvent((CCSEvent)new CCSConfigurationsAvailableEvent("Normal", 1, "https://lsst-camera-dev.slac.stanford.edu/RestFileServer/config/", "UNKNOWN"));
        }
    }

    private class StartExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartCommand command;

        public StartExecutor(CCSCommand.CCSStartCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ofSeconds(5L);
        }

        @Override
        protected void execute() throws ExecutionException {
            String requestedConfig = this.command.getConfiguration();
            if (requestedConfig.trim().isEmpty()) {
                requestedConfig = "Normal";
            }
            if (MCM.this.fcs != null) {
                MCM.this.fcs.start("default");
            }
            if (MCM.this.focalPlane != null) {
                MCM.this.focalPlane.start("default");
            }
            if (MCM.this.shutter != null) {
                MCM.this.shutter.start("default");
            }
            if (MCM.this.mcmSubsystem != null) {
                for (String other : MCM.this.config.getOtherConfiguredSubsystems()) {
                    try {
                        AgentMessagingLayer agentMessagingLayer = MCM.this.mcmSubsystem.getMessagingAccess();
                        CommandRequest request = new CommandRequest(other, "publishConfigurationInfo");
                        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
                        cmu.sendSynchronousCommand(request);
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Unable to send publishConfigurationInfo to " + other, x);
                    }
                }
            }
            MCM.this.standbyState.setState(StandbyState.STARTED);
            CCSTimeStamp now = CCSTimeStamp.currentTime();
            MCM.this.ccs.fireEvent((CCSEvent)new CCSConfigurationAppliedEvent(requestedConfig, now.getTAIDouble(), 1, "https://lsst-camera-dev.slac.stanford.edu/RestFileServer/config/", "UNKNOWN"));
            MCM.this.ccs.fireEvent((CCSEvent)new CCSSimulationEvent(MCM.this.config.getSimulationMode()));
        }
    }

    private class EnableCalibrationExecutor
    extends CCSExecutor {
        public EnableCalibrationExecutor(CCSCommand.CCSEnableCalibrationCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.DISABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class DisableCalibrationExecutor
    extends CCSExecutor {
        public DisableCalibrationExecutor(CCSCommand.CCSDisableCalibrationCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.DISABLED);
        }
    }

    private class PlayExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSPlayCommand command;

        public PlayExecutor(CCSCommand.CCSPlayCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getPlaylist().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid playlist: " + this.command.getPlaylist());
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.play(this.command.getPlaylist(), this.command.isRepeat());
        }
    }

    private class DefinePlaylistExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDefinePlaylistCommand command;

        public DefinePlaylistExecutor(CCSCommand.CCSDefinePlaylistCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getPlaylist().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid playlist: " + this.command.getPlaylist());
            }
            if (this.command.getFolder().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid folder: " + this.command.getFolder());
            }
            if (this.command.getImages().length == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid image list: " + Arrays.toString(this.command.getImages()));
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.definePlaylist(this.command.getPlaylist(), this.command.getFolder(), this.command.getImages());
        }
    }

    private class AllocateImageNameExecutor
    extends CCSExecutorWithReturn<ImageName> {
        public AllocateImageNameExecutor(CCSCommand.CCSAllocateImageNameCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ZERO;
        }

        @Override
        protected ImageName executeAndReturn() {
            return MCM.this.imageNameService.getImageName();
        }
    }

    private class SetHeaderKeywordsExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSSetHeaderKeywordsCommand command;

        public SetHeaderKeywordsExecutor(CCSCommand.CCSSetHeaderKeywordsCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.focalPlane.setHeaderKeywords(this.command.getHeadersMap());
        }
    }

    class ClearAndStartNamedIntegration
    extends CCSExecutor {
        private final CCSCommand.CCSClearAndStartNamedIntegrationCommand command;

        public ClearAndStartNamedIntegration(CCSCommand.CCSClearAndStartNamedIntegrationCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws ExecutionException, InterruptedException, TimeoutException {
            Future waitUntilReady = MCM.this.getReadyToTakeImage();
            waitUntilReady.get(20L, TimeUnit.SECONDS);
            ImageName imageName = this.command.getImageName();
            LOG.log(Level.INFO, "Sent image name event for {0}", imageName);
            MCM.this.startIntegrationTime = Instant.now();
            MCM.this.futureStartedIntegration = MCM.this.startTakeImage(imageName, this.command.isShutter(), null, this.command.getAnnotation(), this.command.getHeadersMap(), this.command.getSensors());
        }
    }

    class EndIntegrationExecutor
    extends CCSExecutor {
        public EndIntegrationExecutor(CCSCommand.CCSEndIntegrationCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (MCM.this.futureStartedIntegration == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("No integration in progress");
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws Exception {
            try {
                MCM.this.futureCompleteImage = new CompletableFuture();
                MCM.this.futureStartedIntegration.thenAccept(result -> {
                    try {
                        MCM.this.endTakeImage(false).thenAccept(r2 -> MCM.this.futureCompleteImage.complete(null));
                    }
                    catch (ExecutionException x) {
                        MCM.this.futureCompleteImage.completeExceptionally(x);
                    }
                });
            }
            finally {
                MCM.this.futureStartedIntegration = null;
            }
        }
    }

    class WaitForImageExecutor
    extends CCSExecutor {
        public WaitForImageExecutor(CCSCommand.CCSWaitForImageCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (MCM.this.futureCompleteImage == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("No image in progress");
            }
            return Duration.ofSeconds(120L);
        }

        @Override
        protected void execute() throws Exception {
            try {
                MCM.this.futureCompleteImage.get();
            }
            finally {
                MCM.this.futureCompleteImage = null;
            }
        }
    }

    class TakeImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSTakeImageCommand command;

        public TakeImageExecutor(CCSCommand.CCSTakeImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws ExecutionException, InterruptedException, TimeoutException {
            Future waitUntilReady = MCM.this.getReadyToTakeImage();
            waitUntilReady.get(20L, TimeUnit.SECONDS);
            ImageName imageName = this.command.getImageName();
            LOG.log(Level.INFO, "Sent image name event for {0}", imageName);
            Duration exposeTime = Duration.ofMillis((long)(this.command.getExpTime() * 1000.0));
            CompletableFuture exposeDone = MCM.this.startTakeImage(imageName, this.command.isShutter(), exposeTime, this.command.getAnnotation(), this.command.getHeadersMap(), this.command.getSensors());
            MCM.this.futureCompleteImage = new CompletableFuture();
            exposeDone.thenAccept(result -> {
                try {
                    MCM.this.endTakeImage(false).thenAccept(r2 -> MCM.this.futureCompleteImage.complete(null));
                }
                catch (ExecutionException x) {
                    MCM.this.futureCompleteImage.completeExceptionally(x);
                }
            });
        }
    }

    class OpenShutterExecutor
    extends CCSExecutor {
        public OpenShutterExecutor(CCSCommand.CCSOpenShutterCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ofSeconds(10L);
        }

        @Override
        protected void execute() throws Exception {
            MCM.this.shutter.ensureOpen();
        }
    }

    class CloseShutterExecutor
    extends CCSExecutor {
        public CloseShutterExecutor(CCSCommand.CCSCloseShutterCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ofSeconds(10L);
        }

        @Override
        protected void execute() throws Exception {
            MCM.this.shutter.ensureClosed();
        }
    }
}

