/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;

public class AdditionalFileToLFAEvent {
    private final LargeFileObjectAvailableEvent lfaEvent;
    private final Long cksum;
    private final Long byteSize;

    public AdditionalFileToLFAEvent(AdditionalFile addFile, String url) throws IOException {
        CountOutputStream cnos = new CountOutputStream();
        CRC32 cksum32 = new CRC32();
        CheckedOutputStream cos = new CheckedOutputStream(cnos, cksum32);
        addFile.writeFile((OutputStream)cos);
        this.byteSize = cnos.getByteCount();
        this.cksum = cos.getChecksum().getValue();
        float lfaVersion = 1.0f;
        String fileName = addFile.getFileName();
        String mimetype = "text/plain";
        if (fileName.endsWith("json")) {
            mimetype = "application/json";
        } else if (fileName.endsWith(".ecsv")) {
            mimetype = "text/csv";
        }
        this.lfaEvent = new LargeFileObjectAvailableEvent(url, AdditionalFileToLFAEvent.class.getCanonicalName(), lfaVersion, this.byteSize.intValue(), this.cksum.toString(), mimetype, fileName);
    }

    LargeFileObjectAvailableEvent getlfaEvent() {
        return this.lfaEvent;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getChecksum() {
        return this.cksum;
    }

    private class CountOutputStream
    extends OutputStream {
        long byteCount = 0L;

        private CountOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.byteCount;
        }

        long getByteCount() {
            return this.byteCount;
        }
    }
}

