/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FocalPlaneSimulation
implements FocalPlaneInterface {
    private final State raftsState;
    private final CCS ccs;
    static final Duration QUIESCENT_BEFORE_CLEAR = Duration.ofMillis(4000L);

    public FocalPlaneSimulation(final CCS ccs, final State raftsState) {
        this.raftsState = raftsState;
        this.ccs = ccs;
        raftsState.addStateChangeListener(new State.StateChangeListener<RaftsState>(){
            private ScheduledFuture<?> clearFuture;

            @Override
            public void stateChanged(CCSTimeStamp when, RaftsState currentState, RaftsState oldState, String cause) {
                if (currentState == RaftsState.QUIESCENT) {
                    this.clearFuture = ccs.schedule(QUIESCENT_BEFORE_CLEAR, () -> raftsState.setState(when, RaftsState.NEEDS_CLEAR, "Spent more than " + QUIESCENT_BEFORE_CLEAR + " in quiescent state."));
                } else if (this.clearFuture != null) {
                    this.clearFuture.cancel(false);
                    this.clearFuture = null;
                }
            }
        });
    }

    @Override
    public void clear(int nClears) {
        this.raftsState.checkState(new Enum[]{RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR});
        this.raftsState.setState(RaftsState.CLEARING);
        this.ccs.schedule(FocalPlane.CLEAR_TIME.multipliedBy(nClears), () -> this.raftsState.setState(RaftsState.QUIESCENT));
    }

    @Override
    public void discardRows(int nRows) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{RaftsState.INTEGRATING});
        this.raftsState.setState(RaftsState.DISCARDING);
        this.ccs.schedule(FocalPlane.DISCARD_TIME.multipliedBy(nRows), () -> this.raftsState.setState(RaftsState.INTEGRATING));
    }

    @Override
    public void endIntegration(boolean readout) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{RaftsState.INTEGRATING});
        if (readout) {
            this.raftsState.setState(RaftsState.READING_OUT);
            this.ccs.schedule(FocalPlane.READOUT_TIME, () -> this.raftsState.setState(RaftsState.QUIESCENT));
        } else {
            this.raftsState.setState(RaftsState.NEEDS_CLEAR);
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void startIntegration(ImageName imageName, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{RaftsState.QUIESCENT});
        this.raftsState.setState(RaftsState.INTEGRATING);
    }

    @Override
    public void play(String playlist, boolean repeat) {
    }

    @Override
    public void definePlaylist(String playlist, String folder, String ... images) {
    }

    @Override
    public void clearAndStartIntegration(ImageName imageName, int nClears, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        try {
            this.clear(nClears);
            this.ccs.waitForStatus((Enum)RaftsState.QUIESCENT).get(FocalPlane.CLEAR_TIME.toMillis() + 1000L, TimeUnit.MILLISECONDS);
            this.startIntegration(imageName, parsedKeyValueData, locations, annotation, stopGuiding);
        }
        catch (InterruptedException ex) {
            throw new ExecutionException("Interrupt waiting for clear", ex);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for clear", ex);
        }
    }

    @Override
    public void initGuiders(String roiSpec) {
    }

    @Override
    public void clearROI() throws ExecutionException {
    }

    @Override
    public void setHeaderKeywords(Map<String, Serializable> headersMap) {
    }
}

