/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.CandidateListCompletionHandler;

class CommandCompletionHandler
extends CandidateListCompletionHandler {
    CommandCompletionHandler() {
    }

    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        ArrayList<CharSequence> helpCandidates = new ArrayList<CharSequence>();
        for (CharSequence candidate : candidates) {
            if (!candidate.toString().startsWith("# ")) continue;
            helpCandidates.add(candidate);
        }
        if (helpCandidates.size() == candidates.size() && candidates.size() > 0) {
            reader.println();
            for (CharSequence helpCandidate : helpCandidates) {
                reader.println(helpCandidate.subSequence(1, helpCandidate.length()));
            }
            reader.drawLine();
            return true;
        }
        for (CharSequence helpCandidate : helpCandidates) {
            candidates.remove(helpCandidate);
        }
        String toComplete = reader.getCursorBuffer().toString().substring(pos);
        int length = toComplete.length();
        ArrayList<String> pathAdjustedCandidates = new ArrayList<String>();
        for (CharSequence candidate : candidates) {
            String candidateStr = candidate.toString();
            int ind = candidateStr.indexOf("/", length);
            if (ind > 0) {
                candidateStr = candidateStr.substring(0, ind);
            }
            if (pathAdjustedCandidates.contains(candidateStr)) continue;
            pathAdjustedCandidates.add(candidateStr);
        }
        Iterator iter = pathAdjustedCandidates.iterator();
        while (iter.hasNext()) {
            String cs = ((CharSequence)iter.next()).toString();
            if (!cs.endsWith(" ") || !pathAdjustedCandidates.contains(cs.trim())) continue;
            iter.remove();
        }
        if (pathAdjustedCandidates.size() == 1 && ((CharSequence)pathAdjustedCandidates.get(0)).equals(toComplete)) {
            String path = ((CharSequence)pathAdjustedCandidates.remove(0)).toString() + "/";
            pathAdjustedCandidates.add(path);
        }
        return super.complete(reader, pathAdjustedCandidates, pos);
    }
}

