package org.lsst.ccs.subsystem.ocsbridge;

import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.camera.Camera;
import org.lsst.sal.camera.CameraTelemetry;

/**
 *
 * @author tonyj
 */
public class AuxTelTelemetrySender extends TelemetrySender {

    public AuxTelTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler, Camera.AUXTEL);
    }

    @Override
    protected CameraTelemetry applyAfterBurner(CameraTelemetry t) {
        // Fix for LCOBM-54, remove if LSSTCCSRAFTS-663 is ever fixed.
        if (t instanceof org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry) {
            org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry fct = (org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry) t;
            String location = fct.getLocation();
            if ("R00SW".equals(location)) {
                return new org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry(fct.getGDV(), "R00S00", fct.getODI(), fct.getODV(), fct.getOGV(), fct.getRDV(), fct.getTemp());
            } 
        }
        return t;
    }


}
