/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChecksumExtractorUtils {
    private final Pattern commentPattern = Pattern.compile("CCS: Dictionary_Checksum: (\\d+)L\\s+");
    private final XPathExpression commentExpression;
    private final XPathExpression topicExpression;

    public ChecksumExtractorUtils() throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        this.topicExpression = xPath.compile("//EFDB_Topic");
        this.commentExpression = xPath.compile("following-sibling::comment()[1]");
    }

    public Map<String, Long> extractChecksumsFromSALXMLInputStream(InputStream in) throws SAXException, XPathExpressionException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(in);
        return this.extractChecksums(document);
    }

    public Map<String, Long> extractChecksums(Document document) throws XPathExpressionException {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        NodeList topicNodes = (NodeList)this.topicExpression.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < topicNodes.getLength(); ++i) {
            String comment;
            Matcher matcher;
            Node topicNode = topicNodes.item(i);
            String topic = topicNode.getTextContent();
            Comment commentNode = (Comment)this.commentExpression.evaluate(topicNode, XPathConstants.NODE);
            if (commentNode == null || !(matcher = this.commentPattern.matcher(comment = commentNode.getNodeValue())).matches()) continue;
            long checksum = Long.parseLong(matcher.group(1));
            result.put(topic, checksum);
        }
        return result;
    }

    public Map<String, Long> extractChecksumsFromDataProviderDictionaryForAgent(Camera camera, String agentName, DataProviderDictionary dataProviderDictionary) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        result.putAll(this.extractChecksumsFromDataProviderDictionaryForSALType(camera, XMLMaker2.SALType.TELEMETRY, agentName, dataProviderDictionary));
        result.putAll(this.extractChecksumsFromDataProviderDictionaryForSALType(camera, XMLMaker2.SALType.SETTINGS_APPLIED, agentName, dataProviderDictionary));
        return result;
    }

    private Map<String, Long> extractChecksumsFromDataProviderDictionaryForSALType(Camera camera, XMLMaker2.SALType salType, String agentName, DataProviderDictionary dataProviderDictionary) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        MakeXMLConfiguration config = MakeXMLConfiguration.getInstance(camera, salType, agentName, dataProviderDictionary);
        if (config.getOrderedListOfDictionaryConfigurations().size() > 1) {
            throw new RuntimeException("Only one dictionary configuration expected here.");
        }
        for (MakeXMLConfiguration.DictionaryConfiguration dc : config.getOrderedListOfDictionaryConfigurations()) {
            result.putAll(this.extractChecksumsFromDictionaryConfiguration(dc, config.getMapping()));
        }
        return result;
    }

    public Map<String, Long> extractChecksumsFromDictionaryConfiguration(MakeXMLConfiguration.DictionaryConfiguration dc, Mapping mapping) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(dc, mapping);
        Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        for (Map.Entry<String, SALClassDescription> entry : salClassDescriptions.entrySet()) {
            String name = entry.getKey();
            SALClassDescription scd = entry.getValue();
            result.put(name, scd.computeChecksum());
        }
        return result;
    }

    public static long checkXML(XMLMaker2 maker, Document dom) throws TransformerException {
        CRC32 checkSum = new CRC32();
        StreamResult output = new StreamResult(new CheckedOutputStream(new NullOutputStream(), checkSum));
        maker.writeXML(output, dom);
        return checkSum.getValue();
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

