/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;

public class Playlist
implements AutoCloseable {
    private final long playlist;
    private final Emulator emulator;
    private final Store store;

    Playlist(Store store, Emulator emulator, long playlist) {
        this.store = store;
        this.emulator = emulator;
        this.playlist = playlist;
    }

    public void add(Image image) throws DAQException {
        this.emulator.addImageToPlaylist(this.playlist, image);
    }

    public List<Image> getImages() throws DAQException {
        ArrayList<Image> result = new ArrayList<Image>();
        ArrayList<ImageMetaData> metaData = new ArrayList<ImageMetaData>();
        this.emulator.list(this.playlist, metaData);
        metaData.forEach(meta -> result.add(new Image(this.store, (ImageMetaData)meta)));
        return result;
    }

    public int size() throws DAQException {
        return this.emulator.playlistSize(this.playlist);
    }

    public void start(boolean repeat) throws DAQException {
        this.emulator.startPlaylist(this.playlist, repeat);
    }

    @Override
    public void close() throws DAQException {
        this.emulator.closePlayList(this.playlist);
    }
}

