/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class GenericConverterTest {
    @Test
    public void ComCamDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-daq-monitor-trending.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem("comcam-daq-monitor");
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraTelemetry telemetry : converted) {
            if (!(telemetry instanceof Daq_monitor_StoreTelemetry)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
            Assert.assertEquals((double)966.3676416, (double)dst.getCapacity(), (double)1.0E-5);
            Assert.assertEquals((double)778.797318144, (double)dst.getFreeSpace(), (double)1.0E-5);
            Assert.assertEquals((double)0.8059016927083333, (double)dst.getFreeFraction(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void ComCamFocalPlaneTest2() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String[] rebs = new String[]{"Reb0", "Reb1", "Reb2"};
        String[] groups = new String[]{"", "_aspicTemp", "_biasVolt", "_boardPower", "_ccdCurrent", "_rebTemp"};
        String agentName = "comcam-fp";
        String fileName = "comcam/comcam-fp-default-trending.ser";
        StatusSubsystemData combinedData = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)combinedData.getOriginAgentInfo().getName());
        for (String reb : rebs) {
            for (String group : groups) {
                fileName = String.format("comcam/comcam-fp-default_R22_%s%s-trending.ser", reb, group);
                StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)fileName);
                Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
                GenericConverterTest.combineTelemetry(combinedData, data);
            }
        }
        Assert.assertEquals((long)638L, (long)combinedData.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(combinedData);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, combinedData), (long)converted.size());
        boolean foundCcdTelemetry = false;
        boolean foundRebTelemetry = false;
        boolean foundSegTelemetry = false;
        for (CameraTelemetry t : converted) {
            int length;
            if (t instanceof Focal_plane_CcdTelemetry) {
                Assert.assertFalse((boolean)foundCcdTelemetry);
                foundCcdTelemetry = true;
                Focal_plane_CcdTelemetry fpCCD = (Focal_plane_CcdTelemetry)t;
                length = fpCCD.getLocation().split(":").length;
                Assert.assertEquals((long)9L, (long)length);
                Assert.assertEquals((long)9L, (long)fpCCD.getGDV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getODV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getOGV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getRDV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getTemp().length);
                continue;
            }
            if (t instanceof org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry) {
                Assert.assertFalse((boolean)foundRebTelemetry);
                foundRebTelemetry = true;
                org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry fpREB = (org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry)t;
                length = fpREB.getLocation().split(":").length;
                Assert.assertEquals((long)3L, (long)length);
                Assert.assertEquals((long)3L, (long)fpREB.getAnaI().length);
                Assert.assertEquals((long)3L, (long)fpREB.getAnaV().length);
                Assert.assertEquals((long)3L, (long)fpREB.getDigI().length);
                Assert.assertEquals((long)3L, (long)fpREB.getDigV().length);
                continue;
            }
            if (!(t instanceof Focal_plane_SegmentTelemetry)) continue;
            Assert.assertFalse((boolean)foundSegTelemetry);
            foundSegTelemetry = true;
            Focal_plane_SegmentTelemetry fpSeg = (Focal_plane_SegmentTelemetry)t;
            length = fpSeg.getLocation().split(":").length;
            Assert.assertEquals((long)144L, (long)length);
            Assert.assertEquals((long)144L, (long)fpSeg.getI().length);
        }
        Assert.assertTrue((boolean)foundCcdTelemetry);
        Assert.assertTrue((boolean)foundRebTelemetry);
        Assert.assertTrue((boolean)foundSegTelemetry);
    }

    @Test
    public void AuxTelDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "ats-daq-monitor";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-daq-monitor-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraTelemetry telemetry : converted) {
            if (!(telemetry instanceof Daq_monitor_StoreTelemetry)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
            Assert.assertEquals((double)322.1225472, (double)dst.getCapacity(), (double)1.0E-5);
            Assert.assertEquals((double)314.9219665527344, (double)dst.getFreeSpace(), (double)1.0E-5);
            Assert.assertEquals((double)0.9776464210626838, (double)dst.getFreeFraction(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void ComCamVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-vacuum";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-vacuum-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            if (telemetry instanceof Vacuum_VQMonitorTelemetry) {
                Vacuum_VQMonitorTelemetry vqm = (Vacuum_VQMonitorTelemetry)telemetry;
                Assert.assertEquals((double)8.46E-8, (double)vqm.getVqmpressure(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_TurboTelemetry) {
                Vacuum_TurboTelemetry turbo = (Vacuum_TurboTelemetry)telemetry;
                Assert.assertEquals((double)12.0, (double)turbo.getPumpTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold1Telemetry) {
                Vacuum_Cold1Telemetry cold1 = (Vacuum_Cold1Telemetry)telemetry;
                Assert.assertEquals((double)-98.03, (double)cold1.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold2Telemetry) {
                Vacuum_Cold2Telemetry cold2 = (Vacuum_Cold2Telemetry)telemetry;
                Assert.assertEquals((double)-67.51, (double)cold2.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_CryoTelemetry) {
                Vacuum_CryoTelemetry cryo = (Vacuum_CryoTelemetry)telemetry;
                Assert.assertEquals((double)-150.31, (double)cryo.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_RtdsTelemetry) {
                Vacuum_RtdsTelemetry rtds = (Vacuum_RtdsTelemetry)telemetry;
                Assert.assertEquals((double)-58.86454f, (double)rtds.getTemperatureCold1(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_IonPumpsTelemetry) {
                Vacuum_IonPumpsTelemetry ionpumps = (Vacuum_IonPumpsTelemetry)telemetry;
                Assert.assertEquals((double)5008.63623, (double)ionpumps.getVoltage(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "ats";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraTelemetry telemetry : converted) {
            if (!(telemetry instanceof VacuumTelemetry)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            VacuumTelemetry vt = (VacuumTelemetry)telemetry;
            Assert.assertEquals((double)-94.1477, (double)vt.getTempCCD(), (double)1.0E-5);
            Assert.assertEquals((double)-114.7494, (double)vt.getTempColdPlate(), (double)1.0E-5);
            Assert.assertEquals((double)-140.4627, (double)vt.getTempCryoHead(), (double)1.0E-5);
            Assert.assertEquals((double)3.6E-6, (double)vt.getVacuum(), (double)1.0E-5);
            Assert.assertEquals((double)-94.15, (double)vt.getTempCCDSetPoint(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void AuxTelPowerTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "ats-power";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-power-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraTelemetry telemetry : converted) {
            if (!(telemetry instanceof PowerTelemetry)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            PowerTelemetry pt = (PowerTelemetry)telemetry;
            Assert.assertEquals((double)5.25, (double)pt.getDigital_V(), (double)1.0E-5);
            Assert.assertEquals((double)665.5, (double)pt.getDigital_I(), (double)1.0E-5);
            Assert.assertEquals((double)7.2, (double)pt.getAnalog_V(), (double)1.0E-5);
            Assert.assertEquals((double)12.0, (double)pt.getClkhigh_V(), (double)1.0E-5);
            Assert.assertEquals((double)12.0, (double)pt.getClklow_V(), (double)1.0E-5);
            Assert.assertEquals((double)32.05, (double)pt.getOd_V(), (double)1.0E-5);
            Assert.assertEquals((double)10.0, (double)pt.getDphi_V(), (double)1.0E-5);
            Assert.assertEquals((double)12.0, (double)pt.getFan_V(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void AuxTelFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "ats-fp";
        StatusSubsystemData data1 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data1.getOriginAgentInfo().getName());
        StatusSubsystemData data2 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_rebTemp-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data2.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data2);
        StatusSubsystemData data3 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_aspicTemp-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data3.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data3);
        StatusSubsystemData data4 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data4.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data4);
        StatusSubsystemData data5 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_crVolt-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data5.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data5);
        StatusSubsystemData data6 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data6.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data6);
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data1);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data1), (long)converted.size());
        boolean foundRebTelemetry = false;
        boolean foundRebTotalPowerTelemetry = false;
        boolean foundCcdTelemetry = false;
        for (CameraTelemetry telemetry : converted) {
            Focal_plane_RebTelemetry fpt;
            if (telemetry instanceof Focal_plane_RebTelemetry) {
                Assert.assertFalse((boolean)foundRebTelemetry);
                foundRebTelemetry = true;
                fpt = (Focal_plane_RebTelemetry)telemetry;
                Assert.assertEquals((double)362.01167416262933, (double)fpt.getRTDTemp()[0], (double)1.0E-5);
                Assert.assertEquals((double)28.5, (double)fpt.getTemp1()[0], (double)1.0E-5);
                Assert.assertEquals((double)29.5625, (double)fpt.getTemp2()[0], (double)1.0E-5);
                Assert.assertEquals((double)28.4375, (double)fpt.getTemp3()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.6875, (double)fpt.getTemp4()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.25, (double)fpt.getTemp5()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.0625, (double)fpt.getTemp6()[0], (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicu_Temp0()[0], (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicl_Temp0()[0], (double)1.0E-5);
                Assert.assertEquals((double)5.275, (double)fpt.getDigV()[0], (double)1.0E-5);
                Assert.assertEquals((double)697.0, (double)fpt.getDigI()[0], (double)1.0E-5);
                Assert.assertEquals((double)7.2, (double)fpt.getAnaV()[0], (double)1.0E-5);
                Assert.assertEquals((double)345.0, (double)fpt.getAnaI()[0], (double)1.0E-5);
                Assert.assertEquals((double)12.025, (double)fpt.getClkHV()[0], (double)1.0E-5);
                Assert.assertEquals((double)31.25, (double)fpt.getClkHI()[0], (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV()[0], (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI()[0], (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV()[0], (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI()[0], (double)1.0E-5);
                Assert.assertEquals((double)7.49795625, (double)fpt.getPower()[0], (double)1.0E-5);
                Assert.assertEquals((Object)"R00RebW", (Object)fpt.getLocation());
                Assert.assertEquals((double)-11.97925537109375, (double)fpt.getClkLV()[0], (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Focal_plane_RebTotalPowerTelemetry) {
                Assert.assertFalse((boolean)foundRebTotalPowerTelemetry);
                foundRebTotalPowerTelemetry = true;
                fpt = (Focal_plane_RebTotalPowerTelemetry)telemetry;
                Assert.assertEquals((double)7.4979563, (double)fpt.getRebTotalPower(), (double)1.0E-5);
                continue;
            }
            if (!(telemetry instanceof org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry)) continue;
            Assert.assertFalse((boolean)foundCcdTelemetry);
            foundCcdTelemetry = true;
            fpt = (org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry)telemetry;
            Assert.assertEquals((double)25.03779052734375, (double)fpt.getODV()[0], (double)1.0E-5);
        }
        Assert.assertTrue((boolean)foundRebTelemetry);
        Assert.assertTrue((boolean)foundRebTotalPowerTelemetry);
        Assert.assertTrue((boolean)foundCcdTelemetry);
    }

    @Test
    public void MainCameraDaqMonitorTrendingTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        String agentName = "daq-monitor";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"maincamera/daq-monitor-R11_Reb1_Rms-1136084437-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)GenericConverterTest.getNumberOfMatchingClassesForData(converter, data), (long)converted.size());
        Assert.assertTrue((GenericConverterTest.getNumberOfMatchingClassesForData(converter, data) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(converted.get(0) instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry rebTrendingTelemetry = (Daq_monitor_Reb_TrendingTelemetry)converted.get(0);
        String location = rebTrendingTelemetry.getLocation();
        System.out.println(" Location " + location);
        String[] locations = location.split(":");
        for (int i = 0; i < locations.length; ++i) {
            if (!locations[i].equals("R11Reb1")) continue;
            Assert.assertEquals((long)61459L, (long)rebTrendingTelemetry.getFirmware_link_status()[i]);
            return;
        }
        Assert.fail((String)"Did not find R11Reb1");
    }

    @Test
    public void AuxTelFocalPlaneTest2() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "ats-fp";
        StatusSubsystemData data1 = SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data1.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data1);
        Assert.assertEquals((long)1L, (long)converted.size());
    }

    @Test
    public void ComCamFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-fp";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-fp-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)3L, (long)converted.size());
        boolean found = false;
        for (CameraTelemetry telemetry : converted) {
            if (!(telemetry instanceof org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry fpTelemetry = (org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry)telemetry;
            Assert.assertEquals((long)3L, (long)fpTelemetry.getHVBiasSwitch().length);
            Assert.assertEquals((long)3L, (long)fpTelemetry.getTemp1().length);
            Assert.assertEquals((long)3L, (long)fpTelemetry.getODI().length);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void ComCamFocalPlaneTest3() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-fp";
        String fileName = "comcam/comcam-fp-default-trending.ser";
        StatusSubsystemData combinedData = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)combinedData.getOriginAgentInfo().getName());
        Assert.assertEquals((long)2L, (long)combinedData.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(combinedData);
        Assert.assertEquals((long)1L, (long)converted.size());
    }

    @Test
    public void ComCamRebPowerTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-rebpower";
        String fileName = "comcam/comcam-rebpower-trending.ser";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        Assert.assertEquals((long)224L, (long)data.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)2L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            Rebpower_RebTelemetry rpt;
            if (telemetry instanceof Rebpower_RebTelemetry) {
                rpt = (Rebpower_RebTelemetry)telemetry;
                Assert.assertEquals((double)0.091866f, (double)rpt.getHvbias_IbefSwch()[0], (double)1.0E-5);
                Assert.assertEquals((double)11.75892f, (double)rpt.getHeater_VaftLDO()[0], (double)1.0E-5);
                Assert.assertEquals((double)19.016298294067383, (double)rpt.getPower()[0], (double)1.0E-5);
                Assert.assertEquals((Object)"R22Reb0:R22Reb1:R22Reb2:R23Reb0:R23Reb1:R23Reb2", (Object)rpt.getLocation());
                continue;
            }
            if (telemetry instanceof Rebpower_RebpsTelemetry) {
                rpt = (Rebpower_RebpsTelemetry)telemetry;
                Assert.assertEquals((double)19.0, (double)rpt.getBoardTemp1()[0], (double)1.0E-5);
                Assert.assertEquals((Object)"P00", (Object)rpt.getLocation());
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void ComCamFCSTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-fcs";
        String fileName = "comcam/comcam-fcs-trending.ser";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        Assert.assertEquals((long)6L, (long)data.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            if (telemetry instanceof FcsTelemetry) {
                FcsTelemetry rpt = (FcsTelemetry)telemetry;
                Assert.assertEquals((double)21.160551071166992, (double)rpt.getSteppermotor_MotorTemperature(), (double)1.0E-5);
                Assert.assertEquals((double)3813.025, (double)rpt.getLinearencoder_LinearPosition(), (double)1.0E-5);
                Assert.assertEquals((double)-30594.0, (double)rpt.getSteppermotor_MotorEncoder(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void ComCamBonnShutterTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "bonn-shutter";
        String fileName = "comcam/comcam-bonn-shutter-trending.ser";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        Assert.assertEquals((long)4L, (long)data.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            if (telemetry instanceof org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry) {
                org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry rpt = (org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry)telemetry;
                Assert.assertEquals((double)5.0, (double)rpt.getBonn_V5(), (double)1.0E-5);
                Assert.assertEquals((double)35.6, (double)rpt.getBonn_V36(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelBonnShutterTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "bonn-shutter";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)"auxtel/bonn-shutter-trending.ser");
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        Assert.assertEquals((long)4L, (long)data.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        Assert.assertTrue((boolean)(telemetry instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry dst = (Bonn_shutter_DeviceTelemetry)telemetry;
    }

    @Test
    public void ComCamQuadboxTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String agentName = "comcam-quadbox";
        String fileName = "comcam/comcam-quadbox-trending.ser";
        StatusSubsystemData data = SerializationUtils.readStatusSubsystemData((String)fileName);
        Assert.assertEquals((Object)agentName, (Object)data.getOriginAgentInfo().getName());
        Assert.assertEquals((long)122L, (long)data.getEncodedData().getListOfKeyValueData().size());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
        converter.addSubsystem(agentName);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)5L, (long)converted.size());
        System.out.println(converted);
        for (CameraTelemetry telemetry : converted) {
            Quadbox_BFRTelemetry rpt;
            if (telemetry instanceof Quadbox_BFRTelemetry) {
                rpt = (Quadbox_BFRTelemetry)telemetry;
                Assert.assertEquals((double)680.0, (double)rpt.getClean_5_24V_I(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Quadbox_PDU_24VCTelemetry) {
                rpt = (Quadbox_PDU_24VCTelemetry)telemetry;
                Assert.assertEquals((double)20.0, (double)rpt.getBoard_T(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Quadbox_PDU_24VDTelemetry) {
                rpt = (Quadbox_PDU_24VDTelemetry)telemetry;
                Assert.assertEquals((double)19.0, (double)rpt.getBoard_T(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Quadbox_PDU_48VTelemetry) {
                rpt = (Quadbox_PDU_48VTelemetry)telemetry;
                Assert.assertEquals((double)22.0, (double)rpt.getBoard_T(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Quadbox_PDU_5VTelemetry) {
                rpt = (Quadbox_PDU_5VTelemetry)telemetry;
                Assert.assertEquals((double)4.65, (double)rpt.getOtm_3_B_V(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    private static void combineTelemetry(StatusSubsystemData data1, StatusSubsystemData data2) {
        KeyValueDataList kvdl = data1.getEncodedData();
        KeyValueDataList kvdl2 = data2.getEncodedData();
        for (KeyValueData kvd : kvdl2.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
    }

    private static int getNumberOfMatchingClassesForData(GenericConverter converter, StatusSubsystemData d) {
        int count = 0;
        Map classes = converter.getSALClassDescriptionMapForAgent(d.getOriginAgentInfo().getName());
        for (Map.Entry e : classes.entrySet()) {
            SALClassDescription salClassDesc = (SALClassDescription)e.getValue();
            if (!salClassDesc.isCompatibleWithData((Object)d)) continue;
            ++count;
        }
        return count;
    }
}

