/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_CryoConfigurationEvent;

public class ConfigConverterTest {
    @Test
    public void configComCamDaqMonitorCoverterTest2() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-daq-monitor-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-daq-monitor");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraEvent event : converted) {
            Daq_monitor_Store_StoreConfigurationEvent store;
            if (!(event instanceof Daq_monitor_Store_StoreConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Daq_monitor_Store_StoreConfigurationEvent convertedData = store = (Daq_monitor_Store_StoreConfigurationEvent)event;
            Assert.assertEquals((Object)"raw", (Object)convertedData.getDaqFolder());
            Assert.assertEquals((Object)true, (Object)convertedData.isEnableAutoPurge());
            Assert.assertEquals((double)0.7, (double)convertedData.getPurgeTarget(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void auxTelDaqMonitorCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-daq-monitor-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-daq-monitor");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraEvent event : converted) {
            if (!(event instanceof Daq_monitor_Store_StoreConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Daq_monitor_Store_StoreConfigurationEvent convertedData = (Daq_monitor_Store_StoreConfigurationEvent)event;
            Assert.assertEquals((Object)"raw", (Object)convertedData.getDaqFolder());
            Assert.assertEquals((Object)true, (Object)convertedData.isEnableAutoPurge());
            Assert.assertEquals((double)0.7, (double)convertedData.getPurgeTarget(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void auxTelPowerCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-power-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-power");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean foundHameg2 = false;
        boolean foundHameg1 = false;
        for (CameraEvent event : converted) {
            if (event instanceof Ats_power_Hameg2_PowerConfigurationEvent) {
                Assert.assertFalse((boolean)foundHameg2);
                foundHameg2 = true;
                Ats_power_Hameg2_PowerConfigurationEvent convertedData = (Ats_power_Hameg2_PowerConfigurationEvent)event;
                Assert.assertEquals((double)0.75, (double)convertedData.getAnalog_current(), (double)1.0E-5);
                Assert.assertEquals((double)0.4, (double)convertedData.getAnalog_offDelay(), (double)1.0E-5);
                Assert.assertEquals((double)0.1, (double)convertedData.getAnalog_onDelay(), (double)1.0E-5);
                Assert.assertEquals((double)7.2, (double)convertedData.getAnalog_voltage(), (double)1.0E-5);
                continue;
            }
            if (!(event instanceof Ats_power_Hameg1_PowerConfigurationEvent)) continue;
            Assert.assertFalse((boolean)foundHameg1);
            foundHameg1 = true;
            Ats_power_Hameg1_PowerConfigurationEvent convertedData2 = (Ats_power_Hameg1_PowerConfigurationEvent)event;
            Assert.assertEquals((double)0.9, (double)convertedData2.getDigital_current(), (double)1.0E-5);
            Assert.assertEquals((double)0.5, (double)convertedData2.getDigital_offDelay(), (double)1.0E-5);
            Assert.assertEquals((double)0.0, (double)convertedData2.getDigital_onDelay(), (double)1.0E-5);
            Assert.assertEquals((double)5.25, (double)convertedData2.getDigital_voltage(), (double)1.0E-5);
        }
        Assert.assertTrue((boolean)foundHameg1);
        Assert.assertTrue((boolean)foundHameg2);
    }

    @Test
    public void configComCamFocalPlaneCoverterTestLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        Mapping mapping = Mapping.defaultMapping();
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-fp", 0);
        Assert.assertEquals((Object)"placeHolder", (Object)"placeHolder");
    }

    @Test
    public void configComCamFocalPlaneCoverterTestLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-fp-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-fp");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
    }

    @Test
    public void configComCamImageHandlerConverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-ih-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-ih");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraEvent event : converted) {
            if (!(event instanceof Image_handling_ImageHandler_DAQConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Image_handling_ImageHandler_DAQConfigurationEvent daq = (Image_handling_ImageHandler_DAQConfigurationEvent)event;
            Assert.assertEquals((Object)"DAQ:ImageHandling/common(1)|ImageHandling/comcam(1)|ImageHandling/comcam-summit(1)", (Object)daq.getVersion());
            Assert.assertEquals((Object)"comcam", (Object)daq.getImagehandlingconfig_daqPartition());
            Assert.assertEquals((long)4L, (long)daq.getImagehandlingconfig_daqThreads());
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void configComCamFocalPlaneCoverterTestWeird() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-daq-monitor-config-info.ser");
        Assert.assertEquals((Object)"comcam-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-fp");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)0L, (long)converted.size());
        System.out.println(converted);
    }

    @Test
    public void configComCamRebPowerCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-rebpower-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-rebpower");
        List converted = converter.settingsAppliedEventConverter(data);
        this.checkConvertedSalClasses(data.getOriginAgentInfo().getName(), converter, converted);
        System.out.println(converted);
    }

    @Test
    public void configAuxTelFocalPlaneCoverterTestLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-fp-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-fp");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        System.out.println(converted);
    }

    @Test
    public void configAuxTelFocalPlaneConverterVisualizationTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-fp-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-fp");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        System.out.println(converted);
        StatusConfigurationInfo data2 = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-fp-tucson-config-info.ser");
        List converted2 = converter.settingsAppliedEventConverter(data2);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data2), (long)converted.size());
        System.out.println(converted2);
    }

    @Test
    public void configAuxTelImageHandlerConverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-ih-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-ih");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraEvent event : converted) {
            if (!(event instanceof Image_handling_ImageHandler_DAQConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Image_handling_ImageHandler_DAQConfigurationEvent daq = (Image_handling_ImageHandler_DAQConfigurationEvent)event;
            Assert.assertEquals((Object)"DAQ:ImageHandling/common(1)|ImageHandling/ats(1)|ImageHandling/ats-tucson(2)", (Object)daq.getVersion());
            Assert.assertEquals((Object)"lat", (Object)daq.getImagehandlingconfig_daqPartition());
            Assert.assertEquals((long)4L, (long)daq.getImagehandlingconfig_daqThreads());
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void configAuxTelFocalPlaneCoverterTimersTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"auxtel/ats-fp-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("ats-fp");
        List converted = converter.settingsAppliedEventConverter(data);
        Assert.assertEquals((long)this.getSizeOfExpectedSalClasses(converter, data), (long)converted.size());
        boolean found = false;
        for (CameraEvent evt : converted) {
            if (!(evt instanceof Focal_plane_Reb_timersConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Focal_plane_Reb_timersConfigurationEvent timers = (Focal_plane_Reb_timersConfigurationEvent)evt;
            Assert.assertEquals((long)10000L, (long)timers.getPeriodictasks_monitor_check_taskPeriodMillis()[0]);
            Assert.assertEquals((long)1000L, (long)timers.getPeriodictasks_monitor_update_taskPeriodMillis()[0]);
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void configComCamVacuumCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = SerializationUtils.readStatusConfigurationInfoFromFile((String)"comcam/comcam-vacuum-config-info.ser");
        GenericConverter converter = new GenericConverter(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
        converter.addSubsystem("comcam-vacuum");
        List converted = converter.settingsAppliedEventConverter(data);
        boolean found = false;
        for (CameraEvent evt : converted) {
            if (!(evt instanceof Vacuum_VQMonitor_CryoConfigurationEvent)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            System.out.println(evt);
            double[] relayTrip = ((Vacuum_VQMonitor_CryoConfigurationEvent)evt).getRelayTrip();
            Assert.assertEquals((long)2L, (long)relayTrip.length);
        }
        Assert.assertTrue((boolean)found);
    }

    private int getSizeOfExpectedSalClasses(GenericConverter converter, StatusConfigurationInfo data) {
        int size = 0;
        String agentName = data.getOriginAgentInfo().getName();
        ConfigurationInfo ci = data.getConfigurationInfo();
        for (SALClassDescription salClassDesc : converter.getSALClassDescriptionMapForAgent(agentName).values()) {
            String category = salClassDesc.getCategory();
            if (!ci.getCategorySet().contains(category)) continue;
            ++size;
        }
        return size;
    }

    private void checkConvertedSalClasses(String agentName, GenericConverter converter, List<CameraEvent> converted) {
        ArrayList<String> allAvailableEventClasses = new ArrayList<String>();
        int missingClasses = 0;
        int descriptions = 0;
        for (Map.Entry e : converter.getSALClassDescriptionMapForAgent(agentName).entrySet()) {
            ++descriptions;
            if (((SALClassDescription)e.getValue()).getSimpleSalClass() != null) {
                allAvailableEventClasses.add(((SALClassDescription)e.getValue()).getSimpleSalClass().getSimpleName());
                continue;
            }
            ++missingClasses;
        }
        for (CameraEvent evt : converted) {
            Assert.assertTrue((boolean)allAvailableEventClasses.remove(evt.getClass().getSimpleName()));
        }
        Assert.assertTrue((String)((Object)allAvailableEventClasses).toString(), (boolean)allAvailableEventClasses.isEmpty());
        Assert.assertEquals((long)(descriptions - missingClasses), (long)converted.size());
    }
}

