package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

/**
 * An interface to be implemented by all filter changers, real or simulated
 *
 * @author tonyj
 */
public interface FilterChangerInterface {

    /**
     * Get a map of available filters, containing the (unique) name of each filter
     * and the type of each filter
     * @return 
     * @throws java.util.concurrent.ExecutionException 
     */
    Map<String, String> getAvailableFilters() throws ExecutionException;

    /**
     * Get a list of currently installed filters
     * @return 
     * @throws java.util.concurrent.ExecutionException
     */
    List<String> getInstalledFilters() throws ExecutionException;

    /**
     * Start and lock the filter changer, with the specified configuration
     * @param configName 
     * @throws java.util.concurrent.ExecutionException 
     */
    void start(String configName) throws ExecutionException;

    /**
     * Get the currently installed filter name
     * @return The installed filter, or ? if none installed
     * @throws java.util.concurrent.ExecutionException
     */
    String getCurrentFilter() throws ExecutionException;

    /**
     * Set the currently installed filter 
     * @param filterName 
     * @throws java.util.concurrent.ExecutionException  if the command fails
     */
    void setFilter(String filterName) throws ExecutionException;

    /**
     * Get the expected (worse-case) duration to move to new filter
     * @param filterName
     * @return 
     */
    Duration getEstimatedDurationForFilterChange(String filterName);
}
