/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class MainCameraShutterSubsystemLayer
extends ControlledSubsystem
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(MainCameraShutterSubsystemLayer.class.getName());
    private static final Map<Enum<PhysicalState>, Enum<Shutter.ShutterState>> CAMERA_SHUTTER_TO_SHUTTER_STATE = new HashMap<Enum<PhysicalState>, Enum<Shutter.ShutterState>>();
    private volatile CountDownLatch motionDoneCountDown;
    private volatile ImageName currentImageName;
    private final ShutterMotionProfileSender motionProfileSender = new ShutterMotionProfileSender();
    static final String MOTOR_ENCODER_PATH = "shutter/motorEncoder/";
    static final String HALL_SENSOR_PATH = "shutter/hallSensor/";
    static final String MOTION_PROFILE_FIT_RESULT = "/motionProfileFitResult";

    MainCameraShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
    }

    @Override
    public void expose(ImageName imageName, Duration exposeTime) throws ExecutionException {
        try {
            this.motionDoneCountDown = new CountDownLatch(2);
            this.currentImageName = imageName;
            this.commandSender.sendCommand("takeExposure", (double)exposeTime.toMillis() / 1000.0);
            boolean success = this.motionDoneCountDown.await(exposeTime.toMillis() + 2000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new TimeoutException("Timed out waiting for shutter exposure to complete");
            }
        }
        catch (InterruptedException | TimeoutException x) {
            throw new ExecutionException("Error during expose", x);
        }
    }

    @Override
    public void open() throws ExecutionException {
        this.commandSender.sendCommand("openShutter", new Object[0]);
    }

    @Override
    public void close() throws ExecutionException {
        this.commandSender.sendCommand("closeShutter", new Object[0]);
    }

    @Override
    public void prepare() {
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getComponentStateBundle("statemachine").getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateCameraShutterStateToShutterState(when, (Enum)value));
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        if (msg.getObject() instanceof KeyValueData && "MotionDone".equals(((KeyValueData)msg.getObject()).getKey()) && this.motionDoneCountDown != null) {
            LOG.log(Level.INFO, "Got Motion Done {0} ", msg);
            int currentCount = (int)this.motionDoneCountDown.getCount();
            if (currentCount > 0) {
                this.motionDoneCountDown.countDown();
                MotionDone motionDone = (MotionDone)((KeyValueData)msg.getObject()).getValue();
                this.processMotionDone(this.currentImageName, currentCount, motionDone);
            }
        }
    }

    private void translateCameraShutterStateToShutterState(CCSTimeStamp when, Enum value) {
        LOG.log(Level.INFO, "Got shutter state {0} ", value);
        Enum<Shutter.ShutterState> converted = CAMERA_SHUTTER_TO_SHUTTER_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<Enum<Shutter.ShutterState>>(converted));
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
    }

    private void processMotionDone(ImageName imageName, int currentCount, MotionDone motionDone) {
        boolean isOpen = currentCount == 2;
        this.motionProfileSender.processMotionDone(imageName, motionDone, isOpen);
        JsonFile jsonProfile = this.motionProfileSender.getJsonFile();
        this.sendEvent("additionalFile", (Serializable)jsonProfile);
        ShutterMotionProfileFitResult encoderFitResult = this.motionProfileSender.getEncoderFitResult();
        String encoderPath = MOTOR_ENCODER_PATH + motionDone.side().toString() + "/" + (isOpen ? "open" : "close") + MOTION_PROFILE_FIT_RESULT;
        this.sendEvent(encoderPath, (Serializable)encoderFitResult);
        ShutterMotionProfileFitResult hallSensorFitResult = this.motionProfileSender.getHallSensorFitResult();
        String hallSensorPath = HALL_SENSOR_PATH + motionDone.side().toString() + "/" + (isOpen ? "open" : "close") + MOTION_PROFILE_FIT_RESULT;
        this.sendEvent(hallSensorPath, (Serializable)hallSensorFitResult);
    }

    static {
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.OPENED, Shutter.ShutterState.OPEN);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.OPENING, Shutter.ShutterState.OPENING);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.CLOSED, Shutter.ShutterState.CLOSED);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.CLOSING, Shutter.ShutterState.CLOSING);
    }
}

