/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericGenericConverterTest {
    private final Random r = new Random();

    /*
     * WARNING - void declaration
     */
    @Test
    public void TelemetryConversionTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        for (Camera camera : Camera.values()) {
            XMLMaker2.SALType salType = XMLMaker2.SALType.TELEMETRY;
            MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)camera, (XMLMaker2.SALType)salType);
            GenericConverter converter = new GenericConverter(camera, salType);
            ArrayList<String> skippedData = new ArrayList<String>();
            for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : xmlMaker.getOrderedListOfDictionaryConfigurations()) {
                boolean bl;
                HashMap<String, Map> dataMap = new HashMap<String, Map>();
                HashMap<String, String> categoryVersionMap = new HashMap<String, String>();
                String agentName = dictConfig.getAgentName();
                System.out.println("\n***** Agent: " + agentName + " (" + camera + ")");
                converter.addSubsystem(agentName);
                DataProviderDictionary dict = dictConfig.getDictionary();
                for (DataProviderInfo dataProviderInfo : dict.getDataProviderInfos()) {
                    String dataType = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                    String category = null;
                    String lowerCaseVarName = dataProviderInfo.getFullPath().toLowerCase();
                    if (lowerCaseVarName.contains("rebstate") || lowerCaseVarName.contains("tripstate")) continue;
                    if (salType == XMLMaker2.SALType.TELEMETRY) {
                        if (dataType.equals(DataProviderInfo.Type.TRENDING.name())) {
                            category = "Trending";
                        } else if (dataType.equals(DataProviderInfo.Type.MONITORING.name())) {
                            category = "";
                        }
                    } else if (salType == XMLMaker2.SALType.SETTINGS_APPLIED) {
                        category = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
                    }
                    if (category == null) continue;
                    Map catDataMap = dataMap.computeIfAbsent(category, c -> new HashMap());
                    if (!this.addRandomData(catDataMap, dataProviderInfo)) {
                        skippedData.add(dataProviderInfo.getFullPath());
                    }
                    categoryVersionMap.put(category, "1.0");
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    System.out.println("  Total number of generated data for category " + (String)entry.getKey() + ": " + ((Map)entry.getValue()).size());
                }
                ArrayList<CameraTelemetry> converted = new ArrayList<CameraTelemetry>();
                if (salType == XMLMaker2.SALType.TELEMETRY) {
                    for (CameraTelemetry tel : converter.telemetryConverter(agentName, dataMap)) {
                        converted.add(tel);
                    }
                } else {
                    for (CameraTelemetry tel : converter.settingsAppliedEventConverter(agentName, dataMap, categoryVersionMap)) {
                        converted.add(tel);
                    }
                }
                boolean bl2 = true;
                if (!skippedData.isEmpty()) {
                    System.out.println("The paths were not generated: " + skippedData);
                    boolean bl3 = false;
                }
                StringBuilder missingSALClasses = new StringBuilder();
                Map salClassesMap = converter.getSALClassDescriptionMapForAgent(agentName);
                HashMap<Class, SALClassDescription> classToSalClassDescriptionMap = new HashMap<Class, SALClassDescription>();
                for (Map.Entry entry : salClassesMap.entrySet()) {
                    SALClassDescription salClassDesc = (SALClassDescription)entry.getValue();
                    Class c2 = salClassDesc.getSimpleSalClass();
                    if (c2 != null) {
                        classToSalClassDescriptionMap.put(c2, salClassDesc);
                        continue;
                    }
                    String string = salClassDesc.getCategory();
                    int dataCount = 0;
                    for (SALClassDescription.SALVariable salVar : salClassDesc.getVariables()) {
                        if (salVar instanceof SALClassDescription.SimpleSALVariable) {
                            Object path = ((SALClassDescription.SimpleSALVariable)salVar).getBusVariable().getPathAndNameOnBuses();
                            if (((String)path).startsWith("/")) {
                                path = ((String)path).substring(1);
                            }
                            if (skippedData.contains(path)) continue;
                            Assert.assertNotNull((String)path, ((Map)dataMap.get(string)).remove(path));
                            ++dataCount;
                            continue;
                        }
                        if (!(salVar instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
                        for (SALClassDescription.BusVariable var : ((SALClassDescription.PatternMatchedSALVariable)salVar).getBusVariables()) {
                            String path = var.getPathAndNameOnBuses();
                            if (skippedData.contains(path)) continue;
                            Assert.assertNotNull((String)path, ((Map)dataMap.get(string)).remove(path));
                            ++dataCount;
                        }
                    }
                    if (missingSALClasses.toString().isEmpty()) {
                        missingSALClasses.append("  Missing SAL classes:\n");
                    }
                    missingSALClasses.append("\t").append((String)entry.getKey()).append(" with ").append(dataCount).append(" data\n");
                }
                if (!missingSALClasses.toString().isEmpty()) {
                    boolean bl4 = false;
                    System.out.println(missingSALClasses.toString());
                }
                ArrayList<String> categoriesWithProblems = new ArrayList<String>();
                boolean bl5 = false;
                int numberOfVars = 0;
                for (Object e : converted) {
                    SALClassDescription.BusVariable var;
                    boolean allWellForConvertedClass = true;
                    Class<?> cls = e.getClass();
                    SALClassDescription salClassDesc = (SALClassDescription)classToSalClassDescriptionMap.get(cls);
                    HashMap<Method[], SALClassDescription.SALVariable> salVariablesMap = new HashMap<Method[], SALClassDescription.SALVariable>();
                    var = salClassDesc.getVariables().iterator();
                    while (var.hasNext()) {
                        SALClassDescription.SALVariable salVar = (SALClassDescription.SALVariable)var.next();
                        Method[] lowerCaseVarName = salVar.getVariableName().toLowerCase();
                        if (lowerCaseVarName.contains("rebstate") || lowerCaseVarName.contains("tripstate")) continue;
                        salVariablesMap.put(lowerCaseVarName, salVar);
                    }
                    String category = salClassDesc.getCategory();
                    StringBuilder unknownVariables = new StringBuilder();
                    for (Method m : cls.getMethods()) {
                        String methodName = m.getName();
                        boolean isValidMethod = false;
                        String variableName = null;
                        if (methodName.startsWith("get") && !methodName.equals("getClass")) {
                            variableName = methodName.substring(3);
                            isValidMethod = true;
                        } else if (methodName.startsWith("is") && m.getReturnType().isAssignableFrom(Boolean.TYPE)) {
                            variableName = methodName.substring(2);
                            isValidMethod = true;
                        }
                        if (!isValidMethod) continue;
                        ++numberOfVars;
                        if (variableName.equals("Version")) continue;
                        String lowerCaseVariableName = variableName.toLowerCase();
                        Object convertedData = m.invoke(e, new Object[0]);
                        SALClassDescription.SALVariable variable = (SALClassDescription.SALVariable)salVariablesMap.remove(lowerCaseVariableName);
                        if (convertedData.equals(Double.NaN)) {
                            System.out.println("NAN for " + variableName + " " + category + " " + variable);
                        }
                        if (variable != null) {
                            void var21_31;
                            if (variable instanceof SALClassDescription.SimpleSALVariable) {
                                String pathName = ((SALClassDescription.SimpleSALVariable)variable).getBusVariable().getPathAndNameOnBuses();
                                if (skippedData.contains(pathName)) continue;
                                ++var21_31;
                                Object randomData = ((Map)dataMap.get(category)).remove(pathName);
                                Assert.assertNotNull((String)pathName, randomData);
                                Assert.assertEquals((String)("Comparing data for " + variable + " " + convertedData + " " + randomData), (Object)convertedData, randomData);
                                continue;
                            }
                            if (!(variable instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
                            int index = 0;
                            if (m.getReturnType().isArray()) {
                                Assert.assertEquals((String)("Array size comparison for " + ((SALClassDescription.PatternMatchedSALVariable)variable).getPatternName()), (long)Array.getLength(convertedData), (long)variable.getCount());
                                for (SALClassDescription.BusVariable var2 : ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables()) {
                                    Object convertedDataArrayElement = Array.get(convertedData, index);
                                    String pathName = var2.getPathAndNameOnBuses();
                                    ++var21_31;
                                    Object randomData = ((Map)dataMap.get(category)).remove(pathName);
                                    Assert.assertNotNull((String)("Not null: " + pathName + "[" + index + "] out of " + ((SALClassDescription.PatternMatchedSALVariable)variable).getBusVariables().size()), randomData);
                                    Assert.assertEquals((String)("Comparing data element (" + index + ") for " + variableName), (Object)convertedDataArrayElement, randomData);
                                    ++index;
                                }
                                Assert.assertEquals((String)"Number of checked data", (long)index, (long)variable.getCount());
                                continue;
                            }
                            categoriesWithProblems.add(category);
                            System.out.println("Why isn't this an array????");
                            System.out.println("Category " + category);
                            System.out.println("Method name: " + m);
                            System.out.println(variable);
                            System.out.println("***** NOT ARRAY: " + convertedData);
                            continue;
                        }
                        allWellForConvertedClass = false;
                        unknownVariables.append("\t").append(variableName).append("\n");
                    }
                    StringBuilder notConvertedVAriablesSb = new StringBuilder();
                    if (!salVariablesMap.isEmpty()) {
                        for (SALClassDescription.SALVariable leftoverVar : salVariablesMap.values()) {
                            if (leftoverVar instanceof SALClassDescription.LocationVariable) continue;
                            if (leftoverVar instanceof SALClassDescription.SimpleSALVariable) {
                                String path = ((SALClassDescription.SimpleSALVariable)leftoverVar).getBusVariable().getPathAndNameOnBuses();
                                Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                            } else if (leftoverVar instanceof SALClassDescription.PatternMatchedSALVariable) {
                                for (SALClassDescription.BusVariable var3 : ((SALClassDescription.PatternMatchedSALVariable)leftoverVar).getBusVariables()) {
                                    String path = var3.getPathAndNameOnBuses();
                                    if (skippedData.contains(path)) continue;
                                    Assert.assertNotNull((String)path, ((Map)dataMap.get(category)).remove(path));
                                }
                            }
                            allWellForConvertedClass = false;
                            notConvertedVAriablesSb.append("\t").append(leftoverVar.getVariableName()).append(" data size: ").append(leftoverVar.getCount()).append(" ").append(leftoverVar.getType()).append("\n");
                        }
                    }
                    if (!allWellForConvertedClass) {
                        boolean bl6 = false;
                        System.out.println("  Problems for converted class " + cls);
                    }
                    if (!unknownVariables.toString().isEmpty()) {
                        System.out.println("    Class fields no longer in the dictionary: \n" + unknownVariables.toString());
                    }
                    if (notConvertedVAriablesSb.toString().isEmpty()) continue;
                    System.out.println("    SALClassDescription variables not converted: \n" + notConvertedVAriablesSb.toString());
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    if (categoriesWithProblems.contains(entry.getKey())) {
                        System.out.println("Problem with category: " + (String)entry.getKey());
                        System.out.println("Could not find a match for " + entry.getValue());
                        continue;
                    }
                    if (!agentName.equals("fcs")) {
                        Assert.assertTrue((String)((String)entry.getKey() + " " + ((Map)entry.getValue()).toString()), (boolean)((Map)entry.getValue()).isEmpty());
                        continue;
                    }
                    if (((Map)entry.getValue()).isEmpty()) continue;
                    System.out.println("Uncoverted data: " + entry.getValue());
                    bl = false;
                }
                if (!bl) continue;
                System.out.println("  Data generation and conversion OK\n");
            }
        }
    }

    private boolean addRandomData(Map<String, Object> dataMap, DataProviderInfo dataInfo) {
        String type = dataInfo.getAttributeValue(DataProviderInfo.Attribute.TYPE);
        String path = dataInfo.getFullPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (SALClassDescriptionMaker.exludePath((String)path)) {
            return true;
        }
        String length = dataInfo.getAttributeValue(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH);
        if (type == null) {
            throw new RuntimeException("Type is not defined for " + path);
        }
        switch (type) {
            case "double": 
            case "java.lang.Double": {
                dataMap.put(path, this.r.nextDouble());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                dataMap.put(path, Float.valueOf(this.r.nextFloat()));
                break;
            }
            case "long": 
            case "java.lang.Long": {
                dataMap.put(path, this.r.nextLong());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                dataMap.put(path, this.r.nextInt());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                dataMap.put(path, (short)this.r.nextInt(10));
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                dataMap.put(path, this.r.nextInt(10) > 5);
                break;
            }
            case "java.lang.String": {
                dataMap.put(path, String.valueOf(this.r.nextDouble()));
                break;
            }
            default: {
                if (type.endsWith("[]")) {
                    if (length == null) {
                        throw new RuntimeException("Don't know how to deal with arrays for path " + path);
                    }
                    System.out.println("Create array for " + path + " " + type + " " + length);
                    return false;
                }
                try {
                    Class<?> c = Class.forName(type);
                    if (c.isEnum()) {
                        ?[] values = c.getEnumConstants();
                        int index = this.r.nextInt(values.length);
                        String s = values[index].toString();
                        dataMap.put(path, s);
                        return true;
                    }
                    System.out.println("Don't know how to generate class for path: " + path + " " + c);
                    return false;
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("What should we do for " + path + " of type: " + type);
                    return false;
                }
            }
        }
        return true;
    }
}

