/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.lsst.ccs.subsystem.ocsbridge.ConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.OCSEventSender;

public class ConfigurationSenderTest {
    @Test
    public void auxTelConfigurationTest() throws IOException, ClassNotFoundException, InterruptedException {
        ArrayList<String> found = new ArrayList<String>();
        OCSEventSender ocs = t -> found.add(t.getClass().getSimpleName());
        ConfigurationSender sender = ConfigurationSender.create((Camera)Camera.AUXTEL, (OCSEventSender)ocs);
        sender.getConverter().addSubsystem("ats-fp");
        sender.getConverter().addSubsystem("ats-daq-monitor");
        sender.getConverter().addSubsystem("ats-ih");
        sender.getConverter().addSubsystem("bonn-shutter");
        sender.getConverter().addSubsystem("ats-power");
        sender.getConverter().addSubsystem("ats");
        Set<String> expectedEvents = Arrays.stream(sender.getConfigurationEvents().split(",")).collect(Collectors.toSet());
        this.checkResults(expectedEvents, sender, found, "focal_plane", "auxtel/ats-fp-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "daq_monitor", "auxtel/ats-daq-monitor-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "image_handling", "auxtel/ats-ih-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "bonn_shutter", "auxtel/bonn-shutter-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "ats_power", "auxtel/ats-power-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "ats", "auxtel/ats-config-info.ser");
    }

    @Test
    public void comCamConfigurationTest() throws IOException, ClassNotFoundException, InterruptedException {
        ArrayList<String> found = new ArrayList<String>();
        OCSEventSender ocs = t -> found.add(t.getClass().getSimpleName());
        ConfigurationSender sender = ConfigurationSender.create((Camera)Camera.COMCAM, (OCSEventSender)ocs);
        sender.getConverter().addSubsystem("comcam-fp");
        sender.getConverter().addSubsystem("comcam-daq-monitor");
        sender.getConverter().addSubsystem("comcam-ih");
        sender.getConverter().addSubsystem("bonn-shutter");
        sender.getConverter().addSubsystem("comcam-quadbox");
        sender.getConverter().addSubsystem("comcam-vacuum");
        sender.getConverter().addSubsystem("comcam-fcs");
        sender.getConverter().addSubsystem("comcam-rebpower");
        Set<String> expectedEvents = Arrays.stream(sender.getConfigurationEvents().split(",")).collect(Collectors.toSet());
        this.checkResults(expectedEvents, sender, found, "focal_plane", "comcam/comcam-fp-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "daq_monitor", "comcam/comcam-daq-monitor-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "image_handling", "comcam/comcam-ih-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "bonn_shutter", "comcam/comcam-bonn-shutter-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "quadbox", "comcam/comcam-quadbox-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "vacuum", "comcam/comcam-vacuum-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "rebpower", "comcam/comcam-rebpower-config-info.ser");
        this.checkResults(expectedEvents, sender, found, "fcs", "comcam/comcam-fcs-config-info.ser");
    }

    private void checkResults(Set<String> expectedEvents, ConfigurationSender sender, ArrayList<String> found, String filter, String file) throws ClassNotFoundException, IOException {
        Set expected = expectedEvents.stream().filter(s -> s.startsWith(filter)).collect(Collectors.toSet());
        Set expectedClassNames = expected.stream().map(s -> SALClassDescriptionMaker.capitalize((String)s) + "Event").collect(Collectors.toSet());
        found.clear();
        StatusConfigurationInfo sci = SerializationUtils.readStatusConfigurationInfoFromFile((String)file);
        sender.send(sci);
        for (String foundClass : found) {
            boolean removed = expectedClassNames.remove(foundClass);
            Assert.assertTrue((String)(foundClass + " not expected"), (boolean)removed);
        }
        expectedClassNames.remove("Vacuum_VQMonitor_CryoConfigurationEvent");
        Iterator leftovers = expectedClassNames.iterator();
        while (leftovers.hasNext()) {
            String leftoverClassName = (String)leftovers.next();
            String leftoverCategory = leftoverClassName.substring(leftoverClassName.lastIndexOf("_") + 1).replace("ConfigurationEvent", "");
            Assert.assertTrue((boolean)this.isCategorySupportedForAgent(sender, sci.getOriginAgentInfo().getName(), leftoverCategory));
            if (sci.getConfigurationInfo().getCategorySet().contains(leftoverCategory)) continue;
            leftovers.remove();
        }
        Assert.assertTrue((String)("Not found " + expectedClassNames), (boolean)expectedClassNames.isEmpty());
        expectedEvents.removeAll(expected);
    }

    @Test
    public void auxTelConfigurationClassListTest() {
        ConfigurationSender sender = ConfigurationSender.create((Camera)Camera.AUXTEL, null);
        sender.getConverter().addSubsystem("ats-daq-monitor");
        String eventList = sender.getConfigurationEvents();
        System.out.println(eventList);
        String[] names = eventList.split(",");
        Assert.assertTrue((boolean)Arrays.asList(names).contains("daq_monitor_Store_StoreConfiguration"));
    }

    private boolean isCategorySupportedForAgent(ConfigurationSender sender, String agentName, String category) {
        for (SALClassDescription salDesc : sender.getConverter().getSALClassDescriptionMapForAgent(agentName).values()) {
            if (!salDesc.getCategory().equals(category)) continue;
            return true;
        }
        return false;
    }
}

