/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.bonnshutter.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class BonnShutterSubsystemLayer
extends ControlledSubsystem
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(BonnShutterSubsystemLayer.class.getName());
    private static final Map<Enum<ShutterState>, Enum<Shutter.ShutterState>> BONNSHUTTER_TO_SHUTTER_STATE = new HashMap<Enum<ShutterState>, Enum<Shutter.ShutterState>>();

    BonnShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
    }

    @Override
    public void expose(ImageName imageName, Duration exposeTime) throws ExecutionException {
        this.commandSender.sendCommand("takeExposure", (double)exposeTime.toMillis() / 1000.0);
        this.commandSender.sendCommand("waitForExposure", new Object[0]);
    }

    @Override
    public void open() throws ExecutionException {
        this.commandSender.sendCommand("openShutter", new Object[0]);
    }

    @Override
    public void close() throws ExecutionException {
        this.commandSender.sendCommand("closeShutter", new Object[0]);
    }

    @Override
    public void prepare() {
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateBonnShutterStateToShutterState(when, (Enum)value));
    }

    private void translateBonnShutterStateToShutterState(CCSTimeStamp when, Enum value) {
        LOG.log(Level.INFO, "Got bonn-shutter state {0} ", value);
        Enum<Shutter.ShutterState> converted = BONNSHUTTER_TO_SHUTTER_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<Enum<Shutter.ShutterState>>(converted));
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
    }

    static {
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<ShutterState>)ShutterState.OPEN, Shutter.ShutterState.OPEN);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<ShutterState>)ShutterState.OPENING, Shutter.ShutterState.OPENING);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<ShutterState>)ShutterState.CLOSED, Shutter.ShutterState.CLOSED);
        BONNSHUTTER_TO_SHUTTER_STATE.put((Enum<ShutterState>)ShutterState.CLOSING, Shutter.ShutterState.CLOSING);
    }
}

