/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.xml.MakeXMLConfiguration;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MakeAllXML {
    public static void main(String[] args) throws Exception {
        File outputLocation = new File("/home/tonyj/projects/lsst/ocs-ccs/ts_xml/python/lsst/ts/xml/data/sal_interfaces");
        MakeAllXML.makeAllComCamXML(new File(outputLocation, "CCCamera/"));
        MakeAllXML.makeAllMainCameraXML(new File(outputLocation, "MTCamera/"));
        MakeAllXML.makeAllAuxTelXML(new File(outputLocation, "ATCamera/"));
    }

    private static void makeAllAuxTelXML(File outputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.AUXTEL);
    }

    private static void makeAllComCamXML(File outputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.COMCAM);
    }

    private static void makeAllMainCameraXML(File outputLocation) throws IOException, ParserConfigurationException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.MAIN_CAMERA);
    }

    private static void makeAllXML(File outputLocation, Camera camera) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        XMLMaker2 maker = new XMLMaker2(false);
        outputLocation.mkdirs();
        MakeAllXML.makeAllXMLForConfiguration(outputLocation, MakeXMLConfiguration.getInstance(camera, XMLMaker2.SALType.TELEMETRY), maker);
        MakeAllXML.makeAllXMLForConfiguration(outputLocation, MakeXMLConfiguration.getInstance(camera, XMLMaker2.SALType.SETTINGS_APPLIED), maker);
    }

    private static void makeAllXMLForConfiguration(File outputLocation, MakeXMLConfiguration config, XMLMaker2 maker) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException {
        File outputFileName = new File(outputLocation, config.getXMLFileName());
        Document document = maker.createXML(config);
        if (config.getSALType() == XMLMaker2.SALType.SETTINGS_APPLIED) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(outputFileName);
            XMLUtils xmlUtils = new XMLUtils();
            xmlUtils.replacePartOfDocument(doc, document, "CONFIGURATION", "ENDCONFIGURATION");
            document = doc;
        }
        maker.writeXML(new StreamResult(outputFileName), document);
        System.out.println("Wrote " + outputFileName);
    }
}

