/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.xml.MakeXMLConfiguration;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMaker2Test {
    @Test
    public void makeXMLFromMainCameraRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = xmlMaker.getDictionaryConfigurationForAgent("rebpower");
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, dictConfig, 0);
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)1L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)dictConfig.getCSCName(), (Object)subsystemElement.getTextContent());
        this.checkXML(302420335L, maker, dom);
    }

    @Test
    public void makeXMLFromMainCameraRebPowerLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = xmlMaker.getDictionaryConfigurationForAgent("rebpower");
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, dictConfig);
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)2L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)dictConfig.getCSCName(), (Object)subsystemElement.getTextContent());
        this.checkXML(18689785L, maker, dom);
    }

    @Test
    public void makeXMLFromComcamDaqMonitorLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)Camera.COMCAM, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = xmlMaker.getDictionaryConfigurationForAgent("comcam-daq-monitor");
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, dictConfig);
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)3L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"CCCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(3465668806L, maker, dom);
    }

    @Test
    public void makeXMLFromComcamDaqMonitorSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        MakeXMLConfiguration xmlMaker = MakeXMLConfiguration.getInstance((Camera)Camera.COMCAM, (XMLMaker2.SALType)XMLMaker2.SALType.SETTINGS_APPLIED);
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = xmlMaker.getDictionaryConfigurationForAgent("comcam-daq-monitor");
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, dictConfig, 0);
        NodeList telemetryElements = dom.getElementsByTagName("SALEvent");
        Assert.assertEquals((long)6L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"CCCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(1319779459L, maker, dom);
    }

    private void checkXML(long result, XMLMaker2 maker, Document dom) throws TransformerException {
        CRC32 checkSum = new CRC32();
        StreamResult output = new StreamResult(new CheckedOutputStream(new NullOutputStream(), checkSum));
        maker.writeXML(output, dom);
        Assert.assertEquals((long)result, (long)checkSum.getValue());
    }

    private Document makeXMLFromStatusDataProviderDictionary(XMLMaker2 maker, MakeXMLConfiguration.DictionaryConfiguration dictConfig) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        return this.makeXMLFromStatusDataProviderDictionary(maker, dictConfig, dictConfig.getLevel());
    }

    private Document makeXMLFromStatusDataProviderDictionary(XMLMaker2 maker, MakeXMLConfiguration.DictionaryConfiguration dictConfig, int level) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        Document doc = maker.makeXMLFromDictionary(dictConfig, mapping, level);
        return doc;
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

