/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class MCMTest {
    private MCM mcm;
    private CCS ccs;

    @Before
    public void setup() throws Exception {
        MCMConfig mcmConfig = MCMConfig.createDefaultConfig();
        Camera camera = mcmConfig.getCameraType();
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)(camera == Camera.AUXTEL ? Source.AuxTel : Source.MainCamera), (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        this.ccs = new CCS();
        this.mcm = new MCM(this.ccs, mcmConfig, ins);
        CCSCommand.CCSStartCommand start = new CCSCommand.CCSStartCommand("Normal");
        this.executeAndHandleResponse((CCSCommand)start);
    }

    private <T> T executeAndHandleResponse(CCSCommand command, Class<T> responseType) throws Exception {
        CCSCommand.CCSCommandResponse startResponse = this.mcm.execute(command);
        CCSCommand.CCSAckOrNack ackOrNack = startResponse.waitForAckOrNack();
        Assert.assertFalse((String)ackOrNack.getReason(), (boolean)ackOrNack.isNack());
        return (T)startResponse.waitForCompletion();
    }

    private void executeAndHandleResponse(CCSCommand command) throws Exception {
        this.executeAndHandleResponse(command, Void.TYPE);
    }

    @Test
    public void testAllocateImageName() throws Exception {
        CCSCommand.CCSAllocateImageNameCommand ccsAllocateImageNameCommand = new CCSCommand.CCSAllocateImageNameCommand();
        ImageName imageName = this.executeAndHandleResponse((CCSCommand)ccsAllocateImageNameCommand, ImageName.class);
        Assert.assertTrue((boolean)imageName.toString().startsWith("MC_O_20211231_000"));
    }

    @Test
    public void testTakeImage() throws Exception {
        ImageName imageName = new ImageName("MC_O_20211231_000011");
        CCSCommand.CCSTakeImageCommand takeImageCommand = new CCSCommand.CCSTakeImageCommand(imageName, true, 2.0, 1, "test", Collections.emptySet(), Collections.emptyMap());
        this.executeAndHandleResponse((CCSCommand)takeImageCommand);
        CCSCommand.CCSWaitForImageCommand waitForImageCommand = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse((CCSCommand)waitForImageCommand);
        Assert.assertTrue((boolean)this.mcm.getCCS().getAggregateStatus().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
    }

    @Test
    public void testTakeImageNoShutter() throws Exception {
        ImageName imageName = new ImageName("MC_O_20211231_000010");
        CCSCommand.CCSTakeImageCommand takeImageCommand = new CCSCommand.CCSTakeImageCommand(imageName, false, 2.0, 1, "test", Collections.emptySet(), Collections.emptyMap());
        this.executeAndHandleResponse((CCSCommand)takeImageCommand);
        CCSCommand.CCSWaitForImageCommand waitForImageCommand = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse((CCSCommand)waitForImageCommand);
        Assert.assertTrue((boolean)this.mcm.getCCS().getAggregateStatus().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
    }

    @Test
    public void testTakeImageWithGuider() throws Exception {
        String roiSpec = "Bananas";
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSInitGuidersCommand(roiSpec));
        ImageName imageName = new ImageName("MC_O_20211231_000011");
        CCSCommand.CCSTakeImageCommand takeImageCommand = new CCSCommand.CCSTakeImageCommand(imageName, true, 2.0, 1, "test", Collections.emptySet(), Collections.emptyMap());
        this.executeAndHandleResponse((CCSCommand)takeImageCommand);
        CCSCommand.CCSWaitForImageCommand waitForImageCommand = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse((CCSCommand)waitForImageCommand);
        Assert.assertTrue((boolean)this.mcm.getCCS().getAggregateStatus().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
    }

    @Test
    public void testIntegration() throws Exception {
        ImageName imageName = new ImageName("MC_O_20211231_000001");
        CCSCommand.CCSClearAndStartNamedIntegrationCommand startCommand = new CCSCommand.CCSClearAndStartNamedIntegrationCommand(imageName, true, 1, "test", Collections.emptySet(), Collections.emptyMap());
        this.executeAndHandleResponse((CCSCommand)startCommand);
        Thread.sleep(2000L);
        CCSCommand.CCSEndIntegrationCommand endImageCommand = new CCSCommand.CCSEndIntegrationCommand();
        this.executeAndHandleResponse((CCSCommand)endImageCommand);
        CCSCommand.CCSWaitForImageCommand waitForImageCommand = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse((CCSCommand)waitForImageCommand);
        Assert.assertTrue((boolean)this.mcm.getCCS().getAggregateStatus().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
    }

    @Test
    public void testIntegrationNoShutter() throws Exception {
        ImageName imageName = new ImageName("MC_O_20211231_000001");
        CCSCommand.CCSClearAndStartNamedIntegrationCommand startCommand = new CCSCommand.CCSClearAndStartNamedIntegrationCommand(imageName, false, 1, "test", Collections.emptySet(), Collections.emptyMap());
        this.executeAndHandleResponse((CCSCommand)startCommand);
        Thread.sleep(2000L);
        CCSCommand.CCSEndIntegrationCommand endImageCommand = new CCSCommand.CCSEndIntegrationCommand();
        this.executeAndHandleResponse((CCSCommand)endImageCommand);
        CCSCommand.CCSWaitForImageCommand waitForImageCommand = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse((CCSCommand)waitForImageCommand);
        Assert.assertTrue((boolean)this.mcm.getCCS().getAggregateStatus().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
    }

    @Test
    public void testTakeImages() throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(2.0, 2, true, "", "groupId: test, imageType: test", "Test");
        this.executeAndHandleResponse((CCSCommand)takeImages);
    }

    @Test
    public void testTakeImagesNoShutter() throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(2.0, 2, false, "", "groupId: test, imageType: test", "Test");
        this.executeAndHandleResponse((CCSCommand)takeImages);
    }

    @Test
    public void testCalibrationMode() throws Exception {
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSEnableCalibrationCommand());
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSStartImageCommand(true, "", "groupId: test, imageType: test", "Test", 60.0));
        Thread.sleep(1000L);
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSDiscardRowsCommand(10));
        Thread.sleep(1000L);
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSEndImageCommand());
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSDisableCalibrationCommand());
    }

    @Test
    public void testCalibrationModeNoShutter() throws Exception {
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSEnableCalibrationCommand());
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSStartImageCommand(false, "", "groupId: test, imageType: test", "Test", 60.0));
        Thread.sleep(1000L);
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSDiscardRowsCommand(10));
        Thread.sleep(1000L);
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSEndImageCommand());
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSDisableCalibrationCommand());
    }

    @Test
    public void openCloseShutter() throws Exception {
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSOpenShutterCommand());
        Assert.assertTrue((boolean)this.ccs.getAggregateStatus().hasState(new Enum[]{Shutter.ShutterState.OPEN}));
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSOpenShutterCommand());
        Assert.assertTrue((boolean)this.ccs.getAggregateStatus().hasState(new Enum[]{Shutter.ShutterState.OPEN}));
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSCloseShutterCommand());
        Assert.assertTrue((boolean)this.ccs.getAggregateStatus().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
    }

    @Test
    public void testSetHeaderKeywords() throws Exception {
        this.executeAndHandleResponse((CCSCommand)new CCSCommand.CCSSetHeaderKeywordsCommand(Collections.singletonMap("key", "value")));
    }
}

