package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.cccamera.CCCamera;

/**
 *
 * @author Farrukh Azfar. Configuration class to hold parameters for Camera,
 * AUXTel, ComCam -
 */
@SuppressWarnings("FieldMayBeFinal")
public class OCSBridgeConfig {

    @ConfigurationParameter
    private volatile Camera device = Camera.MAIN_CAMERA;
    
    @ConfigurationParameter
    private final boolean hasFilterChanger = true;
    
    @ConfigurationParameter
    private volatile String mcmName = "mcm";
    
    @ConfigurationParameter(description = "Userid to be used to MCM subsystem", isFinal = true)
    private volatile String userId = "ocs";
        
    /**
     * Subsystems we should listen to for events
     */
    @ConfigurationParameter(maxLength = 50)
    @SuppressWarnings("VolatileArrayField")
      private volatile String[] listenSubsystems = new String[0];

  public boolean hasFilterChanger() {
        return hasFilterChanger;
    }

    public String getMCMName() {
        return mcmName;
    }

    public Camera getDevice() {
        return device;
    }

    public String[] getListenSubsystems() {
        return listenSubsystems;
    }

    String getUserID() {
        return userId;
    }
    
    SAL<CameraCommand, CameraEvent, CameraTelemetry> getSALManager() {
        return createSALManager(device);
    }

    static SAL<CameraCommand, CameraEvent, CameraTelemetry> createSALManager(Camera device) {
        switch (device) {
            case MAIN_CAMERA:
                return SALCamera.create();
            case AUXTEL:
                return ATCamera.create();
            case COMCAM:
                return CCCamera.create();
            default:
                throw new UnsupportedOperationException("Device not yet supported: " + device);
        }
    }
    
    String getCSCRoot() {
        switch (device) {
            case MAIN_CAMERA:
                return "MTCamera";
            case AUXTEL:
                return "ATCamera";
            case COMCAM:
                return "CCCamera";
            default:
                throw new UnsupportedOperationException("Device not yet supported: " + device);
        }
    }
    
    SAL<SALCommand, SALEvent, SALTelemetry> getHeaderServiceManager() {
        switch (device) {
            case MAIN_CAMERA:
                return null;
            case AUXTEL:
                return org.lsst.sal.atheader.SALMain.create();
            case COMCAM:
                return org.lsst.sal.ccheader.SALMain.create();
            default:
                throw new UnsupportedOperationException("Device not yet supported: " + device);
        }
    }

    static OCSBridgeConfig createDefaultConfig() {
        OCSBridgeConfig config = new OCSBridgeConfig();
        return config;
    }

}
