/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;

public class SummaryInfoConverter {
    private static final Pattern SENSOR_PATTERN = Pattern.compile("(R..)/(Reb.)/(S..)/(\\w+)");
    private static final Pattern REB_PATTERN = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(\\w+)");
    private static final Pattern RAFT_PATTERN = Pattern.compile("(R..)/(.+)");
    private static final DelimitedStringSplitJoin DELIMITED_STRING_SPLIT_JOIN = new DelimitedStringSplitJoin();
    private final Camera device;

    public SummaryInfoConverter(Camera device) {
        this.device = device;
    }

    public CameraEvent convert(ConfigurationInfo data) {
        TreeSet ccdLocations = new TreeSet();
        HashMap ccdNames = new HashMap();
        HashMap manSerNums = new HashMap();
        HashMap rebNames = new HashMap();
        HashMap rebSerialNums = new HashMap();
        HashMap raftNames = new HashMap();
        HashMap ccdNameToRebName = new HashMap();
        HashMap setTemp = new HashMap();
        HashMap seqMap = new HashMap();
        HashMap seqChecksumMap = new HashMap();
        Map hardwareMap = data.getCurrentValuesForCategory("HardwareId");
        hardwareMap.forEach((key, value) -> {
            Matcher sensorMatcher = SENSOR_PATTERN.matcher((CharSequence)key);
            Matcher rebMatcher = REB_PATTERN.matcher((CharSequence)key);
            Matcher raftMatcher = RAFT_PATTERN.matcher((CharSequence)key);
            if (sensorMatcher.matches()) {
                String ccdName = sensorMatcher.group(1) + sensorMatcher.group(3);
                String rebName = sensorMatcher.group(1) + sensorMatcher.group(2);
                ccdLocations.add(ccdName);
                ccdNameToRebName.put(ccdName, rebName);
                String type = sensorMatcher.group(4);
                if ("name".equals(type)) {
                    ccdNames.put(ccdName, value);
                } else if ("manSerNum".equals(type)) {
                    manSerNums.put(ccdName, value);
                }
            } else if (rebMatcher.matches()) {
                String rebName = rebMatcher.group(1) + rebMatcher.group(2);
                String type = rebMatcher.group(3);
                if ("name".equals(type)) {
                    rebNames.put(rebName, value);
                }
            } else if (raftMatcher.matches()) {
                String raftName = raftMatcher.group(1);
                String type = raftMatcher.group(2);
                if ("name".equals(type)) {
                    raftNames.put(raftName, value);
                }
            }
        });
        Map raftsMap = data.getCurrentValuesForCategory("Rafts");
        raftsMap.forEach((key, value) -> {
            Matcher rebMatcher = REB_PATTERN.matcher((CharSequence)key);
            if (rebMatcher.matches()) {
                String rebName = rebMatcher.group(1) + rebMatcher.group(2);
                String type = rebMatcher.group(3);
                if ("serialNum".equals(type)) {
                    rebSerialNums.put(rebName, value);
                }
            }
        });
        Map tempControlMap = data.getCurrentValuesForCategory("RaftTempControl");
        tempControlMap.forEach((key, value) -> {
            Matcher raftMatcher = RAFT_PATTERN.matcher((CharSequence)key);
            if (raftMatcher.matches()) {
                String raftName = raftMatcher.group(1);
                String type = raftMatcher.group(2);
                if ("TempControl/setTemp".equals(type)) {
                    setTemp.put(raftName, Double.parseDouble(value));
                }
            }
        });
        List allParameterInfo = data.getAllParameterInfo();
        allParameterInfo.forEach(pi -> {
            if ("sequencerConfig/sequencer".equals(pi.getPathName())) {
                seqMap.putAll((Map)pi.getCurrentValueObject());
            } else if ("sequencerConfig/sequencerChecksums".equals(pi.getPathName())) {
                seqChecksumMap.putAll((Map)pi.getCurrentValueObject());
            }
        });
        if (this.device == Camera.AUXTEL) {
            if (ccdLocations.size() != 1) {
                throw new RuntimeException("Incorrect length for AuxTel locations");
            }
            String theCcdLocation = (String)ccdLocations.iterator().next();
            return FocalPlaneSummaryInfoEvent.builder().ccdLocation(ccdLocations.stream().collect(SummaryInfoConverter.join())).raftBay(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).collect(SummaryInfoConverter.join())).ccdSlot(ccdLocations.stream().map(SummaryInfoConverter::ccdSlotForCCDLocation).collect(SummaryInfoConverter.join())).raftLSSTName(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).map(name -> (String)raftNames.get(name)).collect(SummaryInfoConverter.join())).ccdLSSTName(ccdLocations.stream().map(k -> (String)ccdNames.get(k)).collect(SummaryInfoConverter.join())).ccdManufacturer(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).collect(SummaryInfoConverter.join())).ccdType(FocalPlaneSummaryInfoEvent.CcdType.ITL).ccdManSerNum(ccdLocations.stream().map(k -> SummaryInfoConverter.get(manSerNums, k)).collect(SummaryInfoConverter.join())).rebSerialNumber(ccdLocations.stream().map(ccd -> SummaryInfoConverter.rebSlotForCCDLocation(ccdNameToRebName, ccd)).map(name -> (String)rebSerialNums.get(name)).collect(SummaryInfoConverter.join())).rebLSSTName(ccdLocations.stream().map(ccd -> SummaryInfoConverter.rebSlotForCCDLocation(ccdNameToRebName, ccd)).map(name -> SummaryInfoConverter.get(rebNames, name)).collect(SummaryInfoConverter.join())).ccdTempSetPoint(SummaryInfoConverter.get(setTemp, theCcdLocation, -999.0).doubleValue()).sequencerKey(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqMap, k)).collect(SummaryInfoConverter.join())).sequencerChecksum(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqChecksumMap, k, 0L)).map(l -> String.valueOf(l)).collect(SummaryInfoConverter.join())).build();
        }
        return org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent.builder().ccdLocation(ccdLocations.stream().collect(SummaryInfoConverter.join())).raftBay(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).collect(SummaryInfoConverter.join())).ccdSlot(ccdLocations.stream().map(SummaryInfoConverter::ccdSlotForCCDLocation).collect(SummaryInfoConverter.join())).raftLSSTName(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).map(name -> (String)raftNames.get(name)).collect(SummaryInfoConverter.join())).ccdLSSTName(ccdLocations.stream().map(k -> (String)ccdNames.get(k)).collect(SummaryInfoConverter.join())).ccdManufacturer(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).collect(SummaryInfoConverter.join())).ccdType((FocalPlaneSummaryInfoEvent.CcdType[])ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> FocalPlaneSummaryInfoEvent.CcdType.valueOf((String)k)).toArray(FocalPlaneSummaryInfoEvent.CcdType[]::new)).ccdManSerNum(ccdLocations.stream().map(k -> SummaryInfoConverter.get(manSerNums, k)).collect(SummaryInfoConverter.join())).rebSerialNumber(ccdLocations.stream().map(ccd -> SummaryInfoConverter.rebSlotForCCDLocation(ccdNameToRebName, ccd)).map(name -> (String)rebSerialNums.get(name)).collect(SummaryInfoConverter.join())).rebLSSTName(ccdLocations.stream().map(ccd -> SummaryInfoConverter.rebSlotForCCDLocation(ccdNameToRebName, ccd)).map(name -> SummaryInfoConverter.get(rebNames, name)).collect(SummaryInfoConverter.join())).ccdTempSetPoint(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).map(name -> SummaryInfoConverter.get(setTemp, name, -999.0)).mapToDouble(d -> d).toArray()).sequencerKey(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqMap, k)).collect(SummaryInfoConverter.join())).sequencerChecksum(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqChecksumMap, k, 0L)).map(l -> String.valueOf(l)).collect(SummaryInfoConverter.join())).build();
    }

    private static String raftBayForCCDLocation(String ccdLocation) {
        return ccdLocation.substring(0, 3);
    }

    private static String ccdSlotForCCDLocation(String ccdLocation) {
        return ccdLocation.substring(3, 6);
    }

    private static String rebSlotForCCDLocation(Map<String, String> ccdNameToRebName, String ccdLocation) {
        return ccdNameToRebName.get(ccdLocation);
    }

    private static <K> String get(Map<K, String> map, K name) {
        return SummaryInfoConverter.get(map, name, "Unknown");
    }

    private static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        return map.getOrDefault(key, defaultValue);
    }

    private static Collector<CharSequence, ?, String> join() {
        return DELIMITED_STRING_SPLIT_JOIN.joining();
    }
}

