/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.xml.MakeXMLConfiguration;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;

public class SALClassDescriptionMaker {
    private final Map<String, SALClassDescription> SALClassDescriptionMap = new TreeMap<String, SALClassDescription>();
    private final Map<String, Class> SALClassMap = new TreeMap<String, Class>();
    private static final boolean SALCLASS_DESCRIPTION_MAKER_DEBUG = false;
    private static final Set<String> CONFIGURATION_ATTRIBUTES = Collections.singleton(DataProviderInfo.Type.CONFIGURATION.name());
    private static final Set<String> TELEMETRY_ATTRIBUTES = new HashSet<String>();
    private static final Set<Pattern> trendingExclusions;
    private static final Logger LOG;
    private final MakeXMLConfiguration.DictionaryConfiguration dictConfig;
    final int level;

    public SALClassDescriptionMaker(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping) {
        this(dictConfig, mapping, dictConfig.getLevel());
    }

    public SALClassDescriptionMaker(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping, int level) {
        this.level = level;
        this.dictConfig = dictConfig;
        XMLMaker2.SALType salType = dictConfig.getSALType();
        String cscName = dictConfig.getCSCName();
        Camera camera = dictConfig.getCamera();
        String subsystemName = dictConfig.getComponentName();
        DataProviderDictionary dataProviderDictionary = null;
        try {
            dataProviderDictionary = dictConfig.getDictionary();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Could not fetch the dictionary", ex);
        }
        Set<String> attributeTypes = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? CONFIGURATION_ATTRIBUTES : TELEMETRY_ATTRIBUTES;
        List dpInfoList = dataProviderDictionary.getDataProviderInfos();
        block2: for (DataProviderInfo dpi : dpInfoList) {
            Mapping.Match match;
            String dataType = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (!attributeTypes.contains(dataType)) continue;
            String type = dpi.getAttributeValue(DataProviderInfo.Attribute.TYPE);
            String description = dpi.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
            String units = dpi.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            String cat = dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
            String string = cat = cat == null ? "" : cat;
            if ("TRENDING".equals(dataType)) {
                cat = "Trending";
            }
            String category = cat;
            if (type == null) {
                type = "double";
            }
            String originalPathName = dpi.getFullPath().replace("main/", "").trim();
            if (salType == XMLMaker2.SALType.SETTINGS_APPLIED && !originalPathName.contains("/")) {
                originalPathName = "/" + originalPathName;
            }
            if ("TRENDING".equals(dataType)) {
                for (Pattern exclude : trendingExclusions) {
                    if (!exclude.matcher(originalPathName).matches()) continue;
                    continue block2;
                }
            }
            if ((match = mapping.match(originalPathName)) != null) {
                SALClassDescription.SALVariable existingVariable;
                String rawSALClassParameterName = match.getPatternName() + "/" + match.getPathAfterMatch();
                String salClassParameterName = this.makeSALClassParameterName(rawSALClassParameterName.trim(), level);
                String topicName = this.makeSALTopicName(level, cscName, subsystemName, salType, rawSALClassParameterName, category);
                Class simpleSalClass = this.makeSALClasseName(topicName, salType, camera);
                SALClassDescription salClassDescription = this.SALClassDescriptionMap.computeIfAbsent(topicName, name -> new SALClassDescription(topicName, simpleSalClass, level, category));
                SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
                if (simpleSalClass != null) {
                    this.SALClassMap.put(topicName, simpleSalClass);
                }
                if ((existingVariable = salClassDescription.getVariable(salClassParameterName)) instanceof SALClassDescription.PatternMatchedSALVariable) {
                    ((SALClassDescription.PatternMatchedSALVariable)existingVariable).addBusVariable(busVariable);
                    continue;
                }
                String locationVariableName = match.getPatternName() + "Location";
                SALClassDescription.LocationVariable locationVariable = (SALClassDescription.LocationVariable)salClassDescription.getVariable(locationVariableName);
                if (locationVariable == null) {
                    locationVariable = new SALClassDescription.LocationVariable(locationVariableName, match.getPatternName() + " location");
                    salClassDescription.add(locationVariable);
                }
                SALClassDescription.PatternMatchedSALVariable var = new SALClassDescription.PatternMatchedSALVariable(match.getPatternName(), match.getLocation(), locationVariable, salClassParameterName, type, units, description);
                var.addBusVariable(busVariable);
                salClassDescription.add(var);
                continue;
            }
            String topicName = this.makeSALTopicName(level, cscName, subsystemName, salType, originalPathName, category);
            Class simpleSalClass = this.makeSALClasseName(topicName, salType, camera);
            SALClassDescription salClassDescription = this.SALClassDescriptionMap.computeIfAbsent(topicName, name -> new SALClassDescription(topicName, simpleSalClass, level, category));
            SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
            SALClassDescription.SimpleSALVariable var = new SALClassDescription.SimpleSALVariable(this.makeSALClassParameterName(originalPathName, level), type, units, description, busVariable);
            salClassDescription.add(var);
            if (simpleSalClass == null) continue;
            this.SALClassMap.put(topicName, simpleSalClass);
        }
        for (SALClassDescription classDescription : this.SALClassDescriptionMap.values()) {
            List locationVariables = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).collect(Collectors.toList());
            if (locationVariables.size() != 1) continue;
            SALClassDescription.SALVariable theLocationVariable = (SALClassDescription.SALVariable)locationVariables.get(0);
            classDescription.renameVariable(theLocationVariable, "location");
        }
    }

    public MakeXMLConfiguration.DictionaryConfiguration getDictionaryConfiguration() {
        return this.dictConfig;
    }

    public Map<String, SALClassDescription> getSALClassDescriptions() {
        return this.SALClassDescriptionMap;
    }

    public Map<String, Class> getSALClasses() {
        return this.SALClassMap;
    }

    private Class makeSALClasseName(String topicName, XMLMaker2.SALType salType, Camera camera) {
        String[] packages = null;
        switch (camera) {
            case COMCAM: {
                packages = new String[]{"org.lsst.sal.cccamera.event", "org.lsst.sal.camera.event", "org.lsst.sal.cccamera.telemetry", "org.lsst.sal.camera.telemetry"};
                break;
            }
            case AUXTEL: {
                packages = new String[]{"org.lsst.sal.atcamera.event", "org.lsst.sal.camera.event", "org.lsst.sal.atcamera.telemetry", "org.lsst.sal.camera.telemetry"};
                break;
            }
            case MAIN_CAMERA: {
                packages = new String[]{"org.lsst.sal.camera.event", "org.lsst.sal.camera.telemetry"};
            }
        }
        String tmpTopicName = topicName;
        tmpTopicName = tmpTopicName.replace("-", "_");
        tmpTopicName = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? tmpTopicName.replace(camera.getCscName() + "_logevent_", "") : tmpTopicName.replace(camera.getCscName() + "_", "");
        tmpTopicName = SALClassDescriptionMaker.capitalize(tmpTopicName);
        tmpTopicName = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? tmpTopicName + "ConfigurationEvent" : tmpTopicName + "Telemetry";
        Class<?> classForName = null;
        for (String pkg : packages) {
            try {
                classForName = Class.forName(pkg + "." + tmpTopicName);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (classForName == null) {
            Level messageLevel = Level.WARNING;
            if (camera == Camera.MAIN_CAMERA && (topicName.contains("shutter") || topicName.contains("fcs") || topicName.contains("vacuum") || topicName.contains("StatusAggregator"))) {
                messageLevel = Level.FINE;
            }
            if (topicName.contains("InfluxDb")) {
                messageLevel = Level.FINE;
            }
            LOG.log(messageLevel, "For {0} {1} {2} Class not found {3}", new Object[]{topicName, salType, camera, tmpTopicName});
        }
        return classForName;
    }

    private String makeSALTopicName(int level, String cscName, String subsystemName, XMLMaker2.SALType salType, String path, String category) {
        if (cscName.toLowerCase().contains("comcam")) {
            cscName = "CCCamera";
        }
        String subsystemAndComponent = "";
        if (!cscName.isEmpty()) {
            subsystemAndComponent = cscName.substring(0, 1).toUpperCase() + cscName.substring(1);
        }
        if (!(subsystemName = subsystemName.trim()).isEmpty()) {
            subsystemAndComponent = subsystemAndComponent + "_" + subsystemName.substring(0, 1).toLowerCase() + subsystemName.substring(1);
        }
        String className = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? cscName + "_logevent_" + subsystemName.toLowerCase() : subsystemAndComponent;
        if (path.contains("main/")) {
            path = path.replace("main/", "");
            className = subsystemAndComponent;
        } else {
            for (int i = 0; i < level; ++i) {
                String pathComponentI = path.split("/")[i];
                if (pathComponentI.length() <= 0) continue;
                className = className + "_" + SALClassDescriptionMaker.capitalize(pathComponentI);
            }
        }
        if (category != null && !category.isEmpty()) {
            className = className + "_" + category;
        }
        if (className.endsWith("_")) {
            className = className.substring(0, className.length() - 1);
        }
        return className;
    }

    final String makeSALClassParameterName(String path, int level) {
        path = path.replace("main/", "");
        int pathLength = path.split("/").length;
        String variableName = "";
        if ((path = path.replaceAll("-", "_")).startsWith("/")) {
            path = path.replace("/", "");
        }
        if (path.contains("/")) {
            if (level <= pathLength) {
                for (int i = level; i < pathLength; ++i) {
                    variableName = variableName + "_" + path.split("/")[i];
                }
                if (variableName.startsWith("_")) {
                    variableName = variableName.substring(1);
                }
            } else {
                System.out.println("!!You have specified level to be longer than the variable path + name!!");
                System.exit(-1);
            }
        } else {
            variableName = path;
        }
        return SALClassDescriptionMaker.uncapitalize(variableName).trim();
    }

    public static String capitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toUpperCase() + in.substring(1);
        }
        return in.toUpperCase();
    }

    public static String uncapitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toLowerCase() + in.substring(1);
        }
        return in.toLowerCase();
    }

    static {
        TELEMETRY_ATTRIBUTES.add(DataProviderInfo.Type.MONITORING.name());
        TELEMETRY_ATTRIBUTES.add(DataProviderInfo.Type.TRENDING.name());
        trendingExclusions = new HashSet<Pattern>();
        trendingExclusions.add(Pattern.compile("ccsVersions/.*"));
        trendingExclusions.add(Pattern.compile("runtimeInfo/.*"));
        trendingExclusions.add(Pattern.compile("config/.*"));
        trendingExclusions.add(Pattern.compile("ImageMetaData/.*"));
        trendingExclusions.add(Pattern.compile(".*/sequencerChecksum"));
        trendingExclusions.add(Pattern.compile(".*/sequencerFile"));
        trendingExclusions.add(Pattern.compile(".*endSetFilter.*"));
        trendingExclusions.add(Pattern.compile(".*startSetFilter.*"));
        LOG = Logger.getLogger(SALClassDescriptionMaker.class.getName());
    }
}

