/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.subsystem.ocsbridge.AuxTelConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.CameraConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.ComCamConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.GenericSender;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.OCSEventSender;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.lsst.sal.camera.CameraEvent;

public abstract class ConfigurationSender
extends GenericSender {
    private static final Logger LOG = Logger.getLogger(ConfigurationSender.class.getName());
    private OCSEventSender sender;

    static ConfigurationSender create(Camera device, OCSEventSender sender) {
        switch (device) {
            case COMCAM: {
                return new ComCamConfigurationSender(sender);
            }
            case AUXTEL: {
                return new AuxTelConfigurationSender(sender);
            }
            case MAIN_CAMERA: {
                return new CameraConfigurationSender(sender);
            }
        }
        throw new IllegalArgumentException("Unsupported device: " + device);
    }

    protected ConfigurationSender(OCSEventSender sender, Camera camera) {
        super(camera, XMLMaker2.SALType.SETTINGS_APPLIED);
        this.sender = sender;
    }

    public void send(StatusConfigurationInfo data) {
        try {
            List<CameraEvent> converted = this.getConverter().settingsAppliedEventConverter(data);
            if (converted.isEmpty()) {
                LOG.log(Level.INFO, "No converted configuration {0}", data.getOriginAgentInfo().getName());
            } else {
                for (CameraEvent t : converted) {
                    t = this.applyAfterBurner(t);
                    LOG.log(Level.INFO, "Sending {0} {1}", new Object[]{data.getOriginAgentInfo().getName(), t});
                    this.sender.sendEvent(t);
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.WARNING, String.format("Problem converting configuration subsytem: %s key: %s", data.getOriginAgentInfo().getName(), data.getConfigurationInfo()));
        }
    }

    protected CameraEvent applyAfterBurner(CameraEvent t) {
        return t;
    }

    void setSender(OCSCommandExecutor ocs) {
        this.sender = ocs;
    }

    String getConfigurationEvents() {
        return this.getConverter().getClassMap().values().stream().map(c -> c.getSimpleName()).map(name -> name.replaceAll("Event$", "")).map(name -> SALClassDescriptionMaker.uncapitalize(name)).collect(Collectors.joining(","));
    }
}

