/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.xml.MakeXMLConfiguration;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;

public class SALClassDescriptionMakerTest {
    private final Mapping mapping = Mapping.defaultMapping();

    @Test
    public void makeSALClassDescriptionFromAuxTelRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.AUXTEL, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("ats-power"), this.mapping);
        Map info = maker.getSALClassDescriptions();
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("ATCamera_power"));
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("rebpower"), this.mapping, 0);
        Map info = maker.getSALClassDescriptions();
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("MTCamera_rebpower"));
        SALClassDescription classDescription = (SALClassDescription)info.values().iterator().next();
        Assert.assertEquals((long)2L, (long)classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        List locationVariableNames = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).map(v -> v.getVariableName()).collect(Collectors.toList());
        Assert.assertTrue((boolean)locationVariableNames.contains("rebLocation"));
        Assert.assertTrue((boolean)locationVariableNames.contains("rebpsLocation"));
        List variables = classDescription.getVariables();
        Collections.sort(variables, (v1, v2) -> v1.getVariableName().compareTo(v2.getVariableName()));
        Assert.assertEquals((Object)classDescription.getVariables(), (Object)variables);
        CRC32 sum = new CRC32();
        classDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)3640498962L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraFCSLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("fcs"), this.mapping);
        Map info = maker.getSALClassDescriptions();
        System.out.println(info);
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRebPowerLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("rebpower"), this.mapping);
        Map info = maker.getSALClassDescriptions();
        Assert.assertEquals((long)2L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("MTCamera_rebpower_Reb"));
        SALClassDescription classDescription = (SALClassDescription)info.values().iterator().next();
        Assert.assertEquals((long)1L, (long)classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        List locationVariableNames = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).map(v -> v.getVariableName()).collect(Collectors.toList());
        Assert.assertTrue((boolean)locationVariableNames.contains("location"));
        List variables = classDescription.getVariables();
        Collections.sort(variables, (v1, v2) -> v1.getVariableName().compareTo(v2.getVariableName()));
        Assert.assertEquals((Object)classDescription.getVariables(), (Object)variables);
        SALClassDescription desc = (SALClassDescription)info.get("MTCamera_rebpower_Reb");
        SALClassDescription.SALVariable var = desc.getVariable("dphi_IbefLDO");
        Assert.assertEquals((long)8L, (long)var.getCount());
        Assert.assertEquals((long)71L, (long)desc.getSharedLocationCount(var));
        CRC32 sum = new CRC32();
        classDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)72957452L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromComCamFocalPlaneLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.COMCAM, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("comcam-fp"), this.mapping);
        Map info = maker.getSALClassDescriptions();
        Assert.assertEquals((String)info.keySet().toString(), (long)5L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_focal_plane_Reb"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_focal_plane_Ccd"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_focal_plane_Segment"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_focal_plane_RebTotalPower"));
        SALClassDescription ccdDescription = (SALClassDescription)info.get("CCCamera_focal_plane_Ccd");
        Assert.assertEquals((long)1L, (long)ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        SALClassDescription.SALVariable locationVariable = ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).findAny().get();
        Assert.assertEquals((Object)"location", (Object)locationVariable.getVariableName());
        int count = ccdDescription.getSharedLocationCount(ccdDescription.getVariable("gDV"));
        Assert.assertEquals((long)9L, (long)count);
        CRC32 sum = new CRC32();
        ccdDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)441659878L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromComcamDaqMonitorSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.COMCAM, (XMLMaker2.SALType)XMLMaker2.SALType.SETTINGS_APPLIED);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("comcam-daq-monitor"), this.mapping, 0);
        Map infos = maker.getSALClassDescriptions();
        Assert.assertEquals((long)7L, (long)infos.size());
        Set categories = infos.values().stream().map(desc -> desc.getCategory()).collect(Collectors.toSet());
        Assert.assertEquals((long)7L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("Store"));
        CRC32 sum = new CRC32();
        for (SALClassDescription info : infos.values()) {
            info.updateChecksum((Checksum)sum);
        }
        Assert.assertEquals((long)474852746L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRaftsSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.SETTINGS_APPLIED);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("daq-monitor"), this.mapping, 0);
        Map infos = maker.getSALClassDescriptions();
        Assert.assertEquals((long)7L, (long)infos.size());
        Set categories = infos.values().stream().map(desc -> desc.getCategory()).collect(Collectors.toSet());
        Assert.assertEquals((long)7L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("Store"));
        CRC32 sum = new CRC32();
        for (SALClassDescription info : infos.values()) {
            info.updateChecksum((Checksum)sum);
        }
        Assert.assertEquals((long)3907936175L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromCamShutterStatusSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException {
        MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)Camera.MAIN_CAMERA, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(xmlConfig.getDictionaryConfigurationForAgent("cam-shutter"), this.mapping);
        Map infos = maker.getSALClassDescriptions();
    }
}

