package org.lsst.ccs.subsystem.ocsbridge.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author tonyj
 */
public class XMLUtils {
    
    private final XPath xpath;

    XMLUtils() {
        xpath = XPathFactory.newInstance().newXPath();
    }
    
    /**
     * Replace part of an XML document with the contents of a second XML document.
     * The part to be replaced is delimited with XML comments
     * @param original The original document, which will be updated
     * @param replacement The replacement document
     * @param beginDelimiter The text to identify the start comment
     * @param endDelimeter The text to identify the end comment
     * @throws XPathExpressionException 
     */
    public void replacePartOfDocument(Document original, Document replacement, String beginDelimiter, String endDelimeter) throws XPathExpressionException {

        NodeList nl = (NodeList) xpath.evaluate("//text()[normalize-space(.)='']", original, XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            node.getParentNode().removeChild(node);
        }
        Element root = original.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        int startIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < childNodes.getLength(); i++) {
            Node node = childNodes.item(i);
            if (node instanceof Comment) {
                Comment comment = (Comment) node;
                if (comment.getData().trim().startsWith(beginDelimiter)) {
                    startIndex = i;
                } else if (comment.getData().trim().startsWith(endDelimeter)) {
                    endIndex = i;
                }
            }
        }
        for (int i = startIndex + 1; i < endIndex; i++) {
            root.removeChild(childNodes.item(startIndex).getNextSibling());
        }
        Node nextSibling = childNodes.item(startIndex).getNextSibling();
        NodeList replacementNodes = replacement.getDocumentElement().getChildNodes();
        for (int i = 0; i < replacementNodes.getLength(); i++) {
            Node newNode = original.importNode(replacementNodes.item(i), true);
            root.insertBefore(newNode, nextSibling);
        }
    }
}
