/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FocalPlaneSimulation
implements FocalPlaneInterface {
    private final State raftsState;
    private final CCS ccs;
    static final Duration QUIESCENT_BEFORE_CLEAR = Duration.ofMillis(4000L);

    public FocalPlaneSimulation(final CCS ccs, final State raftsState) {
        this.raftsState = raftsState;
        this.ccs = ccs;
        raftsState.addStateChangeListener(new State.StateChangeListener<FocalPlane.RaftsState>(){
            private ScheduledFuture<?> clearFuture;

            @Override
            public void stateChanged(CCSTimeStamp when, FocalPlane.RaftsState currentState, FocalPlane.RaftsState oldState, String cause) {
                if (currentState == FocalPlane.RaftsState.QUIESCENT) {
                    this.clearFuture = ccs.schedule(QUIESCENT_BEFORE_CLEAR, () -> raftsState.setState(when, FocalPlane.RaftsState.NEEDS_CLEAR));
                } else if (this.clearFuture != null) {
                    this.clearFuture.cancel(false);
                    this.clearFuture = null;
                }
            }
        });
    }

    @Override
    public void clear(int nClears) {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.QUIESCENT, FocalPlane.RaftsState.NEEDS_CLEAR});
        this.raftsState.setState(FocalPlane.RaftsState.CLEARING);
        this.ccs.schedule(FocalPlane.CLEAR_TIME.multipliedBy(nClears), () -> this.raftsState.setState(FocalPlane.RaftsState.QUIESCENT));
    }

    @Override
    public void discardRows(int nRows) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.INTEGRATING});
        this.raftsState.setState(FocalPlane.RaftsState.DISCARDING);
        this.ccs.schedule(FocalPlane.DISCARD_TIME.multipliedBy(nRows), () -> this.raftsState.setState(FocalPlane.RaftsState.INTEGRATING));
    }

    @Override
    public void endIntegration(boolean readout) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.INTEGRATING});
        if (readout) {
            this.raftsState.setState(FocalPlane.RaftsState.READING_OUT);
            this.ccs.schedule(FocalPlane.READOUT_TIME, () -> this.raftsState.setState(FocalPlane.RaftsState.QUIESCENT));
        } else {
            this.raftsState.setState(FocalPlane.RaftsState.NEEDS_CLEAR);
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void startIntegration(ImageName imageName, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        this.raftsState.checkState(new Enum[]{FocalPlane.RaftsState.QUIESCENT});
        this.raftsState.setState(FocalPlane.RaftsState.INTEGRATING);
    }

    @Override
    public void play(String playlist, boolean repeat) {
    }

    @Override
    public void definePlaylist(String playlist, String folder, String ... images) {
    }

    @Override
    public void clearAndStartIntegration(ImageName imageName, int nClears, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        try {
            this.clear(nClears);
            this.ccs.waitForStatus(FocalPlane.RaftsState.QUIESCENT).get(FocalPlane.CLEAR_TIME.toMillis() + 1000L, TimeUnit.MILLISECONDS);
            this.startIntegration(imageName, parsedKeyValueData, locations, annotation, stopGuiding);
        }
        catch (InterruptedException ex) {
            throw new ExecutionException("Interrupt waiting for clear", ex);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for clear", ex);
        }
    }

    @Override
    public void initGuiders(String roiSpec) {
    }

    @Override
    public void clearROI() throws ExecutionException {
    }

    @Override
    public void setHeaderKeywords(Map<String, Serializable> headersMap) {
    }
}

