/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMakerTest2 {
    @Test
    public void makeXMLFromMainCameraRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, "rebpower-status-dictionary.ser", true, 0, "MTCamera", "rebpower");
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)1L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"MTCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(578302030L, maker, dom);
    }

    @Test
    public void makeXMLFromMainCameraRebPowerLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, "rebpower-status-dictionary.ser", true, 1, "MTCamera", "rebpower");
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)2L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"MTCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(2814758651L, maker, dom);
    }

    @Test
    public void makeXMLFromComcamDaqMonitorLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, "comcam-daq-monitor-status-dictionary.ser", true, 1, "CCCamera", "daq-monitor");
        NodeList telemetryElements = dom.getElementsByTagName("SALTelemetry");
        Assert.assertEquals((long)1L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"CCCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(3981984699L, maker, dom);
    }

    @Test
    public void makeXMLFromComcamDaqMonitorSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        XMLMaker2 maker = new XMLMaker2(false);
        Document dom = this.makeXMLFromStatusDataProviderDictionary(maker, "comcam-daq-monitor-status-dictionary.ser", false, 0, "CCCamera", "daq-monitor");
        NodeList telemetryElements = dom.getElementsByTagName("SALEvent");
        Assert.assertEquals((long)6L, (long)telemetryElements.getLength());
        Node subsystemElement = telemetryElements.item(0).getFirstChild();
        Assert.assertNotNull((Object)subsystemElement);
        Assert.assertEquals((Object)"CCCamera", (Object)subsystemElement.getTextContent());
        this.checkXML(3779578841L, maker, dom);
    }

    private void checkXML(long result, XMLMaker2 maker, Document dom) throws TransformerException {
        CRC32 checkSum = new CRC32();
        StreamResult output = new StreamResult(new CheckedOutputStream(new NullOutputStream(), checkSum));
        maker.writeXML(output, dom);
        Assert.assertEquals((long)result, (long)checkSum.getValue());
    }

    private long getXMLCksum(XMLMaker2 maker, Document dom) throws TransformerException {
        CRC32 checkSum = new CRC32();
        StreamResult output = new StreamResult(new CheckedOutputStream(new NullOutputStream(), checkSum));
        maker.writeXML(output, dom);
        return checkSum.getValue();
    }

    public Document makeXMLFromStatusDataProviderDictionary(XMLMaker2 maker, String file, boolean telemetry, int level, String cscName, String componentName) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Object readObject;
        try (InputStream in = GenericConverterTest.class.getResourceAsStream(file);
             ObjectInputStream ois = new ObjectInputStream(in);){
            readObject = ois.readObject();
        }
        Assert.assertTrue((boolean)(readObject instanceof StatusDataProviderDictionary));
        StatusDataProviderDictionary info = (StatusDataProviderDictionary)readObject;
        Mapping mapping = Mapping.defaultMapping();
        Document doc = telemetry ? maker.makeXMLFromDataProviderDictionary(info, cscName, componentName, level, mapping) : maker.makeXMLFromConfigDictionary(info, cscName, componentName, level, mapping);
        return doc;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

