/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.atcamera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.atcamera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_EmergencyResponseManager_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_buildConfigurationEvent;

public class ConfigConverterTest {
    @Test
    public void configComCamDaqMonitorCoverterTest2() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-daq-monitor-config-info.ser");
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-daq-monitor", 1, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        Assert.assertEquals((Object)"comcam-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-daq-monitor");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("CCCamera_logevent_comcam-daq-monitor_PeriodicTasks", Daq_monitor_PeriodicTasksConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_PeriodicTasks_timers", Daq_monitor_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Stats_Statistics", Daq_monitor_Stats_StatisticsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Stats_build", Daq_monitor_Stats_buildConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Store_Limits", Daq_monitor_Store_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Store_Store", Daq_monitor_Store_StoreConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)4L, (long)converted.size());
        for (CameraEvent event : converted) {
            Daq_monitor_Store_StoreConfigurationEvent store;
            if (!(event instanceof Daq_monitor_Store_StoreConfigurationEvent)) continue;
            Daq_monitor_Store_StoreConfigurationEvent convertedData = store = (Daq_monitor_Store_StoreConfigurationEvent)event;
            Assert.assertEquals((Object)"raw", (Object)convertedData.getDaqFolder());
            Assert.assertEquals((Object)true, (Object)convertedData.isEnableAutoPurge());
            Assert.assertEquals((double)0.7, (double)convertedData.getPurgeTarget(), (double)1.0E-5);
        }
    }

    @Test
    public void auxTelDaqMonitorCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-daq-monitor-config-info.ser");
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-daq-monitor", 1, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        Assert.assertEquals((Object)"ats-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-daq-monitor");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("ATCamera_logevent_ats-daq-monitor_PeriodicTasks_timers", Daq_monitor_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Stats_Statistics", Daq_monitor_Stats_StatisticsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Limits", Daq_monitor_Store_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Store", Daq_monitor_Store_StoreConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)4L, (long)converted.size());
        for (CameraEvent event : converted) {
            if (!(event instanceof Daq_monitor_Store_StoreConfigurationEvent)) continue;
            Daq_monitor_Store_StoreConfigurationEvent convertedData = (Daq_monitor_Store_StoreConfigurationEvent)event;
            Assert.assertEquals((Object)"raw", (Object)convertedData.getDaqFolder());
            Assert.assertEquals((Object)true, (Object)convertedData.isEnableAutoPurge());
            Assert.assertEquals((double)0.7, (double)convertedData.getPurgeTarget(), (double)1.0E-5);
        }
    }

    @Test
    public void auxTelPowerCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-power-config-info.ser");
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-power-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-power", 1, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        Assert.assertEquals((Object)"ats-power", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-power");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("ATCamera_logevent_ats-power_Analog_I_Limits", Ats_power_Analog_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Analog_V_Limits", Ats_power_Analog_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_I_Limits", Ats_power_Aux_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_V_Limits", Ats_power_Aux_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_I_Limits", Ats_power_ClkHigh_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_V_Limits", Ats_power_ClkHigh_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_I_Limits", Ats_power_ClkLow_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_V_Limits", Ats_power_ClkLow_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_I_Limits", Ats_power_DPHI_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_V_Limits", Ats_power_DPHI_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_I_Limits", Ats_power_Digital_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_V_Limits", Ats_power_Digital_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_I_Limits", Ats_power_Fan_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_V_Limits", Ats_power_Fan_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_I_Limits", Ats_power_HVBias_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_V_Limits", Ats_power_HVBias_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg1_Devices", Ats_power_Hameg1_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg1_Power", Ats_power_Hameg1_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg2_Devices", Ats_power_Hameg2_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg2_Power", Ats_power_Hameg2_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg3_Devices", Ats_power_Hameg3_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg3_Power", Ats_power_Hameg3_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Keithley_Devices", Ats_power_Keithley_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Keithley_Power", Ats_power_Keithley_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_I_Limits", Ats_power_OD_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_V_Limits", Ats_power_OD_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_I_Limits", Ats_power_OTM_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_V_Limits", Ats_power_OTM_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_PeriodicTasks_General", Ats_power_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_PeriodicTasks_timers", Ats_power_PeriodicTasks_timersConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        for (CameraEvent event : converted) {
            if (event instanceof Ats_power_Hameg2_PowerConfigurationEvent) {
                Ats_power_Hameg2_PowerConfigurationEvent convertedData = (Ats_power_Hameg2_PowerConfigurationEvent)event;
                Assert.assertEquals((double)0.75, (double)convertedData.getAnalog_current(), (double)1.0E-5);
                Assert.assertEquals((double)0.4, (double)convertedData.getAnalog_offDelay(), (double)1.0E-5);
                Assert.assertEquals((double)0.1, (double)convertedData.getAnalog_onDelay(), (double)1.0E-5);
                Assert.assertEquals((double)7.2, (double)convertedData.getAnalog_voltage(), (double)1.0E-5);
                continue;
            }
            if (!(event instanceof Ats_power_Hameg1_PowerConfigurationEvent)) continue;
            Ats_power_Hameg1_PowerConfigurationEvent convertedData2 = (Ats_power_Hameg1_PowerConfigurationEvent)event;
            Assert.assertEquals((double)0.9, (double)convertedData2.getDigital_current(), (double)1.0E-5);
            Assert.assertEquals((double)0.5, (double)convertedData2.getDigital_offDelay(), (double)1.0E-5);
            Assert.assertEquals((double)0.0, (double)convertedData2.getDigital_onDelay(), (double)1.0E-5);
            Assert.assertEquals((double)5.25, (double)convertedData2.getDigital_voltage(), (double)1.0E-5);
        }
    }

    @Test
    public void configComCamFocalPlaneCoverterTestLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 0;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-fp-config-info.ser");
        Assert.assertEquals((Object)"comcam-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap classMap = new HashMap();
        Assert.assertEquals((Object)"placeHolder", (Object)"placeHolder");
    }

    @Test
    public void configComCamFocalPlaneCoverterTestLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-fp-config-info.ser");
        Assert.assertEquals((Object)"comcam-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap<String, Class<Focal_plane_WebHooksConfig_VisualizationConfigurationEvent>> classMap = new HashMap<String, Class<Focal_plane_WebHooksConfig_VisualizationConfigurationEvent>>();
        classMap.put("CCCamera_logevent_comcam-fp_Ccd_HardwareId", Focal_plane_Ccd_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Ccd_Limits", Focal_plane_Ccd_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Ccd_Rafts", Focal_plane_Ccd_RaftsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_ImageDatabaseService_General", Focal_plane_ImageDatabaseService_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_ImageNameService_General", Focal_plane_ImageNameService_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_InstrumentConfig_Instrument", Focal_plane_InstrumentConfig_InstrumentConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_PeriodicTasks_General", Focal_plane_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_PeriodicTasks_timers", Focal_plane_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_HardwareId", Focal_plane_Raft_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControl", org.lsst.sal.cccamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControlStatus", Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_RebTotalPower_Limits", Focal_plane_RebTotalPower_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Devices", Focal_plane_Reb_DevicesConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_HardwareId", Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Limits", Focal_plane_Reb_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Rafts", Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_RaftsLimits", Focal_plane_Reb_RaftsLimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_RaftsPower", Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_timers", Focal_plane_Reb_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Segment_Limits", Focal_plane_Segment_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_DAQ", Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_Sequencer", Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_WebHooksConfig_Visualization", Focal_plane_WebHooksConfig_VisualizationConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        for (CameraEvent event : converted) {
            System.out.println(event);
        }
    }

    @Test
    public void configComCamImageHandlerConverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-ih-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-ih", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-ih-config-info.ser");
        Assert.assertEquals((Object)"comcam-ih", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-ih");
        HashMap<String, Class<Image_handling_Reb_GeneralConfigurationEvent>> classMap = new HashMap<String, Class<Image_handling_Reb_GeneralConfigurationEvent>>();
        classMap.put("CCCamera_logevent_comcam-ih_ImageHandler_Commands", org.lsst.sal.cccamera.event.Image_handling_ImageHandler_CommandsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_ImageHandler_DAQ", Image_handling_ImageHandler_DAQConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_ImageHandler_FitsHandling", org.lsst.sal.cccamera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_PeriodicTasks_General", Image_handling_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_PeriodicTasks_timers", Image_handling_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_Reb_FitsHandling", Image_handling_Reb_FitsHandlingConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_Reb_General", Image_handling_Reb_GeneralConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        for (CameraEvent event : converted) {
            if (!(event instanceof Image_handling_ImageHandler_DAQConfigurationEvent)) continue;
            Image_handling_ImageHandler_DAQConfigurationEvent daq = (Image_handling_ImageHandler_DAQConfigurationEvent)event;
            Assert.assertEquals((Object)"DAQ:ImageHandling/common(1)|ImageHandling/comcam(1)|ImageHandling/comcam-summit(1)", (Object)daq.getVersion());
            Assert.assertEquals((Object)"comcam", (Object)daq.getImagehandlingconfig_daqPartition());
            Assert.assertEquals((long)4L, (long)daq.getImagehandlingconfig_daqThreads());
        }
    }

    @Test
    public void configComCamFocalPlaneCoverterTestWeird() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-daq-monitor-config-info.ser");
        Assert.assertEquals((Object)"comcam-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap<String, Class<Focal_plane_Reb_HardwareIdConfigurationEvent>> classMap = new HashMap<String, Class<Focal_plane_Reb_HardwareIdConfigurationEvent>>();
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_DAQ", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_Sequencer", Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_RaftsPower", Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Rafts", Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControlStatus", Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControl", org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_HardwareId", Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)0L, (long)converted.size());
        System.out.println(converted);
    }

    @Test
    public void configComCamRebPowerCoverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("comcam-rebpower-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-rebpower", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("comcam-rebpower-config-info.ser");
        Assert.assertEquals((Object)"comcam-rebpower", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-rebpower");
        HashMap<String, Class<Rebpower_Rebps_buildConfigurationEvent>> classMap = new HashMap<String, Class<Rebpower_Rebps_buildConfigurationEvent>>();
        classMap.put("CCCamera_logevent_comcam-rebpower_EmergencyResponseManager_General", Rebpower_EmergencyResponseManager_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_General", Rebpower_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_PeriodicTasks_General", Rebpower_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_PeriodicTasks_timers", Rebpower_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Reb_General", Rebpower_Reb_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Reb_Limits", Rebpower_Reb_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_Devices", Rebpower_Rebps_DevicesConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_General", Rebpower_Rebps_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_Limits", Rebpower_Rebps_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_Power", Rebpower_Rebps_PowerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_build", Rebpower_Rebps_buildConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        System.out.println(converted);
    }

    @Test
    public void configAuxTelFocalPlaneCoverterTestLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-fp-config-info.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        HashMap<String, Class<org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent>> classMap = new HashMap<String, Class<org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent>>();
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_DAQ", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_Sequencer", Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_RaftsPower", Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Rafts", Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControlStatus", Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControl", Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        System.out.println(converted);
    }

    @Test
    public void configAuxTelFocalPlaneConverterVisualizationTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-fp-config-info.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        HashMap<String, Class<Focal_plane_WebHooksConfig_VisualizationConfigurationEvent>> classMap = new HashMap<String, Class<Focal_plane_WebHooksConfig_VisualizationConfigurationEvent>>();
        classMap.put("ATCamera_logevent_ats-fp_WebHooksConfig_Visualization", Focal_plane_WebHooksConfig_VisualizationConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        System.out.println(converted);
        StatusConfigurationInfo data2 = ConfigConverterTest.readConfigData("ats-fp-tucson-config-info.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data2.getOriginAgentInfo().getName());
        List converted2 = converter.settingsAppliedEventConverter(salClassDescriptions, data2);
        Assert.assertEquals((long)1L, (long)converted2.size());
        System.out.println(converted2);
    }

    @Test
    public void configAuxTelImageHandlerConverterTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-ih-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-ih", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-ih-config-info.ser");
        Assert.assertEquals((Object)"ats-ih", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-ih");
        HashMap<String, Class<org.lsst.sal.atcamera.event.Image_handling_Reb_GeneralConfigurationEvent>> classMap = new HashMap<String, Class<org.lsst.sal.atcamera.event.Image_handling_Reb_GeneralConfigurationEvent>>();
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_Commands", Image_handling_ImageHandler_CommandsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_DAQ", Image_handling_ImageHandler_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_FitsHandling", Image_handling_ImageHandler_FitsHandlingConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_PeriodicTasks_General", Image_handling_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_PeriodicTasks_timers", Image_handling_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_Reb_FitsHandling", Image_handling_Reb_FitsHandlingConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_Reb_General", org.lsst.sal.atcamera.event.Image_handling_Reb_GeneralConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)classMap.size(), (long)converted.size());
        for (CameraEvent event : converted) {
            if (!(event instanceof Image_handling_ImageHandler_DAQConfigurationEvent)) continue;
            Image_handling_ImageHandler_DAQConfigurationEvent daq = (Image_handling_ImageHandler_DAQConfigurationEvent)event;
            Assert.assertEquals((Object)"DAQ:ImageHandling/common(1)|ImageHandling/ats(1)|ImageHandling/ats-tucson(2)", (Object)daq.getVersion());
            Assert.assertEquals((Object)"lat", (Object)daq.getImagehandlingconfig_daqPartition());
            Assert.assertEquals((long)4L, (long)daq.getImagehandlingconfig_daqThreads());
        }
    }

    @Test
    public void configAuxTelFocalPlaneCoverterTimersTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, ReflectiveOperationException {
        int level = 1;
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = this.readDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-fp", level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusConfigurationInfo data = ConfigConverterTest.readConfigData("ats-fp-config-info.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        HashMap<String, Class<org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent>> classMap = new HashMap<String, Class<org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent>>();
        classMap.put("ATCamera_logevent_ats-fp_Reb_timers", org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.settingsAppliedEventConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Assert.assertTrue((boolean)(converted.get(0) instanceof org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent));
        org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent timers = (org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent)converted.get(0);
        Assert.assertEquals((long)10000L, (long)timers.getPeriodictasks_monitor_check_taskPeriodMillis()[0]);
        Assert.assertEquals((long)1000L, (long)timers.getPeriodictasks_monitor_update_taskPeriodMillis()[0]);
    }

    /*
     * Exception decompiling
     */
    public static StatusConfigurationInfo readConfigData(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private StatusDataProviderDictionary readDictionary(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

