/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.config.Device;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;

public class TelemetrySenderTest {
    @Test
    public void auxTelTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> {
            if (t instanceof Focal_plane_CcdTelemetry) {
                Focal_plane_CcdTelemetry fct = (Focal_plane_CcdTelemetry)t;
                String location = fct.getLocation();
                Assert.assertEquals((Object)"R00S00", (Object)location);
            }
            callCount.incrementAndGet();
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Device)Device.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-daq-monitor", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusDataProviderDictionary dictionary2 = GenericConverterTest.readStatusDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker2 = new SALClassDescriptionMaker(dictionary2.getDataProviderDictionary(), "ATCamera", "ats-fp", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker2.getSALClassDescriptions());
        StatusDataProviderDictionary dictionary3 = GenericConverterTest.readStatusDictionary("bonn-shutter-status-dictionary.ser");
        SALClassDescriptionMaker maker3 = new SALClassDescriptionMaker(dictionary3.getDataProviderDictionary(), "ATCamera", "bonn-shutter", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker3.getSALClassDescriptions());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-daq-monitor-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("bonn-shutter-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_aspicTemp-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_crVolt-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_rebTemp-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default-trending.ser"));
        Assert.assertEquals((long)5L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)5L, (long)callCount.get());
        Thread.sleep(20000L);
        Assert.assertEquals((long)9L, (long)callCount.get());
    }

    @Test
    public void auxTelVacuumTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Device)Device.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats", 0, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void comcamTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Device)Device.COMCAM, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-daq-monitor", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusDataProviderDictionary dictionary2 = GenericConverterTest.readStatusDictionary("comcam-quadbox-status-dictionary.ser");
        SALClassDescriptionMaker maker2 = new SALClassDescriptionMaker(dictionary2.getDataProviderDictionary(), "CCCamera", "comcam-quadbox", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker2.getSALClassDescriptions());
        StatusDataProviderDictionary dictionary3 = GenericConverterTest.readStatusDictionary("comcam-rebpower-status-dictionary.ser");
        SALClassDescriptionMaker maker3 = new SALClassDescriptionMaker(dictionary3.getDataProviderDictionary(), "CCCamera", "comcam-rebpower", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker3.getSALClassDescriptions());
        StatusDataProviderDictionary dictionary4 = GenericConverterTest.readStatusDictionary("comcam-bonn-shutter-status-dictionary.ser");
        SALClassDescriptionMaker maker4 = new SALClassDescriptionMaker(dictionary4.getDataProviderDictionary(), "CCCamera", "bonn-shutter", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker4.getSALClassDescriptions());
        sender.send(salClassDescriptions, GenericConverterTest.readData("comcam-daq-monitor-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("comcam-quadbox-trending.ser"));
        Assert.assertEquals((long)6L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("comcam-rebpower-trending.ser"));
        Assert.assertEquals((long)8L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("comcam-bonn-shutter-trending.ser"));
        Assert.assertEquals((long)9L, (long)callCount.get());
    }
}

