package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

/**
 *
 * @author tonyj
 */
public class CameraConfigurationSender extends ConfigurationSender {

    private final GenericConverter converter;
    private final Map<String, Class> classMap;

    public CameraConfigurationSender(OCSEventSender sender) {
        super(sender);

        Mapping mapping = Mapping.defaultMapping();
        List<String> subSystems = new ArrayList<>();
        classMap = new HashMap<>();

        converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }
    
    @Override
    String getConfigurationEvents() {
        return classMap.values().stream().map(c -> c.getSimpleName()).map(name -> name.replaceAll("Event$", "")).map(name -> SALClassDescriptionMaker.uncapitalize(name)).collect(Collectors.joining(","));
    }
}
