/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAvailableFiltersEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerSimulation;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MainCameraFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class FilterChanger {
    private static final Logger LOG = Logger.getLogger(FilterChanger.class.getName());
    private List<String> installedFilters;
    private final CCS ccs;
    private FilterChangerInterface filterChanger;
    private final MCMConfig config;

    FilterChanger(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.filterChanger = new FilterChangerSimulation(ccs, config);
    }

    public void start(String configName) throws ExecutionException {
        this.filterChanger.start(configName);
        this.installedFilters = this.filterChanger.getInstalledFilters();
        LOG.log(Level.INFO, "Installed filters {0}", this.installedFilters);
        this.ccs.fireEvent((CCSEvent)new CCSAvailableFiltersEvent(this.installedFilters));
    }

    boolean filterIsAvailable(String filter) {
        return this.installedFilters.contains(filter);
    }

    List<String> getAvailableFilters() {
        return this.installedFilters;
    }

    void setFilter(String filter) throws ExecutionException {
        this.filterChanger.setFilter(filter);
    }

    Duration getEstimatedTimeForChange(String filterName) {
        return this.filterChanger.getEstimatedDurationForFilterChange(filterName);
    }

    ControlledSubsystem registerMCMSubsystem(MCMSubsystem mcm) {
        ControlledSubsystem controlledSubsystem = this.config.getCameraType() == Camera.MAIN_CAMERA ? new MainCameraFilterChangerSubsystemLayer(mcm, this.ccs, this.config) : new ComCamFilterChangerSubsystemLayer(mcm, this.ccs, this.config);
        this.filterChanger = controlledSubsystem;
        return controlledSubsystem;
    }

    public static enum FilterState {
        ROTATING,
        UNLOADED,
        LOADED,
        UNLOADING,
        LOADING,
        NOFILTER;

    }
}

