/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.xml.Main;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MakeAllXML {
    public static void main(String[] args) throws Exception {
        File outputLocation = new File("/home/tonyj/projects/lsst/ocs-ccs/ts_xml/sal_interfaces/");
        MakeAllXML.makeAllComCamXML(new File(outputLocation, "CCCamera/"));
        MakeAllXML.makeAllMainCameraXML(new File(outputLocation, "MTCamera/"));
        MakeAllXML.makeAllAuxTelXML(new File(outputLocation, "ATCamera/"));
    }

    private static void makeAllAuxTelXML(File outputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        int i;
        Mapping mapping = Main.createMapping(null);
        outputLocation.mkdirs();
        File outputFileName = new File(outputLocation, "ATCamera_Telemetry.xml");
        String cscName = "ATCamera";
        XMLMaker2 maker = new XMLMaker2(false);
        Document document = maker.createDocument(XMLMaker2.SALType.TELEMETRY);
        String path = "ats-power-status-dictionary.ser";
        StatusDataProviderDictionary dictionary1 = Main.readFromPath(path);
        String path1 = "ats-status-dictionary.ser";
        StatusDataProviderDictionary dictionary1a = Main.readFromPath(path1);
        String path2 = "ats-daq-monitor-status-dictionary.ser";
        StatusDataProviderDictionary dictionary2 = Main.readFromPath(path2);
        String path3 = "bonn-shutter-status-dictionary.ser";
        StatusDataProviderDictionary dictionary3 = Main.readFromPath(path3);
        String path4 = "ats-ih-status-dictionary.ser";
        StatusDataProviderDictionary dictionary4 = Main.readFromPath(path4);
        String path6 = "ats-fp-status-dictionary.ser";
        StatusDataProviderDictionary dictionary6 = Main.readFromPath(path6);
        maker.addXMLFromMonitoringDictionary(document, dictionary6, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary2, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary1, cscName, "power", 0, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary1a, cscName, "vacuum", 0, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary3, cscName, "bonn_shutter", 1, mapping);
        maker.writeXML(new StreamResult(outputFileName), document);
        System.out.println("Wrote " + outputFileName);
        File settingsApplideOutputFileName = new File(outputLocation, "ATCamera_Events.xml");
        Document settingsAppliedDocument = maker.createDocument(XMLMaker2.SALType.SETTINGS_APPLIED);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary6, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary2, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1, cscName, "ats_power", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1a, cscName, "ats", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary3, cscName, "bonn_shutter", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary4, cscName, "image_handling", 1, mapping);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(settingsApplideOutputFileName);
        XPath xp = XPathFactory.newInstance().newXPath();
        NodeList nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            node.getParentNode().removeChild(node);
        }
        Element root = doc.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        int startIndex = 0;
        int endIndex = 0;
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Comment)) continue;
            Comment comment = (Comment)node;
            if (comment.getData().trim().startsWith("CONFIGURATION")) {
                startIndex = i;
                continue;
            }
            if (!comment.getData().trim().startsWith("ENDCONFIGURATION")) continue;
            endIndex = i;
        }
        for (i = startIndex + 1; i < endIndex; ++i) {
            root.removeChild(childNodes.item(startIndex).getNextSibling());
        }
        Node nextSibling = childNodes.item(startIndex).getNextSibling();
        NodeList replacementNodes = settingsAppliedDocument.getDocumentElement().getChildNodes();
        for (int i3 = 0; i3 < replacementNodes.getLength(); ++i3) {
            Node newNode = doc.importNode(replacementNodes.item(i3), true);
            root.insertBefore(newNode, nextSibling);
        }
        maker.writeXML(new StreamResult(settingsApplideOutputFileName), doc);
        System.out.println("Wrote " + settingsApplideOutputFileName);
    }

    private static void makeAllComCamXML(File outputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        int i;
        Mapping mapping = Main.createMapping(null);
        outputLocation.mkdirs();
        File outputFileName = new File(outputLocation, "CCCamera_Telemetry.xml");
        String cscName = "CCCamera";
        XMLMaker2 maker = new XMLMaker2(false);
        Document document = maker.createDocument(XMLMaker2.SALType.TELEMETRY);
        String file1 = "comcam-fcs-status-dictionary.ser";
        StatusDataProviderDictionary dictionary1 = Main.readFromPath(file1);
        String file1a = "comcam-bonn-shutter-status-dictionary.ser";
        StatusDataProviderDictionary dictionary1a = Main.readFromPath(file1a);
        String file2 = "comcam-daq-monitor-status-dictionary.ser";
        StatusDataProviderDictionary dictionary2 = Main.readFromPath(file2);
        String file3 = "comcam-rebpower-status-dictionary.ser";
        StatusDataProviderDictionary dictionary3 = Main.readFromPath(file3);
        String file4 = "comcam-vacuum-status-dictionary.ser";
        StatusDataProviderDictionary dictionary4 = Main.readFromPath(file4);
        String file5 = "comcam-quadbox-status-dictionary.ser";
        StatusDataProviderDictionary dictionary5 = Main.readFromPath(file5);
        String file6 = "comcam-fp-status-dictionary.ser";
        StatusDataProviderDictionary dictionary6 = Main.readFromPath(file6);
        String file7 = "comcam-ih-status-dictionary.ser";
        StatusDataProviderDictionary dictionary7 = Main.readFromPath(file7);
        String file8 = "comcam-mpm-status-dictionary.ser";
        StatusDataProviderDictionary dictionary8 = Main.readFromPath(file8);
        maker.addXMLFromMonitoringDictionary(document, dictionary1, cscName, "fcs", 0, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary1a, cscName, "bonn_shutter", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary2, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary3, cscName, "rebpower", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary4, cscName, "vacuum", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary5, cscName, "quadbox", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary6, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary8, cscName, "mpm", 1, mapping);
        maker.writeXML(new StreamResult(outputFileName), document);
        System.out.println("Wrote " + outputFileName);
        File settingsAppliedOutputFileName = new File(outputLocation, "CCCamera_Events.xml");
        Document settingsAppliedDocument = maker.createDocument(XMLMaker2.SALType.SETTINGS_APPLIED);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1, cscName, "fcs", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1a, cscName, "bonn_shutter", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary2, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary3, cscName, "rebpower", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary4, cscName, "vacuum", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary5, cscName, "quadbox", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary6, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary7, cscName, "image_handling", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary8, cscName, "mpm", 1, mapping);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(settingsAppliedOutputFileName);
        XPath xp = XPathFactory.newInstance().newXPath();
        NodeList nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            node.getParentNode().removeChild(node);
        }
        Element root = doc.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        int startIndex = 0;
        int endIndex = 0;
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Comment)) continue;
            Comment comment = (Comment)node;
            if (comment.getData().trim().startsWith("CONFIGURATION")) {
                startIndex = i;
                continue;
            }
            if (!comment.getData().trim().startsWith("ENDCONFIGURATION")) continue;
            endIndex = i;
        }
        for (i = startIndex + 1; i < endIndex; ++i) {
            root.removeChild(childNodes.item(startIndex).getNextSibling());
        }
        Node nextSibling = childNodes.item(startIndex).getNextSibling();
        NodeList replacementNodes = settingsAppliedDocument.getDocumentElement().getChildNodes();
        for (int i3 = 0; i3 < replacementNodes.getLength(); ++i3) {
            Node newNode = doc.importNode(replacementNodes.item(i3), true);
            root.insertBefore(newNode, nextSibling);
        }
        maker.writeXML(new StreamResult(settingsAppliedOutputFileName), doc);
        System.out.println("Wrote " + settingsAppliedOutputFileName);
    }

    private static void makeAllMainCameraXML(File outputLocation) throws IOException, ParserConfigurationException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        int i;
        XMLMaker2 maker = new XMLMaker2(false);
        Document document = maker.createDocument(XMLMaker2.SALType.TELEMETRY);
        String file1 = "daq-monitor-status-dictionary.ser";
        StatusDataProviderDictionary dictionary1 = Main.readFromPath(file1);
        String file2 = "rebpower-status-dictionary.ser";
        StatusDataProviderDictionary dictionary2 = Main.readFromPath(file2);
        String file3 = "quadbox-status-dictionary.ser";
        StatusDataProviderDictionary dictionary3 = Main.readFromPath(file3);
        String file4 = "hex-status-dictionary.ser";
        StatusDataProviderDictionary dictionary4 = Main.readFromPath(file4);
        String file5 = "refrig-status-dictionary.ser";
        StatusDataProviderDictionary dictionary5 = Main.readFromPath(file5);
        String file6 = "vacuum-status-dictionary.ser";
        StatusDataProviderDictionary dictionary6 = Main.readFromPath(file6);
        String file7 = "focal-plane-status-dictionary.ser";
        StatusDataProviderDictionary dictionary7 = Main.readFromPath(file7);
        String file8 = "image-handling-lsst-dc01-status-dictionary.ser";
        StatusDataProviderDictionary dictionary8 = Main.readFromPath(file8);
        String file9 = "fcs-status-dictionary.ser";
        StatusDataProviderDictionary dictionary9 = Main.readFromPath(file9);
        String file10 = "cam-shutter-status-dictionary.ser";
        StatusDataProviderDictionary dictionary10 = Main.readFromPath(file10);
        File outputFileName = new File(outputLocation, "MTCamera_Telemetry.xml");
        String cscName = "MTCamera";
        Mapping mapping = Main.createMapping(null);
        maker.addXMLFromMonitoringDictionary(document, dictionary3, cscName, "quadbox", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary2, cscName, "rebpower", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary4, cscName, "hex", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary5, cscName, "refrig", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary6, cscName, "vacuum", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary1, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromMonitoringDictionary(document, dictionary7, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromTrendingDictionary(document, dictionary9, cscName, "fcs", 0, mapping);
        maker.addXMLFromTrendingDictionary(document, dictionary10, cscName, "shutter", 0, mapping);
        maker.writeXML(new StreamResult(outputFileName), document);
        System.out.println("Wrote " + outputFileName);
        File settingsAppliedOutputFileName = new File(outputLocation, "MTCamera_Events.xml");
        Document settingsAppliedDocument = maker.createDocument(XMLMaker2.SALType.SETTINGS_APPLIED);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary3, cscName, "quadbox", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary2, cscName, "rebpower", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary4, cscName, "hex", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary5, cscName, "refrig", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary6, cscName, "vacuum", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1, cscName, "daq_monitor", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary7, cscName, "focal_plane", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary8, cscName, "image_handling", 1, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary9, cscName, "fcs", 0, mapping);
        maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary10, cscName, "shutter", 0, mapping);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(settingsAppliedOutputFileName);
        XPath xp = XPathFactory.newInstance().newXPath();
        NodeList nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            node.getParentNode().removeChild(node);
        }
        Element root = doc.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        int startIndex = 0;
        int endIndex = 0;
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Comment)) continue;
            Comment comment = (Comment)node;
            if (comment.getData().trim().startsWith("CONFIGURATION")) {
                startIndex = i;
                continue;
            }
            if (!comment.getData().trim().startsWith("ENDCONFIGURATION")) continue;
            endIndex = i;
        }
        for (i = startIndex + 1; i < endIndex; ++i) {
            root.removeChild(childNodes.item(startIndex).getNextSibling());
        }
        Node nextSibling = childNodes.item(startIndex).getNextSibling();
        NodeList replacementNodes = settingsAppliedDocument.getDocumentElement().getChildNodes();
        for (int i3 = 0; i3 < replacementNodes.getLength(); ++i3) {
            Node newNode = doc.importNode(replacementNodes.item(i3), true);
            root.insertBefore(newNode, nextSibling);
        }
        maker.writeXML(new StreamResult(settingsAppliedOutputFileName), doc);
        System.out.println("Wrote " + settingsAppliedOutputFileName);
    }
}

