/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class ShutterMotionProfileSenderTest {
    @Test
    public void testProcessMotionDone() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ImageName obsId = new ImageName("MC_C_20230603_000001");
        ShutterMotionProfileSender sender = new ShutterMotionProfileSender();
        JsonFile processMotionDone = sender.processMotionDone(obsId, md, true, new ShutterMotionProfileFitter());
        System.out.println(processMotionDone);
        List<String> lines = Arrays.asList(processMotionDone.toString().split("\\n"));
        Assert.assertTrue((boolean)lines.contains("      \"sensorId\" : 1,"));
        Assert.assertTrue((boolean)lines.contains("      \"position\" : 32.2411264996,"));
    }

    @Test
    public void testHallSensorFit() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter();
        double[] fitResult = fitter.doHallSensorFit(md);
        System.out.println(Arrays.toString(fitResult));
        Assert.assertEquals((double)3.1517040414607303E-4, (double)fitResult[0], (double)1.0E-7);
        Assert.assertEquals((double)0.22440603364449146, (double)fitResult[1], (double)1.0E-7);
        Assert.assertEquals((double)0.6764735603322182, (double)fitResult[2], (double)1.0E-7);
        Assert.assertEquals((double)33084.938542418866, (double)fitResult[3], (double)1.0E-7);
        Assert.assertEquals((double)-32922.74736320363, (double)fitResult[4], (double)1.0E-7);
        Assert.assertEquals((double)33699.01584291877, (double)fitResult[5], (double)1.0E-7);
    }

    @Test
    public void testMotorEncoderFit() throws IOException, ClassNotFoundException {
        MotionDone md = this.readMotionDone();
        ShutterMotionProfileFitter fitter = new ShutterMotionProfileFitter();
        double[] fitResult = fitter.doMotorEncoderFit(md);
        System.out.println(Arrays.toString(fitResult));
        Assert.assertEquals((double)2.876504287742699E-4, (double)fitResult[0], (double)1.0E-7);
        Assert.assertEquals((double)0.2249064191219523, (double)fitResult[1], (double)1.0E-7);
        Assert.assertEquals((double)0.6765971136955028, (double)fitResult[2], (double)1.0E-7);
        Assert.assertEquals((double)32950.83746944349, (double)fitResult[3], (double)1.0E-7);
        Assert.assertEquals((double)-32870.04398953447, (double)fitResult[4], (double)1.0E-7);
        Assert.assertEquals((double)33418.0239489634, (double)fitResult[5], (double)1.0E-7);
    }

    /*
     * Exception decompiling
     */
    private MotionDone readMotionDone() throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

