/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class TakeImageWithClearTest {
    private OCSBridge ocsBridge;
    private final GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @Before
    public void setUp() {
        MCMConfig mcmConfig = MCMConfig.createNewDefaultConfig();
        this.ocsBridge = OCSBridge.createOCSBridge((MCMConfig)mcmConfig);
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void takeImages() throws InterruptedException, ExecutionException, TimeoutException {
        int i;
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        System.out.println(this.ocsBridge.getCCS().getAggregateStatus().getStates());
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{MCM.TakeImageReadinessState.READY}));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new TakeImagesCommand(2, 5.0, true, "", "imageType: mockturtle002, groupId: group", "annotation"));
        TimeUnit.SECONDS.sleep(16L);
        Assert.assertEquals((long)21L, (long)tl.getCalls());
        System.out.println(this.ocsBridge.getCCS().getAggregateStatus().getStates());
        System.out.println(tl.getFinalStates());
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{FocalPlane.RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        this.executor.printEventList("TakeImagesTest,takeImages()");
        Assert.assertEquals((long)21L, (long)states.size());
        Assert.assertEquals((Object)states.get(0), (Object)CCSCommandStateEvent.CCSCommandState.BUSY);
        tl.printFinalStates("TakeImagesTest,takeImages()");
        fsh.printStateHistory("TakeImagesTest,takeImages()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{FocalPlane.RaftsState.CLEARING, FocalPlane.RaftsState.QUIESCENT, FocalPlane.RaftsState.INTEGRATING, FocalPlane.RaftsState.READING_OUT, FocalPlane.RaftsState.QUIESCENT, FocalPlane.RaftsState.INTEGRATING, FocalPlane.RaftsState.READING_OUT, FocalPlane.RaftsState.QUIESCENT, FocalPlane.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        System.out.println(" List of states from takeImagesTest - two images :");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        Assert.assertEquals((long)16L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartIntegrationEvent.class, StartReadoutEvent.class, EndReadoutEvent.class, StartIntegrationEvent.class, StartReadoutEvent.class, EndReadoutEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(EndReadoutEvent.class, EndReadoutEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        Assert.assertEquals((double)5.0, (double)event1.getExposureTime(), (double)1.0E-12);
        ImageName imageName1 = new ImageName(event1.getImageName());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        Assert.assertEquals((double)5.0, (double)event2.getExposureTime(), (double)1.0E-12);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
    }
}

