package org.lsst.ccs.subsystem.ocsbridge;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSimulateFaultCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSetAvailableCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSRevokeAvailableCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSClearFaultCommand;
import org.lsst.ccs.subsystem.ocsbridge.config.Device;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.PlayCommand;
import org.lsst.sal.camera.command.PlaylistCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;

/**
 *
 * @author tonyj
 */
public final class ToyOCSGUI extends javax.swing.JFrame {

    private static final long serialVersionUID = -7536384356408611374L;

    private GUILayer guiInterface;
    private Map<String, JComboBox> statusMap = new HashMap<>();

    /**
     * Creates new form ToyOCSGUI
     *
     * @param guiLayer
     */
    ToyOCSGUI(GUILayer guiLayer, Device device) {
        this.guiInterface = guiLayer;
        initializeFontSize();
        initComponents();
        if (!guiLayer.supportsCCSCommands()) {
            remove(commandPanel2);
        }
        if (device == Device.AUXTEL) {
            commandPanel1.remove(setFilterButton);
            commandPanel1.remove(filterComboBox);
            //commandPanel1.remove(initGuidersButton);
            //commandPanel1.remove(roiSpecTextField);
            //commandPanel1.remove(roiLabel);
        }
        this.setTitle("OCS GUI for " + device);
        guiLayer.addStateChangeListener((CameraStateChangeEvent csce) -> {
            SALEnum substate = csce.getSubstate();
            Enum aEnum = substate.getEnum();
            SwingUtilities.invokeLater(() -> {
                JComboBox combo = statusMap.get(aEnum.getClass().getSimpleName());
                if (combo == null) {
                    combo = createStateComboBox(aEnum);
                    statusPanel.revalidate();
                }
                combo.setSelectedItem(aEnum);

            });
        });
        DefaultComboBoxModel<String> availableFilters = new DefaultComboBoxModel<>(new String[]{"NONE"});
        filterComboBox.setModel(availableFilters);
        guiLayer.addEventListener((CameraEvent event) -> {
            if (event instanceof AvailableFiltersEvent) {
                final String filters = ((AvailableFiltersEvent) event).getFilterNames();
                SwingUtilities.invokeLater(() -> {
                    availableFilters.removeAllElements();
                    for (String filter : filters.split(":")) {
                        availableFilters.addElement(filter);
                    }
                });
            }
        });

        Logger logger = Logger.getLogger(OCSBridge.class.getName()).getParent();
        TextAreaHandler handler = new TextAreaHandler();
        handler.setFormatter(new Formatter() {

            @Override
            public String format(LogRecord record) {

                return String.format("[%tc] %s\n", record.getMillis(), formatMessage(record));
            }

        });
        logger.addHandler(handler);
    }

    private void initializeFontSize() {
        String fontSizeParam = System.getProperty("ocs-gui.fontSize");
        if (fontSizeParam != null) {
            float multiplier = Integer.parseInt(fontSizeParam) / 100.0f;
            UIDefaults defaults = UIManager.getDefaults();
            int i = 0;
            for (Enumeration e = defaults.keys(); e.hasMoreElements(); i++) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (value instanceof Font) {
                    Font font = (Font) value;
                    int newSize = Math.round(font.getSize() * multiplier);
                    if (value instanceof FontUIResource) {
                        defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), newSize));
                    } else {
                        defaults.put(key, new Font(font.getName(), font.getStyle(), newSize));
                    }
                }
            }
        }
    }

    private JComboBox createStateComboBox(Enum state) {
        String name = state.getClass().getSimpleName();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(name));
        box.add(Box.createHorizontalStrut(10));
        JComboBox combo = new JComboBox(state.getClass().getEnumConstants());
        combo.setEditable(false);
        combo.setSelectedItem(state);
        setReadonly(combo);
        box.add(combo);
        box.add(Box.createHorizontalGlue());
        statusPanel.add(box);
        statusMap.put(name, combo);
        return combo;
    }

    /**
     * Taken from http://stackoverflow.com/questions/23500183
     */
    private void setReadonly(JComboBox combo) {
        Component editorComponent = combo.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            ((JTextField) editorComponent).setEditable(false);
        }

        for (Component childComponent : combo.getComponents()) {
            if (childComponent instanceof AbstractButton) {
                childComponent.setEnabled(false);
                final MouseListener[] listeners = childComponent.getListeners(MouseListener.class);
                for (MouseListener listener : listeners) {
                    childComponent.removeMouseListener(listener);
                }
            }
        }

        final MouseListener[] mouseListeners = combo.getListeners(MouseListener.class);
        for (MouseListener listener : mouseListeners) {
            combo.removeMouseListener(listener);
        }

        final KeyListener[] keyListeners = combo.getListeners(KeyListener.class);
        for (KeyListener keyListener : keyListeners) {
            combo.removeKeyListener(keyListener);
        }

        combo.setFocusable(false);

        //box.getActionMap().clear(); //no effect
        //box.getInputMap().clear();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        statusPanel = new javax.swing.JPanel();
        commandPanel2 = new javax.swing.JPanel();
        setAvailableButton = new javax.swing.JButton();
        revokeAvailableButton = new javax.swing.JButton();
        simulateFault = new javax.swing.JButton();
        clearFaultButton = new javax.swing.JButton();
        javax.swing.JPanel commandPanel = new javax.swing.JPanel();
        enterControlButton = new javax.swing.JButton();
        exitButton = new javax.swing.JButton();
        startButton = new javax.swing.JButton();
        standbyButton = new javax.swing.JButton();
        enableButton = new javax.swing.JButton();
        disableButton = new javax.swing.JButton();
        startTextField = new javax.swing.JTextField();
        commandPanel1 = new javax.swing.JPanel();
        initImageButton = new javax.swing.JButton();
        javax.swing.JLabel jLabel4 = new javax.swing.JLabel();
        deltaTSpinner = new javax.swing.JSpinner();
        takeImagesButton = new javax.swing.JButton();
        javax.swing.JLabel jLabel5 = new javax.swing.JLabel();
        nImagesSpinner = new javax.swing.JSpinner();
        javax.swing.JLabel jLabel6 = new javax.swing.JLabel();
        exposureSpinner = new javax.swing.JSpinner();
        openShutterCheckBox = new javax.swing.JCheckBox();
        setFilterButton = new javax.swing.JButton();
        filterComboBox = new javax.swing.JComboBox();
        sensorsTextField = new javax.swing.JTextField();
        initGuidersButton = new javax.swing.JButton();
        roiSpecTextField = new javax.swing.JTextField();
        roiLabel = new javax.swing.JLabel();
        enableCalibrationButton = new javax.swing.JButton();
        disableCalibrationButton = new javax.swing.JButton();
        keyValueTextField = new javax.swing.JTextField();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel8 = new javax.swing.JLabel();
        obsNoteTextField = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        clearButton = new javax.swing.JButton();
        nClearSpinner = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        startImageButton = new javax.swing.JButton();
        openShutterCheckBox1 = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        timeoutSpinner = new javax.swing.JSpinner();
        endImageButton = new javax.swing.JButton();
        discardRowsButton = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        discardRowsSpinner = new javax.swing.JSpinner();
        sensorTextField1 = new javax.swing.JTextField();
        keyValueTextField1 = new javax.swing.JTextField();
        javax.swing.JLabel jLabel9 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel10 = new javax.swing.JLabel();
        obsNoteTextField1 = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        playButton = new javax.swing.JButton();
        jLabel11 = new javax.swing.JLabel();
        playlistButton = new javax.swing.JButton();
        playlistTextField2 = new javax.swing.JTextField();
        daqFolderTextField = new javax.swing.JTextField();
        javax.swing.JLabel jLabel14 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel15 = new javax.swing.JLabel();
        imagesTextField = new javax.swing.JTextField();
        playlistTextField1 = new javax.swing.JTextField();
        repeatCheckBox = new javax.swing.JCheckBox();
        javax.swing.JLabel jLabel13 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        logTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        statusPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Status"));
        statusPanel.setLayout(new javax.swing.BoxLayout(statusPanel, javax.swing.BoxLayout.PAGE_AXIS));

        commandPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("CCS Commands"));

        setAvailableButton.setText("setAvailable");
        setAvailableButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setAvailableButtonActionPerformed(evt);
            }
        });

        revokeAvailableButton.setText("revokeAvailable");
        revokeAvailableButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                revokeAvailableButtonActionPerformed(evt);
            }
        });

        simulateFault.setText("simulateFault");
        simulateFault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                simulateFaultActionPerformed(evt);
            }
        });

        clearFaultButton.setText("clearFault");
        clearFaultButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearFaultButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout commandPanel2Layout = new javax.swing.GroupLayout(commandPanel2);
        commandPanel2.setLayout(commandPanel2Layout);
        commandPanel2Layout.setHorizontalGroup(
            commandPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanel2Layout.createSequentialGroup()
                .addComponent(setAvailableButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(revokeAvailableButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(simulateFault)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(clearFaultButton)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        commandPanel2Layout.setVerticalGroup(
            commandPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanel2Layout.createSequentialGroup()
                .addGroup(commandPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(setAvailableButton)
                    .addComponent(revokeAvailableButton)
                    .addComponent(simulateFault)
                    .addComponent(clearFaultButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        commandPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("OCS Lifecycle Commands"));

        enterControlButton.setText("enterControl");
        enterControlButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enterControlButtonActionPerformed(evt);
            }
        });

        exitButton.setText("exitControl");
        exitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitButtonActionPerformed(evt);
            }
        });

        startButton.setText("start");
        startButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });

        standbyButton.setText("standby");
        standbyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                standbyButtonActionPerformed(evt);
            }
        });

        enableButton.setText("enable");
        enableButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableButtonActionPerformed(evt);
            }
        });

        disableButton.setText("disable");
        disableButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disableButtonActionPerformed(evt);
            }
        });

        startTextField.setColumns(20);
        startTextField.setText("Normal");
        startTextField.setToolTipText("Configuration name");

        javax.swing.GroupLayout commandPanelLayout = new javax.swing.GroupLayout(commandPanel);
        commandPanel.setLayout(commandPanelLayout);
        commandPanelLayout.setHorizontalGroup(
            commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanelLayout.createSequentialGroup()
                .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(commandPanelLayout.createSequentialGroup()
                        .addComponent(enterControlButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(exitButton))
                    .addGroup(commandPanelLayout.createSequentialGroup()
                        .addComponent(startButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(startTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(standbyButton))
                    .addGroup(commandPanelLayout.createSequentialGroup()
                        .addComponent(enableButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(disableButton)))
                .addGap(0, 0, Short.MAX_VALUE))
        );
        commandPanelLayout.setVerticalGroup(
            commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanelLayout.createSequentialGroup()
                .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(enterControlButton)
                    .addComponent(exitButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(startButton)
                    .addComponent(startTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(standbyButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(enableButton)
                    .addComponent(disableButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        commandPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("OCS Camera Commands"));

        initImageButton.setText("initImage");
        initImageButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                initImageButtonActionPerformed(evt);
            }
        });

        jLabel4.setLabelFor(deltaTSpinner);
        jLabel4.setText("deltaT");

        deltaTSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(15.0f), Float.valueOf(0.1f)));

        takeImagesButton.setText("takeImages");
        takeImagesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                takeImagesButtonActionPerformed(evt);
            }
        });

        jLabel5.setLabelFor(nImagesSpinner);
        jLabel5.setText("nImages");

        nImagesSpinner.setModel(new javax.swing.SpinnerNumberModel(2, 0, 20, 1));

        jLabel6.setLabelFor(exposureSpinner);
        jLabel6.setText("exposure");

        exposureSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(15.0f), Float.valueOf(0.0f), Float.valueOf(30.0f), Float.valueOf(1.0f)));

        openShutterCheckBox.setSelected(true);
        openShutterCheckBox.setText("openShutter");
        openShutterCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        setFilterButton.setText("setFilter");
        setFilterButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setFilterButtonActionPerformed(evt);
            }
        });

        filterComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        sensorsTextField.setColumns(15);
        sensorsTextField.setToolTipText("Sensors");

        initGuidersButton.setText("initGuiders");
        initGuidersButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                initGuidersButtonActionPerformed(evt);
            }
        });

        roiSpecTextField.setColumns(20);
        roiSpecTextField.setText("{ \"common\": { \"rows\": 50, \"cols\": 50, \"integrationTimeMillis\": 100}, \"R00SG0\": { \"segment\": 10, \"startRow\": 100, \"startCol\": 200}, \"R00SG1\": { \"segment\": 7, \"startRow\": 50, \"startCol\": 150} } ");
        roiSpecTextField.setToolTipText("ROI Specification");

        roiLabel.setText("roiSpec");

        enableCalibrationButton.setText("enableCalibration");
        enableCalibrationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableCalibrationButtonActionPerformed(evt);
            }
        });

        disableCalibrationButton.setText("disableCalibration");
        disableCalibrationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disableCalibrationButtonActionPerformed(evt);
            }
        });

        keyValueTextField.setColumns(15);
        keyValueTextField.setText("imageType: test, groupId: test");
        keyValueTextField.setToolTipText("KeyValueMap");

        jLabel1.setText("Sensors");

        jLabel8.setText("keyValues");

        obsNoteTextField.setColumns(15);
        obsNoteTextField.setText("Test");
        obsNoteTextField.setToolTipText("Obs Note");

        javax.swing.GroupLayout commandPanel1Layout = new javax.swing.GroupLayout(commandPanel1);
        commandPanel1.setLayout(commandPanel1Layout);
        commandPanel1Layout.setHorizontalGroup(
            commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanel1Layout.createSequentialGroup()
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(commandPanel1Layout.createSequentialGroup()
                        .addComponent(initGuidersButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(roiLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(roiSpecTextField))
                    .addGroup(commandPanel1Layout.createSequentialGroup()
                        .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(commandPanel1Layout.createSequentialGroup()
                                .addComponent(initImageButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(deltaTSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(commandPanel1Layout.createSequentialGroup()
                                .addComponent(setFilterButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(filterComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(commandPanel1Layout.createSequentialGroup()
                                .addComponent(enableCalibrationButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(disableCalibrationButton)))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(commandPanel1Layout.createSequentialGroup()
                        .addComponent(takeImagesButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nImagesSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(exposureSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(openShutterCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sensorsTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel8)
                        .addGap(3, 3, 3)
                        .addComponent(keyValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(obsNoteTextField)))
                .addGap(6, 6, 6))
        );
        commandPanel1Layout.setVerticalGroup(
            commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commandPanel1Layout.createSequentialGroup()
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(initImageButton)
                    .addComponent(jLabel4)
                    .addComponent(deltaTSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(takeImagesButton)
                    .addComponent(jLabel5)
                    .addComponent(nImagesSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6)
                    .addComponent(exposureSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(openShutterCheckBox)
                    .addComponent(sensorsTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(keyValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel8)
                    .addComponent(obsNoteTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(setFilterButton)
                    .addComponent(filterComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(initGuidersButton)
                    .addComponent(roiSpecTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(roiLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(commandPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(enableCalibrationButton)
                    .addComponent(disableCalibrationButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("OCS Camera Calibration Commands"));

        clearButton.setText("clear");
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        nClearSpinner.setModel(new javax.swing.SpinnerNumberModel(1, 1, 1000, 1));

        jLabel2.setText("n");

        startImageButton.setText("startImage");
        startImageButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startImageButtonActionPerformed(evt);
            }
        });

        openShutterCheckBox1.setSelected(true);
        openShutterCheckBox1.setText("openShutter");
        openShutterCheckBox1.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        jLabel7.setText("timeout");

        timeoutSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(15.0f), Float.valueOf(0.0f), Float.valueOf(30.0f), Float.valueOf(1.0f)));

        endImageButton.setText("endImage");
        endImageButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                endImageButtonActionPerformed(evt);
            }
        });

        discardRowsButton.setText("discardRows");
        discardRowsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                discardRowsButtonActionPerformed(evt);
            }
        });

        jLabel3.setText("rows");

        discardRowsSpinner.setModel(new javax.swing.SpinnerNumberModel(1, 1, 1000, 1));

        sensorTextField1.setColumns(15);
        sensorTextField1.setToolTipText("Sensor locations");

        keyValueTextField1.setColumns(15);
        keyValueTextField1.setText("imageType: bias, groupId: g");
        keyValueTextField1.setToolTipText("GroupdId");

        jLabel9.setText("Sensors");

        jLabel10.setText("keyValues");

        obsNoteTextField1.setColumns(15);
        obsNoteTextField1.setText("Annotation");
        obsNoteTextField1.setToolTipText("Obs Note");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(clearButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nClearSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(startImageButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(openShutterCheckBox1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sensorTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(keyValueTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(obsNoteTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel7)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(timeoutSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(endImageButton)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(discardRowsButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(discardRowsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(0, 0, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(clearButton)
                    .addComponent(nClearSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(startImageButton)
                    .addComponent(openShutterCheckBox1)
                    .addComponent(timeoutSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7)
                    .addComponent(jLabel9)
                    .addComponent(sensorTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel10)
                    .addComponent(keyValueTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(obsNoteTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(endImageButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(discardRowsButton)
                    .addComponent(jLabel3)
                    .addComponent(discardRowsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Playlist Commands"));

        playButton.setText("play");
        playButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playButtonActionPerformed(evt);
            }
        });

        jLabel11.setText("playlist");

        playlistButton.setText("playList");
        playlistButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playlistButtonActionPerformed(evt);
            }
        });

        playlistTextField2.setColumns(15);
        playlistTextField2.setToolTipText("Sensor locations");

        daqFolderTextField.setColumns(8);
        daqFolderTextField.setText("emu");
        daqFolderTextField.setToolTipText("DAQ Folder");

        jLabel14.setText("playlist");

        jLabel15.setText("folder");

        imagesTextField.setColumns(15);
        imagesTextField.setToolTipText("Image List");

        playlistTextField1.setColumns(15);

        repeatCheckBox.setSelected(true);
        repeatCheckBox.setText("repeat");
        repeatCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        jLabel13.setText("images");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(playButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel11)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(playlistTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(repeatCheckBox)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(playlistButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel14)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(playlistTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel15)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(daqFolderTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(6, 6, 6)
                        .addComponent(jLabel13)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(imagesTextField)))
                .addGap(12, 12, 12))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(playButton)
                        .addComponent(jLabel11))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(playlistTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(repeatCheckBox)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(playlistButton)
                    .addComponent(jLabel14)
                    .addComponent(playlistTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel15)
                    .addComponent(daqFolderTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(imagesTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel13))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        logTextArea.setEditable(false);
        logTextArea.setColumns(80);
        logTextArea.setRows(20);
        jScrollPane2.setViewportView(logTextArea);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(statusPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(commandPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(commandPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(commandPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 1386, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(commandPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(commandPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(commandPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(2, 2, 2)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 391, Short.MAX_VALUE))
        );

        jPanel2.getAccessibleContext().setAccessibleName("Playlist commands");

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void enterControlButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enterControlButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new EnterControlCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_enterControlButtonActionPerformed

    private void exitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new ExitControlCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_exitButtonActionPerformed

    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startButtonActionPerformed
        String configuration = startTextField.getText();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new StartCommand(configuration));
                return null;
            }
        };
        sw.execute();

    }//GEN-LAST:event_startButtonActionPerformed

    private void standbyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_standbyButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new StandbyCommand());
                return null;
            }
        };
        sw.execute();    }//GEN-LAST:event_standbyButtonActionPerformed

    private void enableButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new EnableCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_enableButtonActionPerformed

    private void disableButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disableButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new DisableCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_disableButtonActionPerformed

    private void setAvailableButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setAvailableButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new CCSSetAvailableCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_setAvailableButtonActionPerformed

    private void revokeAvailableButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_revokeAvailableButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new CCSRevokeAvailableCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_revokeAvailableButtonActionPerformed

    private void simulateFaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_simulateFaultActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new CCSSimulateFaultCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_simulateFaultActionPerformed

    private void clearFaultButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearFaultButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new CCSClearFaultCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_clearFaultButtonActionPerformed

    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        int nClears = ((Number) nClearSpinner.getModel().getValue()).intValue();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new ClearCommand(nClears));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_clearButtonActionPerformed

    private void startImageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startImageButtonActionPerformed
        boolean openShutter = openShutterCheckBox1.isSelected();
        float timeout = ((Number) timeoutSpinner.getModel().getValue()).floatValue();
        String sensors = sensorTextField1.getText();
        String keyValueData = keyValueTextField1.getText();
        String annotation = obsNoteTextField1.getText();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new StartImageCommand(openShutter, sensors, keyValueData, annotation, timeout));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_startImageButtonActionPerformed

    private void endImageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_endImageButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new EndImageCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_endImageButtonActionPerformed

    private void discardRowsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_discardRowsButtonActionPerformed
        int nRows = ((Number) discardRowsSpinner.getModel().getValue()).intValue();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new DiscardRowsCommand(nRows));
                return null;
            }
        };
        sw.execute();    }//GEN-LAST:event_discardRowsButtonActionPerformed

    private void disableCalibrationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disableCalibrationButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new DisableCalibrationCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_disableCalibrationButtonActionPerformed

    private void enableCalibrationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableCalibrationButtonActionPerformed
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new EnableCalibrationCommand());
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_enableCalibrationButtonActionPerformed

    private void initGuidersButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_initGuidersButtonActionPerformed
        String roiSpec = roiSpecTextField.getText();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new InitGuidersCommand(roiSpec));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_initGuidersButtonActionPerformed

    private void setFilterButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setFilterButtonActionPerformed
        String filter = filterComboBox.getSelectedItem().toString();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new SetFilterCommand(filter));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_setFilterButtonActionPerformed

    private void takeImagesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_takeImagesButtonActionPerformed
        int nImages = ((Number) nImagesSpinner.getModel().getValue()).intValue();
        float exposure = ((Number) exposureSpinner.getModel().getValue()).floatValue();
        boolean openShutter = openShutterCheckBox.isSelected();
        String sensors = sensorsTextField.getText();
        String keyValueData = keyValueTextField.getText();
        String annotation = obsNoteTextField.getText();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new TakeImagesCommand(nImages, exposure, openShutter, sensors, keyValueData, annotation));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_takeImagesButtonActionPerformed

    private void initImageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_initImageButtonActionPerformed
        float deltaT = ((Number) deltaTSpinner.getModel().getValue()).floatValue();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new InitImageCommand(deltaT));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_initImageButtonActionPerformed

    private void playlistButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playlistButtonActionPerformed
        String playlist = playlistTextField2.getText();
        String folder = daqFolderTextField.getText();
        String images = imagesTextField.getText();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new PlaylistCommand(playlist, folder, images));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_playlistButtonActionPerformed

    private void playButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playButtonActionPerformed
        String playlist = playlistTextField1.getText();
        boolean repeat = repeatCheckBox.isSelected();
        SwingWorker sw = new SwingWorker() {

            @Override
            protected Object doInBackground() throws Exception {
                guiInterface.execute(new PlayCommand(playlist, repeat));
                return null;
            }
        };
        sw.execute();
    }//GEN-LAST:event_playButtonActionPerformed

    private class TextAreaHandler extends StreamHandler {

        @Override
        public void publish(LogRecord record) {
            super.publish(record);
            flush();
            logTextArea.append(getFormatter().format(record));
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton clearButton;
    private javax.swing.JButton clearFaultButton;
    private javax.swing.JPanel commandPanel1;
    private javax.swing.JPanel commandPanel2;
    private javax.swing.JTextField daqFolderTextField;
    private javax.swing.JSpinner deltaTSpinner;
    private javax.swing.JButton disableButton;
    private javax.swing.JButton disableCalibrationButton;
    private javax.swing.JButton discardRowsButton;
    private javax.swing.JSpinner discardRowsSpinner;
    private javax.swing.JButton enableButton;
    private javax.swing.JButton enableCalibrationButton;
    private javax.swing.JButton endImageButton;
    private javax.swing.JButton enterControlButton;
    private javax.swing.JButton exitButton;
    private javax.swing.JSpinner exposureSpinner;
    private javax.swing.JComboBox filterComboBox;
    private javax.swing.JTextField imagesTextField;
    private javax.swing.JButton initGuidersButton;
    private javax.swing.JButton initImageButton;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextField keyValueTextField;
    private javax.swing.JTextField keyValueTextField1;
    private javax.swing.JTextArea logTextArea;
    private javax.swing.JSpinner nClearSpinner;
    private javax.swing.JSpinner nImagesSpinner;
    private javax.swing.JTextField obsNoteTextField;
    private javax.swing.JTextField obsNoteTextField1;
    private javax.swing.JCheckBox openShutterCheckBox;
    private javax.swing.JCheckBox openShutterCheckBox1;
    private javax.swing.JButton playButton;
    private javax.swing.JButton playlistButton;
    private javax.swing.JTextField playlistTextField1;
    private javax.swing.JTextField playlistTextField2;
    private javax.swing.JCheckBox repeatCheckBox;
    private javax.swing.JButton revokeAvailableButton;
    private javax.swing.JLabel roiLabel;
    private javax.swing.JTextField roiSpecTextField;
    private javax.swing.JTextField sensorTextField1;
    private javax.swing.JTextField sensorsTextField;
    private javax.swing.JButton setAvailableButton;
    private javax.swing.JButton setFilterButton;
    private javax.swing.JButton simulateFault;
    private javax.swing.JButton standbyButton;
    private javax.swing.JButton startButton;
    private javax.swing.JButton startImageButton;
    private javax.swing.JTextField startTextField;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JButton takeImagesButton;
    private javax.swing.JSpinner timeoutSpinner;
    // End of variables declaration//GEN-END:variables
}
