package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;

/**
 *
 * @author tonyj
 */
public class CameraTelemetrySender extends TelemetrySender {

    private final GenericConverter converter;

    public CameraTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);

        Mapping mapping = Mapping.defaultMapping();
        List<String> subSystems = new ArrayList<>();
        Map<String, Class> classMap = new HashMap<>();

        converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

}
