/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FilterChangerSimulation
implements FilterChangerInterface {
    private static final Map<String, FilterType> mainCameraFilters = new LinkedHashMap<String, FilterType>();
    private static final List<String> mainCameraInstalledFilters;
    private static final Map<String, FilterType> comCamFilters;
    private static final List<String> comCamInstalledFilters;
    static final Duration LOAD_TIME;
    static final Duration ROTATION_TIME_PER_DEGREE;
    static final Duration UNLOAD_TIME;
    private final Map<String, FilterType> allFilters;
    private final List<String> installedFilters;
    private final MCMConfig config;
    private String currentFilter;
    private int currentRotationPosition = 0;
    private final CCS ccs;
    private final State filterState;

    FilterChangerSimulation(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        switch (config.getCameraType()) {
            case MAIN_CAMERA: {
                this.allFilters = mainCameraFilters;
                this.currentFilter = "NONE";
                this.installedFilters = mainCameraInstalledFilters;
                break;
            }
            case COMCAM: {
                this.allFilters = comCamFilters;
                this.installedFilters = comCamInstalledFilters;
                this.currentFilter = comCamInstalledFilters.get(0);
                break;
            }
            default: {
                throw new RuntimeException("Filter changer not supported for " + config.getCameraType());
            }
        }
        this.filterState = new State<FilterChanger.FilterState>(FilterChanger.FilterState.UNLOADED);
        ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), this.filterState);
    }

    @Override
    public Map<String, String> getAvailableFilters() {
        return this.allFilters.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((FilterType)((Object)((Object)entry.getValue()))).name().toLowerCase()));
    }

    @Override
    public List<String> getInstalledFilters() {
        return Collections.unmodifiableList(this.installedFilters);
    }

    @Override
    public void start(String configName) {
    }

    @Override
    public String getCurrentFilter() {
        return this.currentFilter;
    }

    @Override
    public void setFilter(String filterName) {
        try {
            int position = this.getInstalledFilters().indexOf(filterName);
            if (position < 0) {
                throw new IllegalArgumentException("Invalid or uninstalled filter: " + filterName);
            }
            FilterType requestedFilterType = this.allFilters.get(filterName);
            this.ccs.fireEvent((CCSEvent)new CCSSetFilterEvent(filterName, requestedFilterType.name().toLowerCase()));
            int targetRotation = -1;
            if (!filterName.equals(this.currentFilter)) {
                if (requestedFilterType == FilterType.NONE) {
                    this.filterState.setState(FilterChanger.FilterState.UNLOADING);
                    CompletableFuture<Void> waitForUnloaded = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                    this.ccs.schedule(UNLOAD_TIME, () -> {
                        this.filterState.setState(FilterChanger.FilterState.UNLOADED);
                        this.currentFilter = filterName;
                    });
                    waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                } else {
                    if (this.allFilters.get(this.currentFilter) != FilterType.NONE) {
                        this.filterState.setState(FilterChanger.FilterState.UNLOADING);
                        CompletableFuture<Void> waitForUnloaded = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                        this.ccs.schedule(UNLOAD_TIME, () -> {
                            this.filterState.setState(FilterChanger.FilterState.UNLOADED);
                            this.currentFilter = filterName;
                        });
                        waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    }
                    if (this.currentRotationPosition != (targetRotation = (position - 1) * 360 / 5)) {
                        int degreesToRotate = Math.abs(this.currentRotationPosition - targetRotation) % 360;
                        this.filterState.setState(FilterChanger.FilterState.ROTATING);
                        CompletableFuture<Void> waitForRotation = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                        Duration rotationTime = ROTATION_TIME_PER_DEGREE.multipliedBy(degreesToRotate);
                        this.ccs.schedule(rotationTime, () -> this.filterState.setState(FilterChanger.FilterState.UNLOADED));
                        waitForRotation.get(rotationTime.toMillis() * 2L, TimeUnit.MILLISECONDS);
                        this.currentRotationPosition = targetRotation;
                    }
                    this.filterState.setState(FilterChanger.FilterState.LOADING);
                    CompletableFuture<Void> waitForLoaded = this.ccs.waitForStatus(FilterChanger.FilterState.LOADED);
                    this.ccs.schedule(LOAD_TIME, () -> {
                        this.filterState.setState(FilterChanger.FilterState.LOADED);
                        this.currentFilter = filterName;
                    });
                    waitForLoaded.get(LOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                }
            }
            this.ccs.fireEvent((CCSEvent)new CCSSetFilterEvent(filterName, requestedFilterType.name().toLowerCase(), position, (double)targetRotation));
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new RuntimeException("Error while changing filter", ex);
        }
    }

    @Override
    public Duration getEstimatedDurationForFilterChange(String filterName) {
        return ROTATION_TIME_PER_DEGREE.multipliedBy(360L).plus(LOAD_TIME).plus(UNLOAD_TIME);
    }

    static {
        mainCameraFilters.put("NONE", FilterType.NONE);
        mainCameraFilters.put("u-10", FilterType.U);
        mainCameraFilters.put("g-9", FilterType.G);
        mainCameraFilters.put("r-1", FilterType.R);
        mainCameraFilters.put("i-9", FilterType.I);
        mainCameraFilters.put("z-100", FilterType.Z);
        mainCameraFilters.put("y-99", FilterType.Y);
        mainCameraInstalledFilters = new ArrayList<String>(mainCameraFilters.keySet());
        mainCameraInstalledFilters.remove("y-099");
        comCamFilters = new LinkedHashMap<String, FilterType>();
        comCamFilters.put("u_05", FilterType.U);
        comCamFilters.put("g_07", FilterType.G);
        comCamFilters.put("g_01", FilterType.G);
        comCamFilters.put("r_03", FilterType.R);
        comCamFilters.put("i_06", FilterType.I);
        comCamFilters.put("z_03", FilterType.Z);
        comCamFilters.put("z_02", FilterType.Z);
        comCamFilters.put("y_04", FilterType.Y);
        comCamFilters.put("pinhole", FilterType.OTHER);
        comCamFilters.put("NONE", FilterType.NONE);
        comCamInstalledFilters = new ArrayList<String>();
        comCamInstalledFilters.add("i_06");
        comCamInstalledFilters.add("r_03");
        comCamInstalledFilters.add("g_07");
        LOAD_TIME = Duration.ofMillis(15000L);
        ROTATION_TIME_PER_DEGREE = Duration.ofMillis(100L);
        UNLOAD_TIME = Duration.ofMillis(15000L);
    }

    private static enum FilterType {
        U,
        G,
        R,
        I,
        Z,
        Y,
        NONE,
        OTHER;

    }
}

